/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.foundation.gestures.snapping;

import androidx.compose.animation.SplineBasedDecayKt;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.foundation.ExperimentalFoundationApi;
import androidx.compose.foundation.gestures.FlingBehavior;
import androidx.compose.foundation.gestures.Orientation;
import androidx.compose.foundation.gestures.snapping.FinalSnappingItem;
import androidx.compose.foundation.gestures.snapping.SnapFlingBehaviorKt;
import androidx.compose.foundation.gestures.snapping.SnapLayoutInfoProvider;
import androidx.compose.foundation.gestures.snapping.SnapPositionInLayout;
import androidx.compose.foundation.gestures.snapping.SnapPositionInLayoutKt;
import androidx.compose.foundation.lazy.LazyListItemInfo;
import androidx.compose.foundation.lazy.LazyListLayoutInfo;
import androidx.compose.foundation.lazy.LazyListState;
import androidx.compose.runtime.Composable;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.ComposerKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntSize;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\u001a\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0007\u001a\u0015\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0007\u00a2\u0006\u0002\u0010\r\u001a\u0019\u0010\u000e\u001a\u00020\u000f*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\u0010\u0013\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0014"}, d2={"singleAxisViewportSize", "", "Landroidx/compose/foundation/lazy/LazyListLayoutInfo;", "getSingleAxisViewportSize", "(Landroidx/compose/foundation/lazy/LazyListLayoutInfo;)I", "SnapLayoutInfoProvider", "Landroidx/compose/foundation/gestures/snapping/SnapLayoutInfoProvider;", "lazyListState", "Landroidx/compose/foundation/lazy/LazyListState;", "positionInLayout", "Landroidx/compose/foundation/gestures/snapping/SnapPositionInLayout;", "rememberSnapFlingBehavior", "Landroidx/compose/foundation/gestures/FlingBehavior;", "(Landroidx/compose/foundation/lazy/LazyListState;Landroidx/compose/runtime/Composer;I)Landroidx/compose/foundation/gestures/FlingBehavior;", "calculateFinalSnappingItem", "Landroidx/compose/foundation/gestures/snapping/FinalSnappingItem;", "Landroidx/compose/ui/unit/Density;", "velocity", "", "(Landroidx/compose/ui/unit/Density;F)I", "foundation"})
@SourceDebugExtension(value={"SMAP\nLazyListSnapLayoutInfoProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyListSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/LazyListSnapLayoutInfoProviderKt\n+ 2 Composer.kt\nandroidx/compose/runtime/ComposerKt\n*L\n1#1,155:1\n1117#2,6:156\n*S KotlinDebug\n*F\n+ 1 LazyListSnapLayoutInfoProvider.kt\nandroidx/compose/foundation/gestures/snapping/LazyListSnapLayoutInfoProviderKt\n*L\n127#1:156,6\n*E\n"})
public final class LazyListSnapLayoutInfoProviderKt {
    @ExperimentalFoundationApi
    @NotNull
    public static final SnapLayoutInfoProvider SnapLayoutInfoProvider(@NotNull LazyListState lazyListState, @NotNull SnapPositionInLayout positionInLayout) {
        Intrinsics.checkNotNullParameter(lazyListState, "lazyListState");
        Intrinsics.checkNotNullParameter(positionInLayout, "positionInLayout");
        return new SnapLayoutInfoProvider(lazyListState, positionInLayout){
            final /* synthetic */ LazyListState $lazyListState;
            final /* synthetic */ SnapPositionInLayout $positionInLayout;
            {
                this.$lazyListState = $lazyListState;
                this.$positionInLayout = $positionInLayout;
            }

            private final LazyListLayoutInfo getLayoutInfo() {
                return this.$lazyListState.getLayoutInfo();
            }

            public float calculateApproachOffset(float initialVelocity) {
                DecayAnimationSpec<Float> decayAnimationSpec = SplineBasedDecayKt.splineBasedDecay(this.$lazyListState.getDensity$foundation());
                float offset2 = Math.abs(DecayAnimationSpecKt.calculateTargetValue(decayAnimationSpec, 0.0f, initialVelocity));
                float estimatedNumberOfItemsInDecay = (float)Math.floor(Math.abs(offset2) / this.averageItemSize());
                float approachOffset = estimatedNumberOfItemsInDecay * this.averageItemSize() - this.averageItemSize();
                float finalDecayOffset = RangesKt.coerceAtLeast(approachOffset, 0.0f);
                return finalDecayOffset == 0.0f ? finalDecayOffset : finalDecayOffset * Math.signum(initialVelocity);
            }

            /*
             * WARNING - void declaration
             */
            public float calculateSnappingOffset(float currentVelocity) {
                void $this$fastForEach$iv;
                float lowerBoundOffset = 0.0f;
                lowerBoundOffset = Float.NEGATIVE_INFINITY;
                float upperBoundOffset = 0.0f;
                upperBoundOffset = Float.POSITIVE_INFINITY;
                List<LazyListItemInfo> list2 = this.getLayoutInfo().getVisibleItemsInfo();
                SnapPositionInLayout snapPositionInLayout = this.$positionInLayout;
                boolean $i$f$fastForEach = false;
                int n = $this$fastForEach$iv.size();
                for (int index$iv = 0; index$iv < n; ++index$iv) {
                    E item$iv = $this$fastForEach$iv.get(index$iv);
                    LazyListItemInfo item2 = (LazyListItemInfo)item$iv;
                    boolean bl = false;
                    float offset2 = SnapPositionInLayoutKt.calculateDistanceToDesiredSnapPosition(LazyListSnapLayoutInfoProviderKt.getSingleAxisViewportSize(this.getLayoutInfo()), this.getLayoutInfo().getBeforeContentPadding(), this.getLayoutInfo().getAfterContentPadding(), item2.getSize(), item2.getOffset(), item2.getIndex(), snapPositionInLayout);
                    if (offset2 <= 0.0f && offset2 > lowerBoundOffset) {
                        lowerBoundOffset = offset2;
                    }
                    if (!(offset2 >= 0.0f) || !(offset2 < upperBoundOffset)) continue;
                    upperBoundOffset = offset2;
                }
                Density $this$calculateSnappingOffset_u24lambda_u241 = this.$lazyListState.getDensity$foundation();
                boolean bl = false;
                return SnapFlingBehaviorKt.calculateFinalOffset-Fhqu1e0(LazyListSnapLayoutInfoProviderKt.calculateFinalSnappingItem($this$calculateSnappingOffset_u24lambda_u241, currentVelocity), lowerBoundOffset, upperBoundOffset);
            }

            /*
             * WARNING - void declaration
             */
            public final float averageItemSize() {
                float f;
                LazyListLayoutInfo $this$averageItemSize_u24lambda_u243 = this.getLayoutInfo();
                boolean bl = false;
                if (!((Collection)$this$averageItemSize_u24lambda_u243.getVisibleItemsInfo()).isEmpty()) {
                    List<LazyListItemInfo> $this$fastSumBy$iv = $this$averageItemSize_u24lambda_u243.getVisibleItemsInfo();
                    boolean $i$f$fastSumBy = false;
                    int sum$iv = 0;
                    List<LazyListItemInfo> $this$fastForEach$iv$iv = $this$fastSumBy$iv;
                    boolean $i$f$fastForEach = false;
                    int n = $this$fastForEach$iv$iv.size();
                    for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                        void it;
                        LazyListItemInfo item$iv$iv;
                        LazyListItemInfo element$iv = item$iv$iv = $this$fastForEach$iv$iv.get(index$iv$iv);
                        boolean bl2 = false;
                        LazyListItemInfo lazyListItemInfo = element$iv;
                        int n2 = sum$iv;
                        boolean bl3 = false;
                        int n3 = it.getSize();
                        sum$iv = n2 + n3;
                    }
                    f = (float)sum$iv / (float)$this$averageItemSize_u24lambda_u243.getVisibleItemsInfo().size();
                } else {
                    f = 0.0f;
                }
                return f;
            }
        };
    }

    public static /* synthetic */ SnapLayoutInfoProvider SnapLayoutInfoProvider$default(LazyListState lazyListState, SnapPositionInLayout snapPositionInLayout, int n, Object object) {
        if ((n & 2) != 0) {
            snapPositionInLayout = SnapPositionInLayout.Companion.getCenterToCenter();
        }
        return LazyListSnapLayoutInfoProviderKt.SnapLayoutInfoProvider(lazyListState, snapPositionInLayout);
    }

    /*
     * WARNING - void declaration
     */
    @ExperimentalFoundationApi
    @Composable
    @NotNull
    public static final FlingBehavior rememberSnapFlingBehavior(@NotNull LazyListState lazyListState, @Nullable Composer $composer, int $changed) {
        Object object;
        void $this$cache$iv;
        Intrinsics.checkNotNullParameter(lazyListState, "lazyListState");
        $composer.startReplaceableGroup(1148456277);
        ComposerKt.sourceInformation($composer, "C(rememberSnapFlingBehavior)126@5074L65,127@5151L41:LazyListSnapLayoutInfoProvider.kt#ppz6w6");
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventStart(1148456277, $changed, -1, "androidx.compose.foundation.gestures.snapping.rememberSnapFlingBehavior (LazyListSnapLayoutInfoProvider.kt:125)");
        }
        $composer.startReplaceableGroup(962543248);
        ComposerKt.sourceInformation($composer, "CC(remember):LazyListSnapLayoutInfoProvider.kt#9igjgp");
        Composer composer = $composer;
        boolean invalid$iv = ($changed & 0xE ^ 6) > 4 && $composer.changed(lazyListState) || ($changed & 6) == 4;
        boolean $i$f$cache = false;
        Object it$iv = $this$cache$iv.rememberedValue();
        boolean bl = false;
        if (invalid$iv || it$iv == Composer.Companion.getEmpty()) {
            boolean bl2 = false;
            SnapLayoutInfoProvider value$iv = LazyListSnapLayoutInfoProviderKt.SnapLayoutInfoProvider$default(lazyListState, null, 2, null);
            $this$cache$iv.updateRememberedValue(value$iv);
            object = value$iv;
        } else {
            object = it$iv;
        }
        Object object2 = (SnapLayoutInfoProvider)object;
        $composer.endReplaceableGroup();
        SnapLayoutInfoProvider snappingLayout = object2;
        object2 = SnapFlingBehaviorKt.rememberSnapFlingBehavior(snappingLayout, $composer, 0);
        if (ComposerKt.isTraceInProgress()) {
            ComposerKt.traceEventEnd();
        }
        $composer.endReplaceableGroup();
        return (FlingBehavior)object2;
    }

    public static final int getSingleAxisViewportSize(@NotNull LazyListLayoutInfo $this$singleAxisViewportSize) {
        Intrinsics.checkNotNullParameter($this$singleAxisViewportSize, "<this>");
        return $this$singleAxisViewportSize.getOrientation() == Orientation.Vertical ? IntSize.getHeight-impl($this$singleAxisViewportSize.getViewportSize-YbymL2g()) : IntSize.getWidth-impl($this$singleAxisViewportSize.getViewportSize-YbymL2g());
    }

    public static final int calculateFinalSnappingItem(@NotNull Density $this$calculateFinalSnappingItem, float velocity) {
        Intrinsics.checkNotNullParameter($this$calculateFinalSnappingItem, "<this>");
        return Math.abs(velocity) < $this$calculateFinalSnappingItem.toPx-0680j_4(SnapFlingBehaviorKt.getMinFlingVelocityDp()) ? FinalSnappingItem.Companion.getClosestItem-bbeMdSM() : (velocity > 0.0f ? FinalSnappingItem.Companion.getNextItem-bbeMdSM() : FinalSnappingItem.Companion.getPreviousItem-bbeMdSM());
    }
}

