/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.custom.visualdiff;

import de.cismet.custom.visualdiff.DiffPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import org.openide.util.Exceptions;

public class Testapplication
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("de/cismet/custom/visualdiff/Bundle", Locale.ENGLISH);
    private static final String MIMETYPE_HTML = "text/html";
    private static final String MIMETYPE_JAVA = "text/x-java";
    private static final String MIMETYPE_JSON = "text/javascript";
    private static final String MIMETYPE_TEXT = "text/plain";
    private static final String FILENAME1_HTML = "src\\test\\resources\\filestodiff\\html1.html";
    private static final String FILENAME2_HTML = "src\\test\\resources\\filestodiff\\html2.html";
    private static final String FILENAME1_JAVA = "src\\test\\resources\\filestodiff\\java1.java";
    private static final String FILENAME2_JAVA = "src\\test\\resources\\filestodiff\\java2.java";
    private static final String FILENAME1_JSON = "src\\test\\resources\\filestodiff\\json1.json";
    private static final String FILENAME2_JSON = "src\\test\\resources\\filestodiff\\json2.json";
    private static final String FILENAME1_TEXT = "src\\test\\resources\\filestodiff\\text1.txt";
    private static final String FILENAME2_TEXT = "src\\test\\resources\\filestodiff\\text2.txt";
    private DiffPanel pnlDiff;
    private JButton btnDiffHTMLFiles;
    private JButton btnDiffJSONFiles;
    private JButton btnDiffJavaFiles;
    private JButton btnDiffTextFiles;
    private JPanel pnlControls;
    private JSeparator separator;

    public Testapplication() {
        this.initComponents();
        File file1 = new File(FILENAME1_TEXT);
        File file2 = new File(FILENAME2_TEXT);
        try (FileReader reader1 = new FileReader(file1, StandardCharsets.UTF_8);
             FileReader reader2 = new FileReader(file2, StandardCharsets.UTF_8);){
            this.pnlDiff = new DiffPanel(this);
            this.pnlDiff.setLeftAndRight(Testapplication.getLines(reader1), MIMETYPE_TEXT, file1.getName(), Testapplication.getLines(reader2), MIMETYPE_TEXT, file2.getName());
            this.getContentPane().add((Component)this.pnlDiff, "Center");
            this.setVisible(true);
        }
        catch (Exception ex) {
            Testapplication.log(ex);
        }
    }

    private static String getLines(Reader reader) throws IOException {
        try (BufferedReader bufferedReader = new BufferedReader(reader);){
            String string = bufferedReader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    private void initComponents() {
        this.pnlControls = new JPanel();
        this.separator = new JSeparator();
        this.btnDiffHTMLFiles = new JButton();
        this.btnDiffJavaFiles = new JButton();
        this.btnDiffJSONFiles = new JButton();
        this.btnDiffTextFiles = new JButton();
        this.setDefaultCloseOperation(3);
        this.setTitle(BUNDLE.getString("Testapplication.title"));
        this.separator.setBorder(BorderFactory.createEtchedBorder());
        this.separator.setPreferredSize(new Dimension(2, 23));
        this.pnlControls.add(this.separator);
        this.btnDiffHTMLFiles.setText(BUNDLE.getString("Testapplication.btnDiffHTMLFiles.text"));
        this.btnDiffHTMLFiles.addActionListener(this::btnDiffHTMLFilesActionPerformed);
        this.pnlControls.add(this.btnDiffHTMLFiles);
        this.btnDiffJavaFiles.setText(BUNDLE.getString("Testapplication.btnDiffJavaFiles.text"));
        this.btnDiffJavaFiles.addActionListener(this::btnDiffJavaFilesActionPerformed);
        this.pnlControls.add(this.btnDiffJavaFiles);
        this.btnDiffJSONFiles.setText(BUNDLE.getString("Testapplication.btnDiffJSONFiles.text"));
        this.btnDiffJSONFiles.addActionListener(this::btnDiffJSONFilesActionPerformed);
        this.pnlControls.add(this.btnDiffJSONFiles);
        this.btnDiffTextFiles.setText(BUNDLE.getString("Testapplication.btnDiffTextFiles.text"));
        this.btnDiffTextFiles.addActionListener(this::btnDiffTextFilesActionPerformed);
        this.pnlControls.add(this.btnDiffTextFiles);
        this.getContentPane().add((Component)this.pnlControls, "South");
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setBounds((screenSize.width - 729) / 2, (screenSize.height - 706) / 2, 729, 706);
    }

    private void btnDiffHTMLFilesActionPerformed(ActionEvent evt) {
        File file1 = new File(FILENAME1_HTML);
        File file2 = new File(FILENAME2_HTML);
        try (FileReader reader1 = new FileReader(file1, StandardCharsets.UTF_8);
             FileReader reader2 = new FileReader(file2, StandardCharsets.UTF_8);){
            this.pnlDiff.setLeftAndRight(Testapplication.getLines(reader1), MIMETYPE_HTML, file1.getName(), Testapplication.getLines(reader2), MIMETYPE_HTML, file2.getName());
        }
        catch (IOException ex) {
            Testapplication.log(ex);
        }
    }

    private void btnDiffJavaFilesActionPerformed(ActionEvent evt) {
        File file1 = new File(FILENAME1_JAVA);
        File file2 = new File(FILENAME2_JAVA);
        try (FileReader reader1 = new FileReader(file1, StandardCharsets.UTF_8);
             FileReader reader2 = new FileReader(file2, StandardCharsets.UTF_8);){
            this.pnlDiff.setLeftAndRight(Testapplication.getLines(reader1), MIMETYPE_JAVA, file1.getName(), Testapplication.getLines(reader2), MIMETYPE_JAVA, file2.getName());
        }
        catch (IOException ex) {
            Testapplication.log(ex);
        }
    }

    private void btnDiffJSONFilesActionPerformed(ActionEvent evt) {
        File file1 = new File(FILENAME1_JSON);
        File file2 = new File(FILENAME2_JSON);
        try (FileReader reader1 = new FileReader(file1, StandardCharsets.UTF_8);
             FileReader reader2 = new FileReader(file2, StandardCharsets.UTF_8);){
            this.pnlDiff.setLeftAndRight(Testapplication.getLines(reader1), MIMETYPE_JSON, file1.getName(), Testapplication.getLines(reader2), MIMETYPE_JSON, file2.getName());
        }
        catch (IOException ex) {
            Testapplication.log(ex);
        }
    }

    private void btnDiffTextFilesActionPerformed(ActionEvent evt) {
        File file1 = new File(FILENAME1_TEXT);
        File file2 = new File(FILENAME2_TEXT);
        try (FileReader reader1 = new FileReader(file1, StandardCharsets.UTF_8);
             FileReader reader2 = new FileReader(file2, StandardCharsets.UTF_8);){
            this.pnlDiff.setLeftAndRight(Testapplication.getLines(reader1), MIMETYPE_TEXT, file1.getName(), Testapplication.getLines(reader2), MIMETYPE_TEXT, file2.getName());
        }
        catch (IOException ex) {
            Testapplication.log(ex);
        }
    }

    private static void log(Exception ex) {
        Exceptions.printStackTrace((Throwable)ex);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(Testapplication::new);
    }
}

