/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.custom.visualdiff;

import java.awt.Color;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.text.AttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.modules.editor.settings.AttrSet;
import org.netbeans.modules.editor.settings.storage.StorageImpl;
import org.netbeans.modules.editor.settings.storage.fontscolors.ColoringStorage;
import org.netbeans.modules.editor.settings.storage.spi.StorageDescription;
import org.netbeans.modules.editor.settings.storage.spi.StorageReader;
import org.netbeans.modules.editor.settings.storage.spi.StorageWriter;
import org.openide.filesystems.FileObject;

public final class MyColoringStorage
implements StorageDescription<String, AttributeSet>,
StorageImpl.Operations<String, AttributeSet> {
    public static final String FAV_TOKEN = "token";
    public static final String ID = "FontsColors";
    public static final String MIME_TYPE = "text/x-nbeditor-fontcolorsettings";
    private final ColoringStorage coloringStorage;

    public Map<String, AttributeSet> load(MimePath mimePath, String profile, boolean defaults) throws IOException {
        HashMap<String, AttributeSet> colorMap = new HashMap<String, AttributeSet>(this.coloringStorage.load(mimePath, profile, defaults));
        Properties eclipseThemeProps = new Properties();
        try (InputStream in = this.getClass().getResourceAsStream("/de/cismet/custom/visualdiff/eclipse.theme.properties");){
            eclipseThemeProps.load(in);
        }
        for (Map.Entry<Object, Object> prop : eclipseThemeProps.entrySet()) {
            AttributeSet attrSet = (AttributeSet)colorMap.get(prop.getKey());
            if (attrSet == null) continue;
            SimpleAttributeSet overrideAttrSet = new SimpleAttributeSet();
            Color newColor = new Color((int)Long.parseLong((String)prop.getValue(), 16));
            overrideAttrSet.addAttribute(StyleConstants.Foreground, newColor);
            colorMap.put((String)prop.getKey(), (AttributeSet)AttrSet.merge((AttributeSet[])new AttributeSet[]{overrideAttrSet, attrSet}));
        }
        return colorMap;
    }

    public boolean save(MimePath mimePath, String profile, boolean defaults, Map<String, AttributeSet> data, Map<String, AttributeSet> defaultData) throws IOException {
        throw new UnsupportedOperationException();
    }

    public void delete(MimePath mimePath, String profile, boolean defaults) throws IOException {
        throw new UnsupportedOperationException();
    }

    public MyColoringStorage(String type) {
        this.coloringStorage = new ColoringStorage(type);
    }

    public MyColoringStorage() {
        this(FAV_TOKEN);
    }

    public String getId() {
        return ID;
    }

    public boolean isUsingProfiles() {
        return true;
    }

    public String getMimeType() {
        return MIME_TYPE;
    }

    public String getLegacyFileName() {
        return null;
    }

    public StorageReader<String, AttributeSet> createReader(FileObject f, String mimePath) {
        throw new UnsupportedOperationException();
    }

    public StorageWriter<String, AttributeSet> createWriter(FileObject f, String mimePath) {
        throw new UnsupportedOperationException();
    }
}

