/*
 * Decompiled with CFR 0.152.
 */
package de.cismet.custom.visualdiff;

import de.cismet.custom.visualdiff.FileToDiff;
import de.cismet.custom.visualdiff.MyStreamSource;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.UnaryOperator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;

public class DiffPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("de/cismet/custom/visualdiff/Bundle", Locale.ENGLISH);
    protected DiffView view;
    protected FileToDiff left;
    protected FileToDiff right;
    private JLabel lblWaitingImage;
    private JPanel pnlDiff;
    private JPanel pnlFilesMissing;
    private JPanel pnlWaiting;
    private JLabel txtFilesMissing;
    private JButton btnNextDifference = new JButton("Next");
    private JButton btnPrevDifference = new JButton("Previous");
    private UnaryOperator<Image> imageOperator;

    public DiffPanel(JFrame frame) {
        this.initComponents(frame);
    }

    private void btnNextDifferenceActionPerformed(ActionEvent evt) {
        if (this.view != null && this.view.canSetCurrentDifference() && this.view.getDifferenceCount() > 0) {
            this.view.setCurrentDifference((this.view.getCurrentDifference() + 1) % this.view.getDifferenceCount());
        }
    }

    private void btnPrevDifferenceActionPerformed(ActionEvent evt) {
        if (this.view != null && this.view.canSetCurrentDifference() && this.view.getDifferenceCount() > 0) {
            this.view.setCurrentDifference((this.view.getCurrentDifference() == 0 ? this.view.getDifferenceCount() - 1 : this.view.getCurrentDifference() - 1) % this.view.getDifferenceCount());
        }
    }

    public void update() {
        if (this.left == null || this.right == null) {
            this.showFilesMissing();
            System.out.println("At least one file is null. The diff component can't be created.");
            return;
        }
        this.showWaiting();
        new SwingWorker<DiffView, Void>(){

            @Override
            protected DiffView doInBackground() throws Exception {
                MyStreamSource sourceLeft = new MyStreamSource(DiffPanel.this.left);
                MyStreamSource sourceRight = new MyStreamSource(DiffPanel.this.right);
                return Diff.getDefault().createDiff((StreamSource)sourceLeft, (StreamSource)sourceRight);
            }

            @Override
            protected void done() {
                try {
                    DiffPanel.this.view = (DiffView)this.get();
                    DiffPanel.this.pnlDiff.removeAll();
                    DiffPanel.this.pnlDiff.add(DiffPanel.this.view.getComponent(), "Center");
                    DiffPanel.this.showDiff();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.execute();
    }

    public void showFilesMissing() {
        ShowCardRunnable waitRunnable = new ShowCardRunnable(this, "filesMissing");
        if (EventQueue.isDispatchThread()) {
            waitRunnable.run();
        } else {
            EventQueue.invokeLater(waitRunnable);
        }
    }

    public void showWaiting() {
        ShowCardRunnable waitRunnable = new ShowCardRunnable(this, "waiting");
        if (EventQueue.isDispatchThread()) {
            waitRunnable.run();
        } else {
            EventQueue.invokeLater(waitRunnable);
        }
    }

    public void showDiff() {
        ShowCardRunnable diffRunnable = new ShowCardRunnable(this, "diff");
        if (EventQueue.isDispatchThread()) {
            diffRunnable.run();
        } else {
            EventQueue.invokeLater(diffRunnable);
        }
    }

    public void setLeft(String content, String mimetype, String title) {
        this.left = DiffPanel.createFileToDiff(content, mimetype, title);
        this.update();
    }

    public void setRight(String content, String mimetype, String title) {
        this.right = DiffPanel.createFileToDiff(content, mimetype, title);
        this.update();
    }

    public void setLeftAndRight(String contentLeft, String mimetypeLeft, String titleLeft, String contentRight, String mimetypeRight, String titleRight) {
        this.left = DiffPanel.createFileToDiff(contentLeft, mimetypeLeft, titleLeft);
        this.right = DiffPanel.createFileToDiff(contentRight, mimetypeRight, titleRight);
        this.update();
    }

    public DiffView getDiffView() {
        return this.view;
    }

    protected static boolean isValidContent(String content) {
        return content != null && content.trim().length() > 0;
    }

    protected static FileToDiff createFileToDiff(String content, String mimetype, String title) {
        if (DiffPanel.isValidContent(content)) {
            return new FileToDiff(content, mimetype, title);
        }
        return null;
    }

    private void initComponents(JFrame frame) {
        this.pnlFilesMissing = new JPanel();
        this.txtFilesMissing = new JLabel();
        this.pnlWaiting = new JPanel();
        this.lblWaitingImage = new JLabel();
        this.pnlDiff = new JPanel();
        this.setLayout(new CardLayout());
        this.pnlFilesMissing.setLayout(new BorderLayout());
        this.txtFilesMissing.setHorizontalAlignment(0);
        this.txtFilesMissing.setText(BUNDLE.getString("DiffPanel.txtFilesMissing.text"));
        this.pnlFilesMissing.add((Component)this.txtFilesMissing, "Center");
        this.add((Component)this.pnlFilesMissing, "filesMissing");
        this.pnlWaiting.setLayout(new BorderLayout());
        this.lblWaitingImage.setHorizontalAlignment(0);
        this.lblWaitingImage.setIcon(new ImageIcon(this.getClass().getResource("/de/cismet/custom/visualdiff/load.png")));
        this.pnlWaiting.add((Component)this.lblWaitingImage, "Center");
        this.add((Component)this.pnlWaiting, "waiting");
        this.pnlDiff.setLayout(new BorderLayout());
        this.add((Component)this.pnlDiff, "diff");
        this.btnNextDifference.addActionListener(this::btnNextDifferenceActionPerformed);
        this.btnPrevDifference.addActionListener(this::btnPrevDifferenceActionPerformed);
        this.addIconToButton("/de/cismet/custom/visualdiff/next_nav.png", this.btnNextDifference);
        this.addIconToButton("/de/cismet/custom/visualdiff/prev_nav.png", this.btnPrevDifference);
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.btnPrevDifference);
        menuBar.add(this.btnNextDifference);
        frame.setJMenuBar(menuBar);
    }

    private void addIconToButton(String iconPath, JButton button) {
        try {
            Image next = ImageIO.read(this.getClass().getResource(iconPath));
            if (this.imageOperator != null) {
                next = (Image)this.imageOperator.apply(next);
            }
            button.setIcon(new ImageIcon(next));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setImageOperator(UnaryOperator<Image> imageOperator) {
        this.imageOperator = imageOperator;
    }

    static {
        UIManager.put("nb.diff.added.color", new Color(229, 242, 229));
        UIManager.put("nb.diff.deleted.color", new Color(255, 229, 229));
        UIManager.put("nb.diff.changed.color", new Color(229, 242, 255));
    }

    protected class ShowCardRunnable
    implements Runnable {
        private Container parent;
        private String cardToShow;

        public ShowCardRunnable(Container parent, String cardToShow) {
            this.parent = parent;
            this.cardToShow = cardToShow;
        }

        @Override
        public void run() {
            if (this.parent.getLayout() instanceof CardLayout) {
                ((CardLayout)this.parent.getLayout()).show(this.parent, this.cardToShow);
            }
        }
    }
}

