/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.text;

import java.math.BigDecimal;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.text.NumberFormatter;

public class StrictNumberFormatter
extends NumberFormatter {
    private BigDecimal maxAsBig;
    private BigDecimal minAsBig;

    public StrictNumberFormatter(NumberFormat format) {
        super(format);
    }

    @Override
    public void setValueClass(Class<?> valueClass) {
        super.setValueClass(valueClass);
        this.updateMinMax();
    }

    private void updateMinMax() {
        Number min = null;
        Number max = null;
        if (this.getValueClass() == Integer.class) {
            max = Integer.MAX_VALUE;
            min = Integer.MIN_VALUE;
        } else if (this.getValueClass() == Long.class) {
            max = Long.MAX_VALUE;
            min = Long.MIN_VALUE;
        } else if (this.getValueClass() == Short.class) {
            max = (short)Short.MAX_VALUE;
            min = (short)Short.MIN_VALUE;
        } else if (this.getValueClass() == Byte.class) {
            max = (byte)127;
            min = (byte)-128;
        } else if (this.getValueClass() == Float.class) {
            max = Float.valueOf(Float.MAX_VALUE);
            min = Float.valueOf(-3.4028235E38f);
        } else if (this.getValueClass() == Double.class) {
            // empty if block
        }
        this.setMaximum((Comparable)((Object)max));
        this.setMinimum((Comparable)((Object)min));
    }

    public void setMaximum(Comparable max) {
        super.setMaximum(max);
        this.maxAsBig = max != null ? new BigDecimal(max.toString()) : null;
    }

    public void setMinimum(Comparable minimum) {
        super.setMinimum(minimum);
        this.minAsBig = minimum != null ? new BigDecimal(minimum.toString()) : null;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        Object value = StrictNumberFormatter.getParsedValue(text, this.getFormat());
        try {
            if (!this.isValueInRange(value, true)) {
                throw new ParseException("Value not within min/max range", 0);
            }
        }
        catch (ClassCastException cce) {
            throw new ParseException("Class cast exception comparing values: " + cce, 0);
        }
        return StrictNumberFormatter.convertValueToValueClass(value, this.getValueClass());
    }

    private static Object convertValueToValueClass(Object value, Class<?> valueClass) {
        if (valueClass != null && value instanceof Number) {
            if (valueClass == Integer.class) {
                return ((Number)value).intValue();
            }
            if (valueClass == Long.class) {
                return ((Number)value).longValue();
            }
            if (valueClass == Float.class) {
                return Float.valueOf(((Number)value).floatValue());
            }
            if (valueClass == Double.class) {
                return ((Number)value).doubleValue();
            }
            if (valueClass == Byte.class) {
                return ((Number)value).byteValue();
            }
            if (valueClass == Short.class) {
                return ((Number)value).shortValue();
            }
        }
        return value;
    }

    private static Object getParsedValue(String text, Format f) throws ParseException {
        if (f == null) {
            return text;
        }
        return f.parseObject(text);
    }

    private boolean isValueInRange(Object orgValue, boolean wantsCCE) {
        if (orgValue == null) {
            return true;
        }
        if (this.getMinimum() == null && this.getMaximum() == null) {
            return true;
        }
        BigDecimal value = new BigDecimal(orgValue.toString());
        Comparable<BigDecimal> min = this.getMinimumAsBig();
        try {
            if (min != null && min.compareTo(value) > 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        Comparable<BigDecimal> max = this.getMaximumAsBig();
        try {
            if (max != null && max.compareTo(value) < 0) {
                return false;
            }
        }
        catch (ClassCastException cce) {
            if (wantsCCE) {
                throw cce;
            }
            return false;
        }
        return true;
    }

    private Comparable<BigDecimal> getMinimumAsBig() {
        return this.minAsBig;
    }

    private Comparable<BigDecimal> getMaximumAsBig() {
        return this.maxAsBig;
    }
}

