/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.TableUtilities;

public class TableRowHeightController {
    private JTable table;
    private TableModelListener tableModelListener;
    private PropertyChangeListener tablePropertyListener;

    public TableRowHeightController() {
        this(null);
    }

    public TableRowHeightController(JTable table) {
        this.install(table);
    }

    public void install(JTable table) {
        this.release();
        if (table != null) {
            this.table = table;
            this.installListeners();
            this.updatePreferredRowHeights();
        }
    }

    public void release() {
        if (this.table == null) {
            return;
        }
        this.uninstallListeners();
        this.table = null;
    }

    protected void updatePreferredRowHeights(int firstRow, int lastRow) {
        for (int row = firstRow; row <= lastRow; ++row) {
            int viewRow = this.table.convertRowIndexToView(row);
            if (viewRow < 0) continue;
            TableUtilities.setPreferredRowHeight(this.table, viewRow);
        }
    }

    protected void updatePreferredRowHeights() {
        if (this.table.getRowCount() == 0) {
            return;
        }
        this.updatePreferredRowHeights(0, this.table.getModel().getRowCount() - 1);
    }

    protected void updateModel(TableModel oldValue) {
        if (oldValue != null) {
            oldValue.removeTableModelListener(this.getTableModelListener());
        }
        this.table.getModel().addTableModelListener(this.getTableModelListener());
        this.updatePreferredRowHeights();
    }

    protected PropertyChangeListener createTablePropertyListener() {
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                this.invokedPropertyChanged(evt);
            }

            private void invokedPropertyChanged(PropertyChangeEvent evt) {
                SwingUtilities.invokeLater(() -> {
                    if ("model".equals(evt.getPropertyName())) {
                        TableRowHeightController.this.updateModel((TableModel)evt.getOldValue());
                    }
                });
            }
        };
    }

    protected TableModelListener createTableModelListener() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                SwingUtilities.invokeLater(() -> this.invokedTableChanged(e));
            }

            private void invokedTableChanged(TableModelEvent e) {
                if (TableUtilities.isStructureChanged(e) || TableUtilities.isDataChanged(e)) {
                    TableRowHeightController.this.updatePreferredRowHeights();
                } else if (TableUtilities.isUpdate(e) || TableUtilities.isInsert(e)) {
                    TableRowHeightController.this.updatePreferredRowHeights(e.getFirstRow(), e.getLastRow());
                }
            }
        };
    }

    private void uninstallListeners() {
        this.table.removePropertyChangeListener(this.getPropertyChangeListener());
        this.table.getModel().removeTableModelListener(this.getTableModelListener());
    }

    private void installListeners() {
        this.table.addPropertyChangeListener(this.getPropertyChangeListener());
        this.table.getModel().addTableModelListener(this.getTableModelListener());
    }

    protected TableModelListener getTableModelListener() {
        if (this.tableModelListener == null) {
            this.tableModelListener = this.createTableModelListener();
        }
        return this.tableModelListener;
    }

    protected PropertyChangeListener getPropertyChangeListener() {
        if (this.tablePropertyListener == null) {
            this.tablePropertyListener = this.createTablePropertyListener();
        }
        return this.tablePropertyListener;
    }
}

