/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.table;

import java.awt.Color;
import java.awt.Component;
import java.lang.reflect.Constructor;
import java.text.NumberFormat;
import java.text.ParseException;
import javax.swing.DefaultCellEditor;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.LineBorder;
import javax.swing.text.NumberFormatter;
import org.jdesktop.swingx.text.NumberFormatExt;
import org.jdesktop.swingx.text.StrictNumberFormatter;

public class NumberEditorExt
extends DefaultCellEditor {
    private Constructor<?> constructor;
    private final boolean useStrictFormatter;

    public NumberEditorExt() {
        this((NumberFormat)null);
    }

    public NumberEditorExt(NumberFormat format) {
        this(format, false);
    }

    public NumberEditorExt(boolean useStrictFormatter) {
        this(null, useStrictFormatter);
    }

    public NumberEditorExt(NumberFormat format, boolean useStrictFormatter) {
        super(useStrictFormatter ? NumberEditorExt.createFormattedTextFieldX(format) : NumberEditorExt.createFormattedTextField(format));
        this.useStrictFormatter = useStrictFormatter;
        JFormattedTextField textField = this.getComponent();
        textField.setName("Table.editor");
        textField.setHorizontalAlignment(4);
        textField.removeActionListener(this.delegate);
        this.delegate = new DefaultCellEditor.EditorDelegate(){

            @Override
            public void setValue(Object value) {
                NumberEditorExt.this.getComponent().setValue(value);
            }

            @Override
            public Object getCellEditorValue() {
                try {
                    NumberEditorExt.this.getComponent().commitEdit();
                    return NumberEditorExt.this.getComponent().getValue();
                }
                catch (ParseException ex) {
                    return null;
                }
            }
        };
        textField.addActionListener(this.delegate);
    }

    @Override
    public boolean stopCellEditing() {
        if (!this.isValid()) {
            return false;
        }
        return super.stopCellEditing();
    }

    protected boolean isValid() {
        if (!this.getComponent().isEditValid()) {
            return false;
        }
        try {
            if (!this.hasStrictFormatter()) {
                this.getNumber();
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected Number getNumber() throws Exception {
        Number number = (Number)super.getCellEditorValue();
        if (number == null) {
            return null;
        }
        return this.hasStrictFormatter() ? (Number)number : (Number)((Number)this.constructor.newInstance(number.toString()));
    }

    protected boolean hasStrictFormatter() {
        return this.useStrictFormatter;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.getComponent().setBorder(new LineBorder(Color.black));
        try {
            Class<?> type = table.getColumnClass(column);
            if (this.hasStrictFormatter()) {
                ((NumberFormatter)this.getComponent().getFormatter()).setValueClass(type);
            } else {
                if (!Number.class.isAssignableFrom(type)) {
                    throw new IllegalStateException("NumberEditor can only handle subclasses of java.lang.Number");
                }
                this.constructor = type.getConstructor(String.class);
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }
        catch (Exception ex) {
            throw new IllegalStateException("value/type not compatible with Number", ex);
        }
    }

    @Override
    public Number getCellEditorValue() throws IllegalStateException {
        try {
            return this.getNumber();
        }
        catch (Exception ex) {
            throw new IllegalStateException("Number conversion not possible from current string " + this.getComponent().getText());
        }
    }

    @Override
    public JFormattedTextField getComponent() {
        return (JFormattedTextField)super.getComponent();
    }

    private static JFormattedTextField createFormattedTextFieldX(NumberFormat format) {
        StrictNumberFormatter formatter = new StrictNumberFormatter(new NumberFormatExt(format));
        JFormattedTextField textField = new JFormattedTextField(formatter);
        InputMap map = textField.getInputMap();
        map.put(KeyStroke.getKeyStroke("ESCAPE"), "none");
        textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JFormattedTextField ftf = (JFormattedTextField)input;
                return ftf.isEditValid();
            }
        });
        textField.addPropertyChangeListener("editValid", evt -> {
            if (evt.getNewValue() == Boolean.TRUE) {
                ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.black));
            } else {
                ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.red));
            }
        });
        return textField;
    }

    private static JFormattedTextField createFormattedTextField(NumberFormat formatter) {
        JFormattedTextField textField = new JFormattedTextField(new NumberFormatExt(formatter));
        InputMap map = textField.getInputMap();
        map.put(KeyStroke.getKeyStroke("ESCAPE"), "none");
        textField.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                JFormattedTextField ftf = (JFormattedTextField)input;
                return ftf.isEditValid();
            }
        });
        textField.addPropertyChangeListener("editValid", evt -> {
            if (evt.getNewValue() == Boolean.TRUE) {
                ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.black));
            } else {
                ((JFormattedTextField)evt.getSource()).setBorder(new LineBorder(Color.red));
            }
        });
        return textField;
    }
}

