/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.search;

import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.UIManager;
import org.jdesktop.swingx.plaf.AbstractUIChangeHandler;
import org.jdesktop.swingx.util.OS;

public class NativeSearchFieldSupport {
    public static final String FIND_POPUP_PROPERTY = "JTextField.Search.FindPopup";
    public static final String FIND_ACTION_PROPERTY = "JTextField.Search.FindAction";
    public static final String MAC_SEARCH_VARIANT = "search";
    public static final String MAC_TEXT_FIELD_VARIANT_PROPERTY = "JTextField.variant";
    public static final String CANCEL_ACTION_PROPERTY = "JTextField.Search.CancelAction";
    private static final SearchFieldUIChangeHandler uiChangeHandler = new SearchFieldUIChangeHandler();

    public static boolean isNativeSearchFieldSupported() {
        try {
            String versionString = System.getProperty("os.version");
            if (versionString.length() < 4) {
                return false;
            }
            versionString = versionString.substring(0, 4);
            return OS.isMacOSX() && (double)Float.parseFloat(versionString) >= 10.5 && "Mac OS X".equals(UIManager.getLookAndFeel().getName());
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void setSearchField(JTextField txt, boolean isSearchField) {
        if (isSearchField == NativeSearchFieldSupport.isSearchField(txt)) {
            txt.putClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY, "_triggerevent_");
        } else if (isSearchField) {
            uiChangeHandler.install(txt);
        } else {
            uiChangeHandler.uninstall(txt);
        }
        if (isSearchField) {
            txt.putClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY, MAC_SEARCH_VARIANT);
            txt.putClientProperty("Quaqua.TextField.style", MAC_SEARCH_VARIANT);
        } else {
            txt.putClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY, "default");
            txt.putClientProperty("Quaqua.TextField.style", "default");
        }
    }

    public static boolean isSearchField(JTextField txt) {
        return MAC_SEARCH_VARIANT.equals(txt.getClientProperty(MAC_TEXT_FIELD_VARIANT_PROPERTY));
    }

    public static boolean isNativeSearchField(JTextField txt) {
        return NativeSearchFieldSupport.isSearchField(txt) && NativeSearchFieldSupport.isNativeSearchFieldSupported();
    }

    public static void setFindPopupMenu(JTextField txt, JPopupMenu popupMenu) {
        txt.putClientProperty(FIND_POPUP_PROPERTY, popupMenu);
    }

    public static JPopupMenu getFindPopupMenu(JTextField txt) {
        return (JPopupMenu)txt.getClientProperty(FIND_POPUP_PROPERTY);
    }

    public static void setFindAction(JTextField txt, ActionListener findAction) {
        txt.putClientProperty(FIND_ACTION_PROPERTY, findAction);
    }

    public static ActionListener getFindAction(JTextField txt) {
        return (ActionListener)txt.getClientProperty(FIND_ACTION_PROPERTY);
    }

    public static void setCancelAction(JTextField txt, ActionListener cancelAction) {
        txt.putClientProperty(CANCEL_ACTION_PROPERTY, cancelAction);
    }

    public static ActionListener getCancelAction(JTextField txt) {
        return (ActionListener)txt.getClientProperty(CANCEL_ACTION_PROPERTY);
    }

    private static final class SearchFieldUIChangeHandler
    extends AbstractUIChangeHandler {
        private SearchFieldUIChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            JTextField txt = (JTextField)evt.getSource();
            NativeSearchFieldSupport.setSearchField(txt, NativeSearchFieldSupport.isSearchField(txt));
        }
    }
}

