/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.renderer;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import javax.swing.JCheckBox;
import javax.swing.UIManager;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class JRendererCheckBox
extends JCheckBox
implements PainterAware {
    protected Painter painter;
    private boolean fakeTransparency;

    public JRendererCheckBox() {
        this.setOpaque(true);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        Painter old = this.getPainter();
        this.painter = painter;
        this.firePropertyChange("painter", old, this.getPainter());
    }

    @Override
    public boolean isOpaque() {
        if (this.fakeTransparency) {
            return false;
        }
        return super.isOpaque();
    }

    @Override
    public boolean isContentAreaFilled() {
        if (this.fakeTransparency) {
            return false;
        }
        return super.isContentAreaFilled();
    }

    @Override
    public void setToolTipText(String text) {
        this.putClientProperty("ToolTipText", text);
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.painter != null || JRendererCheckBox.isNimbus()) {
            if (this.isOpaque()) {
                this.fakeTransparency = true;
                this.paintComponentWithPainter((Graphics2D)g);
                this.fakeTransparency = false;
            } else {
                this.paintPainter(g);
                super.paintComponent(g);
            }
        } else {
            super.paintComponent(g);
        }
    }

    private static boolean isNimbus() {
        return UIManager.getLookAndFeel().getName().contains("Nimbus");
    }

    private void paintPainter(Graphics g) {
        if (this.painter == null) {
            return;
        }
        Graphics2D scratch = (Graphics2D)g.create();
        try {
            this.painter.paint(scratch, this, this.getWidth(), this.getHeight());
        }
        finally {
            scratch.dispose();
        }
    }

    protected void paintComponentWithPainter(Graphics2D g) {
        if (this.ui != null) {
            Graphics scratchGraphics = g.create();
            try {
                scratchGraphics.setColor(this.getBackground());
                scratchGraphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                this.paintPainter(g);
                this.ui.paint(scratchGraphics, this);
            }
            finally {
                scratchGraphics.dispose();
            }
        }
    }

    @Override
    public void invalidate() {
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    public void repaint() {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("text".equals(propertyName)) {
            super.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }
}

