/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import javax.swing.AbstractButton;
import javax.swing.AbstractSpinnerModel;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerModel;
import javax.swing.UIManager;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.renderer.FormatStringValue;

public class SpinningCalendarHeaderHandler
extends CalendarHeaderHandler {
    public static final String ARROWS_SURROUND_MONTH = "SpinningCalendarHeader.arrowsSurroundMonth";
    public static final String FOCUSABLE_SPINNER_TEXT = "SpinningCalendarHeader.focusableSpinnerText";
    private SpinnerModel yearSpinnerModel;
    private PropertyChangeListener monthPropertyListener;
    private FormatStringValue monthStringValue;

    @Override
    public void install(JXMonthView monthView) {
        super.install(monthView);
        this.getHeaderComponent().setActions(monthView.getActionMap().get("previousMonth"), monthView.getActionMap().get("nextMonth"), this.getYearSpinnerModel());
        this.componentOrientationChanged();
        this.monthStringBackgroundChanged();
        this.fontChanged();
        this.localeChanged();
    }

    @Override
    public void uninstall(JXMonthView monthView) {
        this.getHeaderComponent().setActions(null, null, null);
        this.getHeaderComponent().setMonthText("");
        super.uninstall(monthView);
    }

    @Override
    public SpinningCalendarHeader getHeaderComponent() {
        return (SpinningCalendarHeader)super.getHeaderComponent();
    }

    @Override
    protected SpinningCalendarHeader createCalendarHeader() {
        SpinningCalendarHeader header = new SpinningCalendarHeader();
        if (Boolean.TRUE.equals(UIManager.getBoolean(FOCUSABLE_SPINNER_TEXT))) {
            header.setSpinnerFocusable(true);
        }
        if (Boolean.TRUE.equals(UIManager.getBoolean(ARROWS_SURROUND_MONTH))) {
            header.setArrowsSurroundMonth(true);
        }
        return header;
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        this.monthView.addPropertyChangeListener(this.getPropertyChangeListener());
    }

    @Override
    protected void uninstallListeners() {
        this.monthView.removePropertyChangeListener(this.getPropertyChangeListener());
        super.uninstallListeners();
    }

    protected void updateFormatters() {
        SimpleDateFormat monthNameFormat = (SimpleDateFormat)DateFormat.getDateInstance(3, this.monthView.getLocale());
        monthNameFormat.applyPattern("MMMM");
        this.monthStringValue = new FormatStringValue(monthNameFormat);
    }

    protected void firstDisplayedDayChanged() {
        ((YearSpinnerModel)this.getYearSpinnerModel()).fireStateChanged();
        this.getHeaderComponent().setMonthText(this.monthStringValue.getString(this.monthView.getFirstDisplayedDay()));
    }

    protected void localeChanged() {
        this.updateFormatters();
        this.firstDisplayedDayChanged();
    }

    private PropertyChangeListener getPropertyChangeListener() {
        if (this.monthPropertyListener == null) {
            this.monthPropertyListener = evt -> {
                if ("firstDisplayedDay".equals(evt.getPropertyName())) {
                    this.firstDisplayedDayChanged();
                } else if ("locale".equals(evt.getPropertyName())) {
                    this.localeChanged();
                }
            };
        }
        return this.monthPropertyListener;
    }

    private int getYear() {
        Calendar cal = this.monthView.getCalendar();
        return cal.get(1);
    }

    private int getPreviousYear() {
        Calendar cal = this.monthView.getCalendar();
        cal.add(1, -1);
        return cal.get(1);
    }

    private int getNextYear() {
        Calendar cal = this.monthView.getCalendar();
        cal.add(1, 1);
        return cal.get(1);
    }

    private boolean setYear(Object value) {
        int year = (Integer)value;
        Calendar cal = this.monthView.getCalendar();
        if (cal.get(1) == year) {
            return false;
        }
        cal.set(1, year);
        this.monthView.setFirstDisplayedDay(cal.getTime());
        return true;
    }

    private SpinnerModel getYearSpinnerModel() {
        if (this.yearSpinnerModel == null) {
            this.yearSpinnerModel = new YearSpinnerModel();
        }
        return this.yearSpinnerModel;
    }

    protected static class SpinningCalendarHeader
    extends JXPanel {
        private AbstractButton prevButton;
        private AbstractButton nextButton;
        private JLabel monthText;
        private JSpinner yearSpinner;
        private boolean surroundMonth;

        public SpinningCalendarHeader() {
            this.initComponents();
        }

        public void setActions(Action prev, Action next, SpinnerModel model) {
            this.prevButton.setAction(prev);
            this.nextButton.setAction(next);
            this.uninstallZoomAction();
            this.installZoomAction(model);
        }

        public void setSpinnerFocusable(boolean focusable) {
            ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setFocusable(focusable);
        }

        public void setArrowsSurroundMonth(boolean surroundMonth) {
            if (this.surroundMonth == surroundMonth) {
                return;
            }
            this.surroundMonth = surroundMonth;
            this.removeAll();
            this.addComponents();
        }

        public void setMonthText(String text) {
            this.monthText.setText(text);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.monthText != null) {
                this.monthText.setFont(font);
                this.yearSpinner.setFont(font);
                this.yearSpinner.getEditor().setFont(font);
                ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setFont(font);
            }
        }

        @Override
        public void setBackground(Color bg) {
            super.setBackground(bg);
            for (int i = 0; i < this.getComponentCount(); ++i) {
                this.getComponent(i).setBackground(bg);
            }
            if (this.yearSpinner != null) {
                this.yearSpinner.setBackground(bg);
                this.yearSpinner.setBorder(BorderFactory.createLineBorder(bg, 2));
                this.yearSpinner.getEditor().setBackground(bg);
                ((JSpinner.DefaultEditor)this.yearSpinner.getEditor()).getTextField().setBackground(bg);
            }
        }

        private void installZoomAction(SpinnerModel model) {
            if (model == null) {
                return;
            }
            this.yearSpinner.setModel(model);
        }

        private void uninstallZoomAction() {
        }

        private void initComponents() {
            this.createComponents();
            this.setLayout(new BoxLayout(this, 2));
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
            this.addComponents();
        }

        private void addComponents() {
            if (this.surroundMonth) {
                this.add(this.prevButton);
                this.add(this.monthText);
                this.add(this.nextButton);
                this.add(Box.createHorizontalStrut(5));
                this.add(this.yearSpinner);
            } else {
                this.add(this.prevButton);
                this.add(Box.createHorizontalGlue());
                this.add(this.monthText);
                this.add(Box.createHorizontalStrut(5));
                this.add(this.yearSpinner);
                this.add(Box.createHorizontalGlue());
                this.add(this.nextButton);
            }
        }

        private void createComponents() {
            this.prevButton = SpinningCalendarHeader.createNavigationButton();
            this.nextButton = SpinningCalendarHeader.createNavigationButton();
            this.monthText = this.createMonthText();
            this.yearSpinner = SpinningCalendarHeader.createSpinner();
        }

        private JLabel createMonthText() {
            JLabel comp = new JLabel(){

                @Override
                public Dimension getMaximumSize() {
                    Dimension dim = super.getMaximumSize();
                    dim.width = Integer.MAX_VALUE;
                    dim.height = Integer.MAX_VALUE;
                    return dim;
                }
            };
            comp.setHorizontalAlignment(0);
            return comp;
        }

        private static JSpinner createSpinner() {
            JSpinner spinner = new JSpinner();
            spinner.setFocusable(false);
            JSpinner.NumberEditor editor = new JSpinner.NumberEditor(spinner);
            editor.getFormat().setGroupingUsed(false);
            editor.getTextField().setFocusable(false);
            spinner.setEditor(editor);
            return spinner;
        }

        private static AbstractButton createNavigationButton() {
            JXHyperlink b = new JXHyperlink();
            b.setContentAreaFilled(false);
            b.setBorder(BorderFactory.createEmptyBorder());
            b.setRolloverEnabled(true);
            b.setFocusable(false);
            return b;
        }
    }

    private class YearSpinnerModel
    extends AbstractSpinnerModel {
        private YearSpinnerModel() {
        }

        @Override
        public Object getNextValue() {
            return SpinningCalendarHeaderHandler.this.getNextYear();
        }

        @Override
        public Object getPreviousValue() {
            return SpinningCalendarHeaderHandler.this.getPreviousYear();
        }

        @Override
        public Object getValue() {
            return SpinningCalendarHeaderHandler.this.getYear();
        }

        @Override
        public void setValue(Object value) {
            if (SpinningCalendarHeaderHandler.this.setYear(value)) {
                this.fireStateChanged();
            }
        }

        @Override
        public void fireStateChanged() {
            super.fireStateChanged();
        }
    }
}

