/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.util.Calendar;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.plaf.basic.CalendarState;

class CalendarAdapter
extends ComponentAdapter {
    private Calendar calendar;
    private CalendarState dayState;

    CalendarAdapter(JXMonthView component) {
        super(component);
    }

    public CalendarAdapter install(Calendar calendar, CalendarState dayState) {
        this.calendar = calendar;
        this.dayState = dayState;
        return this;
    }

    @Override
    public JXMonthView getComponent() {
        return (JXMonthView)super.getComponent();
    }

    public CalendarState getCalendarState() {
        return this.dayState;
    }

    public boolean isFlagged() {
        if (this.getComponent() == null || this.calendar == null) {
            return false;
        }
        return this.getComponent().isFlaggedDate(this.calendar.getTime());
    }

    public boolean isUnselectable() {
        if (this.getComponent() == null || this.calendar == null || !this.isSelectable()) {
            return false;
        }
        return this.getComponent().isUnselectableDate(this.calendar.getTime());
    }

    private boolean isSelectable() {
        return CalendarState.IN_MONTH == this.getCalendarState() || CalendarState.TODAY == this.getCalendarState();
    }

    @Override
    public boolean isSelected() {
        if (this.getComponent() == null || this.calendar == null) {
            return false;
        }
        return this.getComponent().isSelected(this.calendar.getTime());
    }

    @Override
    public Object getFilteredValueAt(int row, int column) {
        return this.getValueAt(row, column);
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.calendar;
    }

    @Override
    public boolean hasFocus() {
        return false;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public boolean isEditable() {
        return false;
    }
}

