/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.html.HTMLDocument;
import org.jdesktop.swingx.JXTipOfTheDay;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.plaf.TipOfTheDayUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.tips.TipOfTheDayModel;

public class BasicTipOfTheDayUI
extends TipOfTheDayUI {
    protected JXTipOfTheDay tipPane;
    protected JPanel tipArea;
    protected Component currentTipComponent;
    protected Font tipFont;
    protected PropertyChangeListener changeListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicTipOfTheDayUI((JXTipOfTheDay)c);
    }

    public BasicTipOfTheDayUI(JXTipOfTheDay tipPane) {
        this.tipPane = tipPane;
    }

    @Override
    public JDialog createDialog(Component parentComponent, JXTipOfTheDay.ShowOnStartupChoice choice) {
        return this.createDialog(parentComponent, choice, true);
    }

    protected JDialog createDialog(Component parentComponent, JXTipOfTheDay.ShowOnStartupChoice choice, boolean showPreviousButton) {
        JCheckBox showOnStartupBox;
        Locale locale = parentComponent == null ? null : parentComponent.getLocale();
        String title = UIManagerExt.getString("TipOfTheDay.dialogTitle", locale);
        Window window = parentComponent == null ? JOptionPane.getRootFrame() : (parentComponent instanceof Window ? (Window)parentComponent : SwingUtilities.getWindowAncestor(parentComponent));
        JDialog dialog = window instanceof Frame ? new JDialog((Frame)window, title, true) : new JDialog((Dialog)window, title, true);
        dialog.getContentPane().setLayout(new BorderLayout(10, 10));
        dialog.getContentPane().add((Component)this.tipPane, "Center");
        ((JComponent)dialog.getContentPane()).setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JPanel controls = new JPanel(new BorderLayout());
        dialog.add("South", controls);
        if (choice != null) {
            showOnStartupBox = new JCheckBox(UIManagerExt.getString("TipOfTheDay.showOnStartupText", locale), choice.isShowingOnStartup());
            controls.add((Component)showOnStartupBox, "Center");
        } else {
            showOnStartupBox = null;
        }
        JPanel buttons = new JPanel(new GridLayout(1, showPreviousButton ? 3 : 2, 9, 0));
        controls.add((Component)buttons, "After");
        if (showPreviousButton) {
            JButton previousTipButton = new JButton(UIManagerExt.getString("TipOfTheDay.previousTipText", locale));
            buttons.add(previousTipButton);
            previousTipButton.addActionListener(this.getActionMap().get("previousTip"));
        }
        JButton nextTipButton = new JButton(UIManagerExt.getString("TipOfTheDay.nextTipText", locale));
        buttons.add(nextTipButton);
        nextTipButton.addActionListener(this.getActionMap().get("nextTip"));
        JButton closeButton = new JButton(UIManagerExt.getString("TipOfTheDay.closeText", locale));
        buttons.add(closeButton);
        final ActionListener saveChoice = e -> {
            if (choice != null) {
                choice.setShowingOnStartup(showOnStartupBox.isSelected());
            }
            dialog.setVisible(false);
        };
        closeButton.addActionListener(e -> {
            dialog.setVisible(false);
            saveChoice.actionPerformed(null);
        });
        dialog.getRootPane().setDefaultButton(closeButton);
        dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                saveChoice.actionPerformed(null);
            }
        });
        ((JComponent)dialog.getContentPane()).registerKeyboardAction(saveChoice, KeyStroke.getKeyStroke(27, 0), 2);
        dialog.pack();
        dialog.setLocationRelativeTo(parentComponent);
        return dialog;
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.installDefaults();
        this.installKeyboardActions();
        this.installComponents();
        this.installListeners();
        this.showCurrentTip();
    }

    protected void installKeyboardActions() {
        ActionMap map = this.getActionMap();
        if (map != null) {
            SwingUtilities.replaceUIActionMap(this.tipPane, map);
        }
    }

    ActionMap getActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        map.put("previousTip", new PreviousTipAction());
        map.put("nextTip", new NextTipAction());
        return map;
    }

    protected void installListeners() {
        this.changeListener = this.createChangeListener();
        this.tipPane.addPropertyChangeListener(this.changeListener);
    }

    protected PropertyChangeListener createChangeListener() {
        return new ChangeListener();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tipPane, "TipOfTheDay.background", "TipOfTheDay.foreground", "TipOfTheDay.font");
        LookAndFeel.installBorder(this.tipPane, "TipOfTheDay.border");
        LookAndFeel.installProperty(this.tipPane, "opaque", Boolean.TRUE);
        this.tipFont = UIManager.getFont("TipOfTheDay.tipFont");
    }

    protected void installComponents() {
        this.tipPane.setLayout(new BorderLayout());
        JLabel tipIcon = new JLabel(UIManagerExt.getString("TipOfTheDay.didYouKnowText", this.tipPane.getLocale()));
        tipIcon.setIcon(UIManager.getIcon("TipOfTheDay.icon"));
        tipIcon.setBorder(BorderFactory.createEmptyBorder(22, 15, 22, 15));
        this.tipPane.add("North", tipIcon);
        this.tipArea = new JPanel(new BorderLayout(2, 2));
        this.tipArea.setOpaque(false);
        this.tipArea.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        this.tipPane.add("Center", this.tipArea);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        return new Dimension(420, 175);
    }

    protected void showCurrentTip() {
        int currentTip;
        if (this.currentTipComponent != null) {
            this.tipArea.remove(this.currentTipComponent);
        }
        if ((currentTip = this.tipPane.getCurrentTip()) == -1) {
            JLabel label = new JLabel();
            label.setOpaque(true);
            label.setBackground(UIManager.getColor("TextArea.background"));
            this.currentTipComponent = label;
            this.tipArea.add("Center", this.currentTipComponent);
            return;
        }
        if (this.tipPane.getModel() == null || this.tipPane.getModel().getTipCount() == 0 || currentTip < 0 && currentTip >= this.tipPane.getModel().getTipCount()) {
            this.currentTipComponent = new JLabel();
        } else {
            TipOfTheDayModel.Tip tip = this.tipPane.getModel().getTipAt(currentTip);
            Object tipObject = tip.getTip();
            if (tipObject instanceof Component) {
                this.currentTipComponent = (Component)tipObject;
            } else if (tipObject instanceof Icon) {
                this.currentTipComponent = new JLabel((Icon)tipObject);
            } else {
                String text;
                JScrollPane tipScroll = new JScrollPane();
                tipScroll.setBorder(null);
                tipScroll.setOpaque(false);
                tipScroll.getViewport().setOpaque(false);
                tipScroll.setBorder(null);
                String string = text = tipObject == null ? "" : tipObject.toString();
                if (BasicHTML.isHTMLString(text)) {
                    JEditorPane editor = new JEditorPane("text/html", text);
                    editor.setFont(this.tipPane.getFont());
                    SwingXUtilities.setHtmlFont((HTMLDocument)editor.getDocument(), this.tipPane.getFont());
                    editor.setEditable(false);
                    editor.setBorder(null);
                    editor.setMargin(null);
                    editor.setOpaque(false);
                    tipScroll.getViewport().setView(editor);
                } else {
                    JTextArea area = new JTextArea(text);
                    area.setFont(this.tipPane.getFont());
                    area.setEditable(false);
                    area.setLineWrap(true);
                    area.setWrapStyleWord(true);
                    area.setBorder(null);
                    area.setMargin(null);
                    area.setOpaque(false);
                    tipScroll.getViewport().setView(area);
                }
                this.currentTipComponent = tipScroll;
            }
        }
        this.tipArea.add("Center", this.currentTipComponent);
        this.tipArea.revalidate();
        this.tipArea.repaint();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallComponents();
        this.uninstallDefaults();
        super.uninstallUI(c);
    }

    protected void uninstallListeners() {
        this.tipPane.removePropertyChangeListener(this.changeListener);
    }

    protected void uninstallComponents() {
    }

    protected void uninstallDefaults() {
    }

    private class PreviousTipAction
    extends AbstractAction {
        PreviousTipAction() {
            super("previousTip");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicTipOfTheDayUI.this.tipPane.previousTip();
        }

        @Override
        public boolean isEnabled() {
            return BasicTipOfTheDayUI.this.tipPane.isEnabled();
        }
    }

    private class NextTipAction
    extends AbstractAction {
        NextTipAction() {
            super("nextTip");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BasicTipOfTheDayUI.this.tipPane.nextTip();
        }

        @Override
        public boolean isEnabled() {
            return BasicTipOfTheDayUI.this.tipPane.isEnabled();
        }
    }

    private class ChangeListener
    implements PropertyChangeListener {
        private ChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("currentTip".equals(evt.getPropertyName())) {
                BasicTipOfTheDayUI.this.showCurrentTip();
            }
        }
    }
}

