/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.jdesktop.swingx.JXLoginPane;
import org.jdesktop.swingx.plaf.LoginPaneUI;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.GraphicsUtilities;

public class BasicLoginPaneUI
extends LoginPaneUI {
    private final JXLoginPane dlg;

    public BasicLoginPaneUI(JXLoginPane dlg) {
        this.dlg = dlg;
    }

    public static ComponentUI createUI(JComponent c) {
        return new BasicLoginPaneUI((JXLoginPane)c);
    }

    @Override
    public void installUI(JComponent c) {
        this.installDefaults();
    }

    protected void installDefaults() {
        String s = this.dlg.getBannerText();
        if (s == null || s.isEmpty()) {
            this.dlg.setBannerText(UIManagerExt.getString("JXLoginPane.bannerString", this.dlg.getLocale()));
        }
        if ((s = this.dlg.getErrorMessage()) == null || s.isEmpty()) {
            this.dlg.setErrorMessage(UIManagerExt.getString("JXLoginPane.errorMessage", this.dlg.getLocale()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Image getBanner() {
        int w = 400;
        int h = 60;
        float loginStringX = (float)w * 0.05f;
        float loginStringY = (float)h * 0.75f;
        BufferedImage img = GraphicsUtilities.createCompatibleImage(w, h);
        Graphics2D g2 = img.createGraphics();
        try {
            Font font = UIManager.getFont("JXLoginPane.bannerFont");
            g2.setFont(font);
            Graphics2D originalGraphics = g2;
            try {
                if (!this.dlg.getComponentOrientation().isLeftToRight()) {
                    originalGraphics = (Graphics2D)g2.create();
                    g2.scale(-1.0, 1.0);
                    g2.translate(-w, 0);
                    Rectangle2D sb = font.getStringBounds(this.dlg.getBannerText(), originalGraphics.getFontRenderContext());
                    loginStringX = (float)w - ((float)sb.getWidth() + (float)w * 0.05f);
                }
                g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
                g2.setColor(UIManager.getColor("JXLoginPane.bannerDarkBackground"));
                g2.fillRect(0, 0, w, h);
                GeneralPath curveShape = new GeneralPath(1);
                curveShape.moveTo(0.0f, (float)h * 0.6f);
                curveShape.curveTo((float)w * 0.167f, (float)h * 1.2f, (float)w * 0.667f, (float)h * -0.5f, w, (float)h * 0.75f);
                curveShape.lineTo(w, h);
                curveShape.lineTo(0.0f, h);
                curveShape.lineTo(0.0f, (float)h * 0.8f);
                curveShape.closePath();
                GradientPaint gp = new GradientPaint(0.0f, h, UIManager.getColor("JXLoginPane.bannerDarkBackground"), 0.0f, 0.0f, UIManager.getColor("JXLoginPane.bannerLightBackground"));
                g2.setPaint(gp);
                g2.fill(curveShape);
                originalGraphics.setColor(UIManager.getColor("JXLoginPane.bannerForeground"));
                originalGraphics.drawString(this.dlg.getBannerText(), loginStringX, loginStringY);
            }
            finally {
                originalGraphics.dispose();
            }
        }
        finally {
            g2.dispose();
        }
        return img;
    }

    private static class LocaleHandler
    implements PropertyChangeListener {
        private LocaleHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object src = evt.getSource();
            if (src instanceof JComponent) {
                ((JComponent)src).updateUI();
            }
        }
    }
}

