/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Shape;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.StringReader;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.basic.BasicButtonUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicHTML;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.ImageView;
import javax.swing.text.html.StyleSheet;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.SwingXUtilities;

public class BasicHyperlinkUI
extends BasicButtonUI {
    private static final Rectangle viewRect = new Rectangle();
    private static final Rectangle textRect = new Rectangle();
    private static final Rectangle iconRect = new Rectangle();
    protected int dashedRectGapX;
    protected int dashedRectGapY;
    protected int dashedRectGapWidth;
    protected int dashedRectGapHeight;
    private Color focusColor;
    private View ulv;
    private final PropertyChangeListener pcListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            BasicHyperlinkUI.this.ulv = null;
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new BasicHyperlinkUI();
    }

    @Override
    protected void installDefaults(AbstractButton b) {
        super.installDefaults(b);
        JXHyperlink link = (JXHyperlink)b;
        LookAndFeel.installProperty(b, "opaque", false);
        if (SwingXUtilities.isUIInstallable(link.getUnclickedColor())) {
            link.setUnclickedColor(UIManager.getColor("Hyperlink.linkColor"));
        }
        if (SwingXUtilities.isUIInstallable(link.getClickedColor())) {
            link.setClickedColor(UIManager.getColor("Hyperlink.visitedColor"));
        }
        b.setBorderPainted(false);
        b.setRolloverEnabled(true);
        if (SwingXUtilities.isUIInstallable(b.getBorder())) {
            b.setBorder(new BorderUIResource(BorderFactory.createEmptyBorder(0, 1, 0, 0)));
        }
        this.dashedRectGapX = UIManager.getInt("ButtonUI.dashedRectGapX");
        this.dashedRectGapY = UIManager.getInt("ButtonUI.dashedRectGapY");
        this.dashedRectGapWidth = UIManager.getInt("ButtonUI.dashedRectGapWidth");
        this.dashedRectGapHeight = UIManager.getInt("ButtonUI.dashedRectGapHeight");
        this.focusColor = UIManager.getColor("ButtonUI.focus");
        b.setHorizontalAlignment(10);
    }

    @Override
    protected void installListeners(AbstractButton b) {
        super.installListeners(b);
        b.addPropertyChangeListener(this.pcListener);
    }

    @Override
    protected void uninstallListeners(AbstractButton b) {
        super.uninstallListeners(b);
        b.removePropertyChangeListener(this.pcListener);
    }

    protected Color getFocusColor() {
        return this.focusColor;
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = g.getFontMetrics();
        Insets i = c.getInsets();
        BasicHyperlinkUI.viewRect.x = i.left;
        BasicHyperlinkUI.viewRect.y = i.top;
        BasicHyperlinkUI.viewRect.width = b.getWidth() - (i.right + BasicHyperlinkUI.viewRect.x);
        BasicHyperlinkUI.viewRect.height = b.getHeight() - (i.bottom + BasicHyperlinkUI.viewRect.y);
        BasicHyperlinkUI.textRect.height = 0;
        BasicHyperlinkUI.textRect.width = 0;
        BasicHyperlinkUI.textRect.y = 0;
        BasicHyperlinkUI.textRect.x = 0;
        BasicHyperlinkUI.iconRect.height = 0;
        BasicHyperlinkUI.iconRect.width = 0;
        BasicHyperlinkUI.iconRect.y = 0;
        BasicHyperlinkUI.iconRect.x = 0;
        Font f = c.getFont();
        g.setFont(f);
        String text = SwingUtilities.layoutCompoundLabel(c, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
        this.clearTextShiftOffset();
        if (model.isArmed() && model.isPressed()) {
            this.paintButtonPressed(g, b);
        }
        if (b.getIcon() != null) {
            this.paintIcon(g, c, iconRect);
        }
        if (text != null && !text.isEmpty()) {
            View v = (View)c.getClientProperty("html");
            if (v != null) {
                this.paintHTMLText(g, b, textRect, text, v);
            } else {
                this.paintText(g, b, textRect, text);
            }
        }
        if (b.isFocusPainted() && b.hasFocus()) {
            this.paintFocus(g, b, viewRect, textRect, iconRect);
        }
    }

    protected void paintHTMLText(Graphics g, AbstractButton b, Rectangle textRect, String text, View v) {
        textRect.x += this.getTextShiftOffset();
        textRect.y += this.getTextShiftOffset();
        if (b.getModel().isRollover()) {
            if (this.ulv == null) {
                this.ulv = ULHtml.createHTMLView(b, text);
            }
            this.ulv.paint(g, textRect);
        } else {
            v.paint(g, textRect);
        }
        textRect.x -= this.getTextShiftOffset();
        textRect.y -= this.getTextShiftOffset();
    }

    @Override
    protected void paintText(Graphics g, AbstractButton b, Rectangle textRect, String text) {
        if (!b.getModel().isEnabled()) {
            ++textRect.x;
        }
        super.paintText(g, b, textRect, text);
        if (b.getModel().isRollover()) {
            this.paintUnderline(g, b, textRect, text);
        }
    }

    private void paintUnderline(Graphics g, AbstractButton b, Rectangle rect, String text) {
        FontMetrics fm = g.getFontMetrics();
        int descent = fm.getDescent();
        g.drawLine(rect.x + this.getTextShiftOffset(), rect.y + rect.height - descent + 1 + this.getTextShiftOffset(), rect.x + rect.width + this.getTextShiftOffset(), rect.y + rect.height - descent + 1 + this.getTextShiftOffset());
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        if (b.getParent() instanceof JToolBar) {
            return;
        }
        g.setColor(this.getFocusColor());
        Rectangle iconTextRect = this.getIconTextRect(b);
        BasicGraphicsUtils.drawDashedRect(g, iconTextRect.x, iconTextRect.y, iconTextRect.width, iconTextRect.height);
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        this.setTextShiftOffset();
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return new BasicHyperlinkListener(b);
    }

    @Override
    public boolean contains(JComponent c, int x, int y) {
        AbstractButton button = (AbstractButton)c;
        return BasicHyperlinkUI.isInside(this.getIconTextRect(button), x, y);
    }

    private static boolean isInside(Rectangle iconTextRect, int x, int y) {
        if (iconTextRect == null) {
            return false;
        }
        return iconTextRect.contains(x, y);
    }

    protected Rectangle getIconTextRect(AbstractButton b) {
        if (b.getComponentCount() > 0) {
            return null;
        }
        Icon icon = b.getIcon();
        String text = b.getText();
        Font font = b.getFont();
        FontMetrics fm = b.getFontMetrics(font);
        Rectangle iconR = new Rectangle();
        Rectangle textR = new Rectangle();
        Rectangle viewR = new Rectangle(b.getSize());
        SwingUtilities.layoutCompoundLabel(b, fm, text, icon, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewR, iconR, textR, text == null ? 0 : b.getIconTextGap());
        Rectangle r = iconR.union(textR);
        Insets insets = b.getInsets();
        r.width += insets.left + insets.right;
        r.height += insets.top + insets.bottom;
        r.y -= insets.top;
        return r;
    }

    private static class ULHtml
    extends BasicHTML {
        private static BasicEditorKit basicHTMLFactory;
        private static ViewFactory basicHTMLViewFactory;
        private static final String STYLE_CHANGES = "p { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }body { margin-top: 0; margin-bottom: 0; margin-left: 0; margin-right: 0; text-decoration: underline }font {text-decoration: underline}";

        private ULHtml() {
        }

        public static View createHTMLView(JComponent c, String html) {
            BasicEditorKit kit = ULHtml.getFactory();
            Document doc = kit.createDefaultDocument(c.getFont(), c.getForeground());
            Object base = c.getClientProperty("html.base");
            if (base instanceof URL) {
                ((HTMLDocument)doc).setBase((URL)base);
            }
            StringReader r = new StringReader(html);
            try {
                kit.read(r, doc, 0);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            ViewFactory f = kit.getViewFactory();
            View hview = f.create(doc.getDefaultRootElement());
            return new Renderer(c, f, hview);
        }

        static BasicEditorKit getFactory() {
            if (basicHTMLFactory == null) {
                basicHTMLViewFactory = new BasicHTMLViewFactory();
                basicHTMLFactory = new BasicEditorKit();
            }
            return basicHTMLFactory;
        }

        private static class BasicEditorKit
        extends HTMLEditorKit {
            private static StyleSheet defaultStyles;

            private BasicEditorKit() {
            }

            @Override
            public StyleSheet getStyleSheet() {
                if (defaultStyles == null) {
                    defaultStyles = new StyleSheet();
                    StringReader r = new StringReader(ULHtml.STYLE_CHANGES);
                    try {
                        defaultStyles.loadRules(r, null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    r.close();
                    defaultStyles.addStyleSheet(super.getStyleSheet());
                }
                return defaultStyles;
            }

            public Document createDefaultDocument(Font defaultFont, Color foreground) {
                StyleSheet styles = this.getStyleSheet();
                StyleSheet ss = new StyleSheet();
                ss.addStyleSheet(styles);
                BasicDocument doc = new BasicDocument(ss, defaultFont, foreground);
                doc.setAsynchronousLoadPriority(Integer.MAX_VALUE);
                doc.setPreservesUnknownTags(false);
                return doc;
            }

            @Override
            public ViewFactory getViewFactory() {
                return basicHTMLViewFactory;
            }
        }

        private static class Renderer
        extends View {
            private int width;
            private final View view;
            private final ViewFactory factory;
            private final JComponent host;

            Renderer(JComponent c, ViewFactory f, View v) {
                super(null);
                this.host = c;
                this.factory = f;
                this.view = v;
                this.view.setParent(this);
                this.setSize(this.view.getPreferredSpan(0), this.view.getPreferredSpan(1));
            }

            @Override
            public AttributeSet getAttributes() {
                return null;
            }

            @Override
            public float getPreferredSpan(int axis) {
                if (axis == 0) {
                    return this.width;
                }
                return this.view.getPreferredSpan(axis);
            }

            @Override
            public float getMinimumSpan(int axis) {
                return this.view.getMinimumSpan(axis);
            }

            @Override
            public float getMaximumSpan(int axis) {
                return 2.1474836E9f;
            }

            @Override
            public void preferenceChanged(View child, boolean width, boolean height) {
                this.host.revalidate();
                this.host.repaint();
            }

            @Override
            public float getAlignment(int axis) {
                return this.view.getAlignment(axis);
            }

            @Override
            public void paint(Graphics g, Shape allocation) {
                Rectangle alloc = allocation.getBounds();
                this.view.setSize(alloc.width, alloc.height);
                this.view.paint(g, allocation);
            }

            @Override
            public void setParent(View parent) {
                throw new Error("Can't set parent on root view");
            }

            @Override
            public int getViewCount() {
                return 1;
            }

            @Override
            public View getView(int n) {
                return this.view;
            }

            @Override
            public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
                return this.view.modelToView(pos, a, b);
            }

            @Override
            public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
                return this.view.modelToView(p0, b0, p1, b1, a);
            }

            @Override
            public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
                return this.view.viewToModel(x, y, a, bias);
            }

            @Override
            public Document getDocument() {
                return this.view.getDocument();
            }

            @Override
            public int getStartOffset() {
                return this.view.getStartOffset();
            }

            @Override
            public int getEndOffset() {
                return this.view.getEndOffset();
            }

            @Override
            public Element getElement() {
                return this.view.getElement();
            }

            @Override
            public void setSize(float width, float height) {
                this.width = (int)width;
                this.view.setSize(width, height);
            }

            @Override
            public Container getContainer() {
                return this.host;
            }

            @Override
            public ViewFactory getViewFactory() {
                return this.factory;
            }
        }

        private static class BasicHTMLViewFactory
        extends HTMLEditorKit.HTMLFactory {
            private BasicHTMLViewFactory() {
            }

            @Override
            public View create(Element elem) {
                View view = super.create(elem);
                if (view instanceof ImageView) {
                    ((ImageView)view).setLoadsSynchronously(true);
                }
                return view;
            }
        }

        private static class BasicDocument
        extends HTMLDocument {
            private static String displayPropertiesToCSS(Font f, Color c) {
                StringBuilder rule = new StringBuilder("body {");
                if (f != null) {
                    rule.append(" font-family: ");
                    rule.append(f.getFamily());
                    rule.append(" ; ");
                    rule.append(" font-size: ");
                    rule.append(f.getSize());
                    rule.append("pt ;");
                    if (f.isBold()) {
                        rule.append(" font-weight: 700 ; ");
                    }
                    if (f.isItalic()) {
                        rule.append(" font-style: italic ; ");
                    }
                }
                if (c != null) {
                    rule.append(" color: #");
                    if (c.getRed() < 16) {
                        rule.append('0');
                    }
                    rule.append(Integer.toHexString(c.getRed()));
                    if (c.getGreen() < 16) {
                        rule.append('0');
                    }
                    rule.append(Integer.toHexString(c.getGreen()));
                    if (c.getBlue() < 16) {
                        rule.append('0');
                    }
                    rule.append(Integer.toHexString(c.getBlue()));
                    rule.append(" ; ");
                }
                rule.append(" }");
                return rule.toString();
            }

            BasicDocument(StyleSheet s, Font defaultFont, Color foreground) {
                super(s);
                this.setPreservesUnknownTags(false);
                this.setFontAndColor(defaultFont, foreground);
            }

            private void setFontAndColor(Font font, Color fg) {
                this.getStyleSheet().addRule(BasicDocument.displayPropertiesToCSS(font, fg));
            }
        }
    }

    public static class BasicHyperlinkListener
    extends BasicButtonListener {
        public BasicHyperlinkListener(AbstractButton b) {
            super(b);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            AbstractButton button = (AbstractButton)e.getSource();
            if (button.isRolloverEnabled()) {
                button.setCursor(button.getModel().isRollover() ? Cursor.getPredefinedCursor(12) : null);
            }
            super.stateChanged(e);
        }
    }
}

