/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import org.jdesktop.swingx.JXHyperlink;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.JXPanel;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;
import org.jdesktop.swingx.plaf.basic.CalendarHeaderHandler;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;

public class BasicCalendarHeaderHandler
extends CalendarHeaderHandler {
    @Override
    public void install(JXMonthView monthView) {
        super.install(monthView);
        this.getHeaderComponent().setActions(monthView.getActionMap().get("previousMonth"), monthView.getActionMap().get("nextMonth"), monthView.getActionMap().get("zoomOut"));
    }

    @Override
    protected void installNavigationActions() {
        super.installNavigationActions();
        ZoomOutAction zoomOutAction = new ZoomOutAction();
        zoomOutAction.setTarget(this.monthView);
        this.monthView.getActionMap().put("zoomOut", zoomOutAction);
    }

    @Override
    public void uninstall(JXMonthView monthView) {
        this.getHeaderComponent().setActions(null, null, null);
        super.uninstall(monthView);
    }

    @Override
    public BasicCalendarHeader getHeaderComponent() {
        return (BasicCalendarHeader)super.getHeaderComponent();
    }

    @Override
    protected BasicCalendarHeader createCalendarHeader() {
        return new BasicCalendarHeader();
    }

    private static class BasicCalendarHeader
    extends JXPanel {
        protected final AbstractButton prevButton;
        protected final AbstractButton nextButton;
        protected final JXHyperlink zoomOutLink;

        BasicCalendarHeader() {
            this.setLayout(new BoxLayout(this, 2));
            this.prevButton = BasicCalendarHeader.createNavigationButton();
            this.nextButton = BasicCalendarHeader.createNavigationButton();
            this.zoomOutLink = BasicCalendarHeader.createZoomLink();
            this.add(this.prevButton);
            this.add(Box.createHorizontalGlue());
            this.add(this.zoomOutLink);
            this.add(Box.createHorizontalGlue());
            this.add(this.nextButton);
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 2, 4));
        }

        public void setActions(Action prev, Action next, Action zoomOut) {
            this.prevButton.setAction(prev);
            this.nextButton.setAction(next);
            this.zoomOutLink.setAction(zoomOut);
        }

        @Override
        public void setFont(Font font) {
            super.setFont(font);
            if (this.zoomOutLink != null) {
                this.zoomOutLink.setFont(font);
            }
        }

        private static JXHyperlink createZoomLink() {
            JXHyperlink zoomOutLink = new JXHyperlink();
            Color textColor = new Color(16, 66, 104);
            zoomOutLink.setUnclickedColor(textColor);
            zoomOutLink.setClickedColor(textColor);
            zoomOutLink.setFocusable(false);
            return zoomOutLink;
        }

        private static AbstractButton createNavigationButton() {
            JXHyperlink b = new JXHyperlink();
            b.setContentAreaFilled(false);
            b.setBorder(BorderFactory.createEmptyBorder());
            b.setRolloverEnabled(true);
            b.setFocusable(false);
            return b;
        }
    }

    protected static class ZoomOutAction
    extends AbstractHyperlinkAction<JXMonthView> {
        private PropertyChangeListener linkListener;
        private String[] monthNames;
        private final StringValue tsv = value -> {
            if (value instanceof Calendar) {
                String month = this.monthNames[((Calendar)value).get(2)];
                return month + " " + ((Calendar)value).get(1);
            }
            return StringValues.TO_STRING.getString(value);
        };

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        @Override
        protected void installTarget() {
            if (this.getTarget() != null) {
                ((JXMonthView)this.getTarget()).addPropertyChangeListener(this.getTargetListener());
            }
            this.updateLocale();
            this.updateFromTarget();
        }

        private void updateLocale() {
            Locale current = this.getTarget() != null ? ((JXMonthView)this.getTarget()).getLocale() : Locale.getDefault();
            this.monthNames = DateFormatSymbols.getInstance(current).getMonths();
        }

        @Override
        protected void uninstallTarget() {
            if (this.getTarget() == null) {
                return;
            }
            ((JXMonthView)this.getTarget()).removePropertyChangeListener(this.getTargetListener());
        }

        protected void updateFromTarget() {
            if (this.tsv == null) {
                return;
            }
            Calendar calendar = this.getTarget() != null ? ((JXMonthView)this.getTarget()).getCalendar() : null;
            this.setName(this.tsv.getString(calendar));
        }

        private PropertyChangeListener getTargetListener() {
            if (this.linkListener == null) {
                this.linkListener = evt -> {
                    if ("firstDisplayedDay".equals(evt.getPropertyName())) {
                        this.updateFromTarget();
                    } else if ("locale".equals(evt.getPropertyName())) {
                        this.updateLocale();
                        this.updateFromTarget();
                    }
                };
            }
            return this.linkListener;
        }
    }
}

