/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.SafeBorder;

public class XListAddon
extends AbstractComponentAddon {
    public XListAddon() {
        super("JXList");
    }

    @Override
    protected void addBasicDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        defaults.add("XListUI", "org.jdesktop.swingx.plaf.basic.core.BasicXListUI");
        if (XListAddon.isGTK()) {
            XListAddon.replaceListTableBorders(addon, defaults);
        }
    }

    @Override
    protected void addNimbusDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        defaults.add("XListUI", "org.jdesktop.swingx.plaf.synth.SynthXListUI");
    }

    private static void replaceListTableBorders(LookAndFeelAddons addon, DefaultsList defaults) {
        XListAddon.replaceBorder(defaults, "List.", "focusCellHighlightBorder");
        XListAddon.replaceBorder(defaults, "List.", "focusSelectedCellHighlightBorder");
        XListAddon.replaceBorder(defaults, "List.", "noFocusBorder");
    }

    private static void replaceBorder(DefaultsList defaults, String componentPrefix, String borderKey) {
        Border border = UIManager.getBorder(componentPrefix + borderKey);
        if (border instanceof AbstractBorder && border instanceof UIResource && border.getClass().getName().contains("ListTable")) {
            border = new SafeBorder((AbstractBorder)border);
            String key = componentPrefix + borderKey;
            UIManager.getLookAndFeelDefaults().put(key, border);
        }
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }
}

