/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf;

import java.awt.Color;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.AbstractComponentAddon;
import org.jdesktop.swingx.plaf.DefaultsList;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.SafeBorder;

public class TableAddon
extends AbstractComponentAddon {
    public TableAddon() {
        super("JXTable");
    }

    @Override
    protected void addNimbusDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addNimbusDefaults(addon, defaults);
        if (Boolean.TRUE.equals(UIManager.get("Nimbus.keepAlternateRowColor"))) {
            return;
        }
        Object value = UIManager.getLookAndFeelDefaults().remove("Table.alternateRowColor");
        if (value instanceof Color) {
            defaults.add("UIColorHighlighter.stripingBackground", value, false);
        }
    }

    @Override
    protected void addBasicDefaults(LookAndFeelAddons addon, DefaultsList defaults) {
        super.addBasicDefaults(addon, defaults);
        if (TableAddon.isGTK()) {
            TableAddon.replaceListTableBorders(addon, defaults);
        }
    }

    private static void replaceListTableBorders(LookAndFeelAddons addon, DefaultsList defaults) {
        TableAddon.replaceBorder(defaults, "Table.", "focusCellHighlightBorder");
        TableAddon.replaceBorder(defaults, "Table.", "focusSelectedCellHighlightBorder");
        TableAddon.replaceBorder(defaults, "Table.", "noFocusBorder");
    }

    private static void replaceBorder(DefaultsList defaults, String componentPrefix, String borderKey) {
        Border border = UIManager.getBorder(componentPrefix + borderKey);
        if (border instanceof AbstractBorder && border instanceof UIResource && border.getClass().getName().contains("ListTable")) {
            border = new SafeBorder((AbstractBorder)border);
            String key = componentPrefix + borderKey;
            UIManager.getLookAndFeelDefaults().put(key, border);
        }
    }

    private static boolean isGTK() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }
}

