/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.hyperlink;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Logger;
import org.jdesktop.swingx.hyperlink.AbstractHyperlinkAction;

public class HyperlinkAction
extends AbstractHyperlinkAction<URI> {
    private static final Logger LOG = Logger.getLogger(HyperlinkAction.class.getName());
    private final Desktop.Action desktopAction;
    private URIVisitor visitor;

    public static HyperlinkAction createHyperlinkAction(URI uri) {
        Desktop.Action type = HyperlinkAction.isMailURI(uri) ? Desktop.Action.MAIL : Desktop.Action.BROWSE;
        return HyperlinkAction.createHyperlinkAction(uri, type);
    }

    public static HyperlinkAction createHyperlinkAction(URI uri, Desktop.Action type) {
        return new HyperlinkAction(uri, type);
    }

    private static boolean isMailURI(URI uri) {
        return uri != null && "mailto".equalsIgnoreCase(uri.getScheme());
    }

    public HyperlinkAction() {
        this(Desktop.Action.BROWSE);
    }

    public HyperlinkAction(Desktop.Action desktopAction) {
        this(null, desktopAction);
    }

    public HyperlinkAction(URI uri, Desktop.Action desktopAction) {
        if (!Desktop.isDesktopSupported()) {
            throw new UnsupportedOperationException("Desktop API is not supported on the current platform");
        }
        if (desktopAction != Desktop.Action.BROWSE && desktopAction != Desktop.Action.MAIL) {
            throw new IllegalArgumentException("Illegal action type: " + (Object)((Object)desktopAction) + ". Must be BROWSE or MAIL");
        }
        this.desktopAction = desktopAction;
        this.getURIVisitor();
        this.setTarget(uri);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.getURIVisitor().isEnabled((URI)this.getTarget())) {
            return;
        }
        try {
            this.getURIVisitor().visit((URI)this.getTarget());
            this.setVisited(true);
        }
        catch (IOException e1) {
            this.setVisited(false);
            LOG.fine("cant visit Desktop " + e);
        }
    }

    public Desktop.Action getDesktopAction() {
        return this.desktopAction;
    }

    @Override
    protected void installTarget() {
        if (this.visitor == null) {
            return;
        }
        super.installTarget();
        this.updateEnabled();
    }

    private void updateEnabled() {
        this.setEnabled(this.getURIVisitor().isEnabled((URI)this.getTarget()));
    }

    private URIVisitor getURIVisitor() {
        if (this.visitor == null) {
            this.visitor = this.createURIVisitor();
        }
        return this.visitor;
    }

    private URIVisitor createURIVisitor() {
        return this.getDesktopAction() == Desktop.Action.BROWSE ? new BrowseVisitor() : new MailVisitor();
    }

    private static abstract class URIVisitor {
        protected final boolean desktopSupported = Desktop.isDesktopSupported();

        private URIVisitor() {
        }

        public boolean isEnabled(URI uri) {
            return this.desktopSupported && this.isActionSupported();
        }

        public abstract void visit(URI var1) throws IOException;

        protected abstract boolean isActionSupported();
    }

    private static class BrowseVisitor
    extends URIVisitor {
        private BrowseVisitor() {
        }

        @Override
        public void visit(URI uri) throws IOException {
            Desktop.getDesktop().browse(uri);
        }

        @Override
        protected boolean isActionSupported() {
            return Desktop.getDesktop().isSupported(Desktop.Action.BROWSE);
        }

        @Override
        public boolean isEnabled(URI uri) {
            return uri != null && super.isEnabled(uri);
        }
    }

    private static class MailVisitor
    extends URIVisitor {
        private MailVisitor() {
        }

        @Override
        public void visit(URI uri) throws IOException {
            if (uri == null) {
                Desktop.getDesktop().mail();
            } else {
                Desktop.getDesktop().mail(uri);
            }
        }

        @Override
        protected boolean isActionSupported() {
            return Desktop.getDesktop().isSupported(Desktop.Action.MAIL);
        }
    }
}

