/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jdesktop.swingx.util.Contract;

public class FilterComposite
implements Composite {
    private final Composite composite;
    private BufferedImageOp filter;

    public FilterComposite(Composite composite) {
        this(composite, null);
    }

    public FilterComposite(Composite composite, BufferedImageOp filter) {
        Contract.asNotNull(composite, "composite cannot be null");
        this.composite = composite;
        this.filter = filter;
    }

    public BufferedImageOp getFilter() {
        return this.filter;
    }

    public void setFilter(BufferedImageOp filter) {
        this.filter = filter;
    }

    @Override
    public CompositeContext createContext(ColorModel srcColorModel, ColorModel dstColorModel, RenderingHints hints) {
        return new FilterContext(dstColorModel, this.composite.createContext(srcColorModel, dstColorModel, hints), this.filter);
    }

    private static class FilterContext
    implements CompositeContext {
        private final ColorModel dstModel;
        private CompositeContext ctx;
        private final BufferedImageOp filter;

        FilterContext(ColorModel dstModel, CompositeContext ctx, BufferedImageOp filter) {
            Contract.asNotNull(dstModel, "dstModel cannot be null");
            Contract.asNotNull(ctx, "context cannot be null");
            this.dstModel = dstModel;
            this.ctx = ctx;
            this.filter = filter;
        }

        @Override
        public void compose(Raster src, Raster dstIn, WritableRaster dstOut) {
            if (this.filter == null) {
                this.ctx.compose(src, dstIn, dstOut);
            } else {
                WritableRaster tempOut = this.dstModel.createCompatibleWritableRaster(dstOut.getWidth(), dstOut.getHeight());
                this.ctx.compose(src, dstIn, tempOut);
                this.filter.filter(new BufferedImage(this.dstModel, tempOut, this.dstModel.isAlphaPremultiplied(), null), new BufferedImage(this.dstModel, dstOut, this.dstModel.isAlphaPremultiplied(), null));
            }
        }

        @Override
        public void dispose() {
            this.ctx = null;
        }
    }
}

