/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.graphics;

import java.awt.Color;

public class ColorUtilities {
    private ColorUtilities() {
    }

    public static float[] RGBtoHSL(Color color) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), null);
    }

    public static float[] RGBtoHSL(Color color, float[] hsl) {
        return ColorUtilities.RGBtoHSL(color.getRed(), color.getGreen(), color.getBlue(), hsl);
    }

    public static float[] RGBtoHSL(int r, int g, int b) {
        return ColorUtilities.RGBtoHSL(r, g, b, null);
    }

    public static float[] RGBtoHSL(int r, int g, int b, float[] hsl) {
        float s;
        float h;
        float varMax;
        float varMin;
        if (hsl == null) {
            hsl = new float[3];
        } else if (hsl.length < 3) {
            throw new IllegalArgumentException("hsl array must have a length of at least 3");
        }
        if (r < 0) {
            r = 0;
        } else if (r > 255) {
            r = 255;
        }
        if (g < 0) {
            g = 0;
        } else if (g > 255) {
            g = 255;
        }
        if (b < 0) {
            b = 0;
        } else if (b > 255) {
            b = 255;
        }
        float varR = (float)r / 255.0f;
        float varG = (float)g / 255.0f;
        float varB = (float)b / 255.0f;
        if (varR > varG) {
            varMin = varG;
            varMax = varR;
        } else {
            varMin = varR;
            varMax = varG;
        }
        if (varB > varMax) {
            varMax = varB;
        }
        if (varB < varMin) {
            varMin = varB;
        }
        float delMax = varMax - varMin;
        float l = (varMax + varMin) / 2.0f;
        if (delMax - 0.01f <= 0.0f) {
            h = 0.0f;
            s = 0.0f;
        } else {
            s = l < 0.5f ? delMax / (varMax + varMin) : delMax / (2.0f - varMax - varMin);
            float delR = ((varMax - varR) / 6.0f + delMax / 2.0f) / delMax;
            float delG = ((varMax - varG) / 6.0f + delMax / 2.0f) / delMax;
            float delB = ((varMax - varB) / 6.0f + delMax / 2.0f) / delMax;
            h = varR == varMax ? delB - delG : (varG == varMax ? 0.33333334f + delR - delB : 0.6666667f + delG - delR);
            if (h < 0.0f) {
                h += 1.0f;
            }
            if (h > 1.0f) {
                h -= 1.0f;
            }
        }
        hsl[0] = h;
        hsl[1] = s;
        hsl[2] = l;
        return hsl;
    }

    public static Color HSLtoRGB(float h, float s, float l) {
        int[] rgb = ColorUtilities.HSLtoRGB(h, s, l, null);
        return new Color(rgb[0], rgb[1], rgb[2]);
    }

    public static int[] HSLtoRGB(float h, float s, float l, int[] rgb) {
        int b;
        int g;
        int r;
        if (rgb == null) {
            rgb = new int[3];
        } else if (rgb.length < 3) {
            throw new IllegalArgumentException("rgb array must have a length of at least 3");
        }
        if (h < 0.0f) {
            h = 0.0f;
        } else if (h > 1.0f) {
            h = 1.0f;
        }
        if (s < 0.0f) {
            s = 0.0f;
        } else if (s > 1.0f) {
            s = 1.0f;
        }
        if (l < 0.0f) {
            l = 0.0f;
        } else if (l > 1.0f) {
            l = 1.0f;
        }
        if (s - 0.01f <= 0.0f) {
            r = (int)(l * 255.0f);
            g = (int)(l * 255.0f);
            b = (int)(l * 255.0f);
        } else {
            float var2 = l < 0.5f ? l * (1.0f + s) : l + s - s * l;
            float var1 = 2.0f * l - var2;
            r = (int)(255.0f * ColorUtilities.hue2RGB(var1, var2, h + 0.33333334f));
            g = (int)(255.0f * ColorUtilities.hue2RGB(var1, var2, h));
            b = (int)(255.0f * ColorUtilities.hue2RGB(var1, var2, h - 0.33333334f));
        }
        rgb[0] = r;
        rgb[1] = g;
        rgb[2] = b;
        return rgb;
    }

    private static float hue2RGB(float v1, float v2, float vH) {
        if (vH < 0.0f) {
            vH += 1.0f;
        }
        if (vH > 1.0f) {
            vH -= 1.0f;
        }
        if (6.0f * vH < 1.0f) {
            return v1 + (v2 - v1) * 6.0f * vH;
        }
        if (2.0f * vH < 1.0f) {
            return v2;
        }
        if (3.0f * vH < 2.0f) {
            return v1 + (v2 - v1) * (0.6666667f - vH) * 6.0f;
        }
        return v1;
    }
}

