/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.beans.PropertyChangeListener;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.painter.AbstractPainter;
import org.jdesktop.swingx.painter.Painter;
import org.jdesktop.swingx.renderer.PainterAware;

public class PainterHighlighter
extends AbstractHighlighter {
    private Painter painter;
    private PropertyChangeListener painterListener;
    private boolean isAdjusting;

    public PainterHighlighter() {
        this(null, null);
    }

    public PainterHighlighter(HighlightPredicate predicate) {
        this(predicate, null);
    }

    public PainterHighlighter(Painter painter) {
        this(null, painter);
    }

    public PainterHighlighter(HighlightPredicate predicate, Painter painter) {
        super(predicate);
        this.setPainter(painter);
    }

    public Painter getPainter() {
        return this.painter;
    }

    public void setPainter(Painter painter) {
        if (this.areEqual(painter, this.getPainter())) {
            return;
        }
        this.uninstallPainterListener();
        this.painter = painter;
        this.installPainterListener();
        this.fireStateChanged();
    }

    protected void installPainterListener() {
        if (this.getPainter() instanceof AbstractPainter) {
            ((AbstractPainter)this.getPainter()).addPropertyChangeListener(this.getPainterListener());
        }
    }

    protected void uninstallPainterListener() {
        if (this.getPainter() instanceof AbstractPainter) {
            ((AbstractPainter)this.getPainter()).removePropertyChangeListener(this.painterListener);
        }
    }

    protected final PropertyChangeListener getPainterListener() {
        if (this.painterListener == null) {
            this.painterListener = this.createPainterListener();
        }
        return this.painterListener;
    }

    protected PropertyChangeListener createPainterListener() {
        return evt -> {
            if (this.isAdjusting) {
                return;
            }
            this.fireStateChanged();
        };
    }

    @Override
    public Component highlight(Component component, ComponentAdapter adapter) {
        this.isAdjusting = true;
        Component stamp = super.highlight(component, adapter);
        this.isAdjusting = false;
        return stamp;
    }

    @Override
    protected Component doHighlight(Component component, ComponentAdapter adapter) {
        ((PainterAware)((Object)component)).setPainter(this.painter);
        return component;
    }

    @Override
    protected boolean canHighlight(Component component, ComponentAdapter adapter) {
        return this.getPainter() != null && component instanceof PainterAware;
    }
}

