/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Component;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.util.Contract;

public interface HighlightPredicate {
    public static final HighlightPredicate ALWAYS = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return true;
        }
    };
    public static final HighlightPredicate NEVER = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return false;
        }
    };
    public static final HighlightPredicate ROLLOVER_ROW = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (!adapter.getComponent().isEnabled()) {
                return false;
            }
            Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
            return p != null && p.y == adapter.row;
        }
    };
    public static final HighlightPredicate ROLLOVER_COLUMN = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (!adapter.getComponent().isEnabled()) {
                return false;
            }
            Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
            return p != null && p.x == adapter.column;
        }
    };
    public static final HighlightPredicate ROLLOVER_CELL = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (!adapter.getComponent().isEnabled()) {
                return false;
            }
            Point p = (Point)adapter.getComponent().getClientProperty("swingx.rollover");
            return p != null && p.y == adapter.row && p.x == adapter.column;
        }
    };
    public static final HighlightPredicate EDITABLE = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.isEditable();
        }
    };
    public static final HighlightPredicate READ_ONLY = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !adapter.isEditable();
        }
    };
    public static final HighlightPredicate IS_LEAF = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.isLeaf();
        }
    };
    public static final HighlightPredicate IS_FOLDER = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !adapter.isLeaf();
        }
    };
    public static final HighlightPredicate IS_SELECTED = (renderer, adapter) -> adapter.isSelected();
    public static final HighlightPredicate IS_TEXT_TRUNCATED = (renderer, adapter) -> {
        JComponent c = renderer instanceof JComponent ? (JComponent)renderer : null;
        String text = adapter.getString();
        Icon icon = null;
        int gap = 0;
        if (renderer instanceof JLabel) {
            icon = ((JLabel)renderer).getIcon();
            gap = ((JLabel)renderer).getIconTextGap();
        } else if (renderer instanceof AbstractButton) {
            icon = ((AbstractButton)renderer).getIcon();
            gap = ((AbstractButton)renderer).getIconTextGap();
        }
        Rectangle cellBounds = adapter.getCellBounds();
        if (c != null && c.getBorder() != null) {
            Insets insets = c.getBorder().getBorderInsets(c);
            cellBounds.width -= insets.left + insets.right;
            cellBounds.height -= insets.top + insets.bottom;
        }
        int horizontalTextPosition = 11;
        int verticalTextPosition = 0;
        int horizontalAlignment = 10;
        int verticalAlignment = 0;
        String result = SwingUtilities.layoutCompoundLabel(c, renderer.getFontMetrics(renderer.getFont()), text, icon, verticalAlignment, horizontalAlignment, verticalTextPosition, horizontalTextPosition, cellBounds, new Rectangle(), new Rectangle(), gap);
        return !text.equals(result);
    };
    public static final HighlightPredicate HAS_FOCUS = new HighlightPredicate(){

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.hasFocus();
        }
    };
    public static final HighlightPredicate EVEN = (renderer, adapter) -> adapter.row % 2 == 0;
    public static final HighlightPredicate ODD = (renderer, adapter) -> !EVEN.isHighlighted(renderer, adapter);
    public static final HighlightPredicate BIG_DECIMAL_NEGATIVE = (renderer, adapter) -> adapter.getValue() instanceof BigDecimal && ((BigDecimal)adapter.getValue()).compareTo(BigDecimal.ZERO) < 0;
    public static final HighlightPredicate INTEGER_NEGATIVE = (renderer, adapter) -> adapter.getValue() instanceof Number && ((Number)adapter.getValue()).intValue() < 0;
    public static final HighlightPredicate[] EMPTY_PREDICATE_ARRAY = new HighlightPredicate[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final Integer[] EMPTY_INTEGER_ARRAY = new Integer[0];

    public boolean isHighlighted(Component var1, ComponentAdapter var2);

    public static class ColumnTypeHighlightPredicate
    implements HighlightPredicate {
        private final Class<?> clazz;

        public ColumnTypeHighlightPredicate() {
            this(Object.class);
        }

        public ColumnTypeHighlightPredicate(Class<?> compareValue) {
            this.clazz = Contract.asNotNull(compareValue, "compare class must not be null");
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return this.clazz.isAssignableFrom(adapter.getColumnClass());
        }

        public Class<?> getType() {
            return this.clazz;
        }
    }

    public static class TypeHighlightPredicate
    implements HighlightPredicate {
        private final Class<?> clazz;

        public TypeHighlightPredicate() {
            this(Object.class);
        }

        public TypeHighlightPredicate(Class<?> compareValue) {
            this.clazz = Contract.asNotNull(compareValue, "compare class must not be null");
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.getValue() != null ? this.clazz.isAssignableFrom(adapter.getValue().getClass()) : false;
        }

        public Class<?> getType() {
            return this.clazz;
        }
    }

    public static class EqualsHighlightPredicate
    implements HighlightPredicate {
        private final Object compareValue;

        public EqualsHighlightPredicate() {
            this(null);
        }

        public EqualsHighlightPredicate(Object compareValue) {
            this.compareValue = compareValue;
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            if (this.compareValue == null) {
                return adapter.getValue() == null;
            }
            return this.compareValue.equals(adapter.getValue());
        }

        public Object getCompareValue() {
            return this.compareValue;
        }
    }

    public static class DepthHighlightPredicate
    implements HighlightPredicate {
        private final List<Integer> depthList = new ArrayList<Integer>();

        public DepthHighlightPredicate(int ... depths) {
            for (int depth : depths) {
                this.depthList.add(depth);
            }
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int depth = adapter.getDepth();
            return this.depthList.contains(depth);
        }

        public Integer[] getDepths() {
            if (this.depthList.isEmpty()) {
                return EMPTY_INTEGER_ARRAY;
            }
            return this.depthList.toArray(new Integer[0]);
        }
    }

    public static class IdentifierHighlightPredicate
    implements HighlightPredicate {
        private final List<Object> columnList = new ArrayList<Object>();

        public IdentifierHighlightPredicate(Object ... columns) {
            Collections.addAll(this.columnList, columns);
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int modelIndex = adapter.convertColumnIndexToModel(adapter.column);
            Object identifier = adapter.getColumnIdentifierAt(modelIndex);
            return identifier != null ? this.columnList.contains(identifier) : false;
        }

        public Object[] getIdentifiers() {
            if (this.columnList.isEmpty()) {
                return EMPTY_OBJECT_ARRAY;
            }
            return this.columnList.toArray(new Object[0]);
        }
    }

    public static class ColumnHighlightPredicate
    implements HighlightPredicate {
        private final List<Integer> columnList = new ArrayList<Integer>();

        public ColumnHighlightPredicate(int ... columns) {
            for (int column : columns) {
                this.columnList.add(column);
            }
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            int modelIndex = adapter.convertColumnIndexToModel(adapter.column);
            return this.columnList.contains(modelIndex);
        }

        public Integer[] getColumns() {
            if (this.columnList.isEmpty()) {
                return EMPTY_INTEGER_ARRAY;
            }
            return this.columnList.toArray(new Integer[0]);
        }
    }

    public static class RowGroupHighlightPredicate
    implements HighlightPredicate {
        private final int linesPerGroup;

        public RowGroupHighlightPredicate(int linesPerGroup) {
            if (linesPerGroup < 1) {
                throw new IllegalArgumentException("a group contain at least 1 row, was: " + linesPerGroup);
            }
            this.linesPerGroup = linesPerGroup;
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return adapter.row / this.linesPerGroup % 2 == 1;
        }

        public int getLinesPerGroup() {
            return this.linesPerGroup;
        }
    }

    public static class OrHighlightPredicate
    implements HighlightPredicate {
        private final List<HighlightPredicate> predicate;

        public OrHighlightPredicate(HighlightPredicate ... predicate) {
            this.predicate = Arrays.asList(Contract.asNotNull(predicate, "predicate must not be null"));
        }

        public OrHighlightPredicate(Collection<HighlightPredicate> list) {
            this.predicate = new ArrayList<HighlightPredicate>(Contract.asNotNull(list, "predicate list must not be null"));
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            for (HighlightPredicate hp : this.predicate) {
                if (!hp.isHighlighted(renderer, adapter)) continue;
                return true;
            }
            return false;
        }

        public HighlightPredicate[] getHighlightPredicates() {
            if (this.predicate.isEmpty()) {
                return EMPTY_PREDICATE_ARRAY;
            }
            return this.predicate.toArray(EMPTY_PREDICATE_ARRAY);
        }
    }

    public static class AndHighlightPredicate
    implements HighlightPredicate {
        private final List<HighlightPredicate> predicate;

        public AndHighlightPredicate(HighlightPredicate ... predicate) {
            this.predicate = Arrays.asList(Contract.asNotNull(predicate, "predicate must not be null"));
        }

        public AndHighlightPredicate(Collection<HighlightPredicate> list) {
            this.predicate = new ArrayList<HighlightPredicate>(Contract.asNotNull(list, "predicate list must not be null"));
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            for (HighlightPredicate hp : this.predicate) {
                if (hp.isHighlighted(renderer, adapter)) continue;
                return false;
            }
            return !this.predicate.isEmpty();
        }

        public HighlightPredicate[] getHighlightPredicates() {
            if (this.predicate.isEmpty()) {
                return EMPTY_PREDICATE_ARRAY;
            }
            return this.predicate.toArray(EMPTY_PREDICATE_ARRAY);
        }
    }

    public static class NotHighlightPredicate
    implements HighlightPredicate {
        private final HighlightPredicate predicate;

        public NotHighlightPredicate(HighlightPredicate predicate) {
            if (predicate == null) {
                throw new NullPointerException("predicate must not be null");
            }
            this.predicate = predicate;
        }

        @Override
        public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
            return !this.predicate.isHighlighted(renderer, adapter);
        }

        public HighlightPredicate getHighlightPredicate() {
            return this.predicate;
        }
    }
}

