/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.List;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.Thumb;
import org.jdesktop.swingx.multislider.TrackRenderer;
import org.jdesktop.swingx.util.PaintUtils;

public class GradientTrackRenderer
extends JComponent
implements TrackRenderer<Color> {
    private final Paint checkerPaint = PaintUtils.getCheckerPaint();
    private JXMultiThumbSlider<Color> slider;

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        this.paintComponent(g);
    }

    @Override
    protected void paintComponent(Graphics gfx) {
        Graphics2D g = (Graphics2D)gfx;
        List<Thumb<Color>> stops = this.slider.getModel().getSortedThumbs();
        int len = stops.size();
        float[] fractions = new float[len];
        Color[] colors = new Color[len];
        int i = 0;
        for (Thumb<Color> thumb : stops) {
            colors[i] = thumb.getObject();
            fractions[i] = thumb.getPosition();
            ++i;
        }
        int thumbWidth = 12;
        int trackWidth = this.slider.getWidth() - thumbWidth;
        g.translate(thumbWidth / 2, 12);
        Rectangle rect = new Rectangle(0, 0, trackWidth, 20);
        g.setPaint(this.checkerPaint);
        g.fill(rect);
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(trackWidth, 0.0f);
        LinearGradientPaint paint = new LinearGradientPaint((float)((Point2D)start).getX(), (float)((Point2D)start).getY(), (float)((Point2D)end).getX(), (float)((Point2D)end).getY(), fractions, colors);
        g.setPaint(paint);
        g.fill(rect);
        g.setColor(Color.black);
        g.draw(rect);
        g.translate(-thumbWidth / 2, -12);
    }

    @Override
    public JComponent getRendererComponent(JXMultiThumbSlider<Color> slider) {
        this.slider = slider;
        return this;
    }
}

