/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JComponent;
import org.jdesktop.swingx.JXMultiThumbSlider;
import org.jdesktop.swingx.multislider.ThumbRenderer;
import org.jdesktop.swingx.util.PaintUtils;

public class GradientThumbRenderer
extends JComponent
implements ThumbRenderer {
    private static final Logger LOG = Logger.getLogger(GradientThumbRenderer.class.getName());
    private Image thumbBlack;
    private Image thumbGray;
    private boolean selected;

    public GradientThumbRenderer() {
        try {
            this.thumbBlack = ImageIO.read(GradientThumbRenderer.class.getResource("/icons/thumb_black.png"));
            this.thumbGray = ImageIO.read(GradientThumbRenderer.class.getResource("/icons/thumb_gray.png"));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Cannot load icons", ex);
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        GradientThumbRenderer thumb = this;
        int w = thumb.getWidth();
        g.setColor(this.getForeground());
        g.fillRect(0, 0, w - 1, w - 1);
        if (this.selected) {
            g.drawImage(this.thumbBlack, 0, 0, null);
        } else {
            g.drawImage(this.thumbGray, 0, 0, null);
        }
    }

    @Override
    public JComponent getThumbRendererComponent(JXMultiThumbSlider<?> slider, int index, boolean selected) {
        Color c = (Color)slider.getModel().getThumbAt(index).getObject();
        c = PaintUtils.removeAlpha(c);
        this.setForeground(c);
        this.selected = selected;
        return this;
    }
}

