/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Date;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jdesktop.swingx.calendar.AbstractDateSelectionModel;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.util.Contract;

public class SingleDaySelectionModel
extends AbstractDateSelectionModel {
    private final SortedSet<Date> selectedDates = new TreeSet<Date>();
    private final SortedSet<Date> unselectableDates = new TreeSet<Date>();

    public SingleDaySelectionModel() {
        this(null);
    }

    public SingleDaySelectionModel(Locale locale) {
        super(locale);
    }

    @Override
    public DateSelectionModel.SelectionMode getSelectionMode() {
        return DateSelectionModel.SelectionMode.SINGLE_SELECTION;
    }

    @Override
    public void setSelectionMode(DateSelectionModel.SelectionMode selectionMode) {
    }

    @Override
    public void addSelectionInterval(Date startDate, Date endDate) {
        this.setSelection(startDate);
    }

    @Override
    public void setSelectionInterval(Date startDate, Date endDate) {
        this.setSelection(startDate);
    }

    @Override
    public void removeSelectionInterval(Date startDate, Date endDate) {
        Contract.asNotNull(startDate, "date must not be null");
        if (this.isSelectionEmpty()) {
            return;
        }
        if (this.isSelectionInInterval(startDate, endDate)) {
            this.selectedDates.clear();
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_REMOVED);
        }
    }

    protected boolean isSelectionInInterval(Date startDate, Date endDate) {
        return !this.selectedDates.first().before(this.startOfDay(startDate)) && !this.selectedDates.first().after(this.endOfDay(endDate));
    }

    protected void setSelection(Date date) {
        Contract.asNotNull(date, "date must not be null");
        if (this.isSelectedStrict(date)) {
            return;
        }
        if (this.isSelectable(date)) {
            this.selectedDates.clear();
            this.selectedDates.add(date);
            this.fireValueChanged(DateSelectionEvent.EventType.DATES_SET);
        }
    }

    private boolean isSelectedStrict(Date date) {
        if (!this.isSelectionEmpty()) {
            return this.selectedDates.first().equals(date);
        }
        return false;
    }

    @Override
    public Date getFirstSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.first();
    }

    @Override
    public Date getLastSelectionDate() {
        return this.isSelectionEmpty() ? null : this.selectedDates.last();
    }

    public boolean isSelectable(Date date) {
        if (this.outOfBounds(date)) {
            return false;
        }
        return !this.inUnselectables(date);
    }

    private boolean inUnselectables(Date date) {
        for (Date unselectable : this.unselectableDates) {
            if (!this.isSameDay(unselectable, date)) continue;
            return true;
        }
        return false;
    }

    private boolean outOfBounds(Date date) {
        if (this.belowLowerBound(date)) {
            return true;
        }
        return this.aboveUpperBound(date);
    }

    private boolean aboveUpperBound(Date date) {
        if (this.upperBound != null) {
            return this.endOfDay(this.upperBound).before(date);
        }
        return false;
    }

    private boolean belowLowerBound(Date date) {
        if (this.lowerBound != null) {
            return this.startOfDay(this.lowerBound).after(date);
        }
        return false;
    }

    @Override
    public void clearSelection() {
        if (this.isSelectionEmpty()) {
            return;
        }
        this.selectedDates.clear();
        this.fireValueChanged(DateSelectionEvent.EventType.SELECTION_CLEARED);
    }

    @Override
    public SortedSet<Date> getSelection() {
        return new TreeSet<Date>(this.selectedDates);
    }

    @Override
    public boolean isSelected(Date date) {
        Contract.asNotNull(date, "date must not be null");
        if (this.isSelectionEmpty()) {
            return false;
        }
        return this.isSameDay(this.selectedDates.first(), date);
    }

    @Override
    public Date getNormalizedDate(Date date) {
        return new Date(date.getTime());
    }

    @Override
    public boolean isSelectionEmpty() {
        return this.selectedDates.isEmpty();
    }

    @Override
    public SortedSet<Date> getUnselectableDates() {
        return new TreeSet<Date>(this.unselectableDates);
    }

    @Override
    public void setUnselectableDates(SortedSet<Date> unselectables) {
        Contract.asNotNull(unselectables, "unselectable dates must not be null");
        this.unselectableDates.clear();
        for (Date unselectableDate : unselectables) {
            this.removeSelectionInterval(unselectableDate, unselectableDate);
            this.unselectableDates.add(unselectableDate);
        }
        this.fireValueChanged(DateSelectionEvent.EventType.UNSELECTED_DATES_CHANGED);
    }

    @Override
    public boolean isUnselectableDate(Date date) {
        return !this.isSelectable(date);
    }
}

