/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.util.Date;

public class DateSpan {
    private final long start;
    private final long end;

    public DateSpan(long start, long end) {
        this.start = start;
        this.end = end;
        if (this.start > this.end) {
            throw new IllegalArgumentException("Start date must be before end date");
        }
    }

    public DateSpan(Date start, Date end) {
        this(start.getTime(), end.getTime());
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        return this.end;
    }

    public Date getStartAsDate() {
        return new Date(this.getStart());
    }

    public Date getEndAsDate() {
        return new Date(this.getEnd());
    }

    public boolean contains(DateSpan span) {
        return this.contains(span.getStart()) && this.contains(span.getEnd());
    }

    public boolean contains(long time) {
        return time >= this.getStart() && time <= this.getEnd();
    }

    public boolean contains(long start, long end) {
        return start >= this.getStart() && end <= this.getEnd();
    }

    public boolean intersects(long start, long end) {
        return start <= this.getEnd() && end >= this.getStart();
    }

    public boolean intersects(DateSpan span) {
        return this.intersects(span.getStart(), span.getEnd());
    }

    public DateSpan add(DateSpan span) {
        return this.add(span.getStart(), span.getEnd());
    }

    public DateSpan add(long start, long end) {
        return new DateSpan(Math.min(start, this.getStart()), Math.max(end, this.getEnd()));
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DateSpan) {
            DateSpan ds = (DateSpan)o;
            return this.start == ds.getStart() && this.end == ds.getEnd();
        }
        return false;
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (int)(this.start ^ this.start >>> 32);
        result = 37 * result + (int)(this.end ^ this.end >>> 32);
        return result;
    }

    public String toString() {
        return "DateSpan [" + this.getStartAsDate() + "-" + this.getEndAsDate() + "]";
    }
}

