/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.calendar;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.JFormattedTextField;
import javax.swing.plaf.UIResource;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.Contract;

public class DatePickerFormatter
extends JFormattedTextField.AbstractFormatter {
    private static final Logger LOG = Logger.getLogger(DatePickerFormatter.class.getName());
    private final DateFormat[] formats;

    public DatePickerFormatter() {
        this(null, null);
    }

    public DatePickerFormatter(DateFormat[] formats) {
        this(formats, null);
    }

    public DatePickerFormatter(Locale locale) {
        this(null, locale);
    }

    public DatePickerFormatter(DateFormat[] formats, Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (formats == null) {
            formats = this.createDefaultFormats(locale);
        }
        Contract.asNotNull(formats, "The array of DateFormats must not contain null formats");
        this.formats = formats;
    }

    public DateFormat[] getFormats() {
        DateFormat[] results = new DateFormat[this.formats.length];
        System.arraycopy(this.formats, 0, results, 0, results.length);
        return results;
    }

    @Override
    public Object stringToValue(String text) throws ParseException {
        if (text == null || text.trim().length() == 0) {
            return null;
        }
        ParseException pex = null;
        Date result = null;
        for (DateFormat format : this.formats) {
            try {
                result = format.parse(text);
                pex = null;
                break;
            }
            catch (ParseException ex) {
                pex = ex;
            }
        }
        if (pex != null) {
            throw pex;
        }
        return result;
    }

    @Override
    public String valueToString(Object value) throws ParseException {
        if (value != null && this.formats.length > 0) {
            return this.formats[0].format(value);
        }
        return null;
    }

    protected DateFormat[] createDefaultFormats(Locale locale) {
        ArrayList<DateFormat> f = new ArrayList<DateFormat>();
        DatePickerFormatter.addFormat(f, "JXDatePicker.longFormat", locale);
        DatePickerFormatter.addFormat(f, "JXDatePicker.mediumFormat", locale);
        DatePickerFormatter.addFormat(f, "JXDatePicker.shortFormat", locale);
        if (f.isEmpty()) {
            DatePickerFormatter.addSystemDefaultFormat(f, locale);
        }
        return f.toArray(new DateFormat[0]);
    }

    private static void addSystemDefaultFormat(List<DateFormat> f, Locale locale) {
        f.add(DateFormat.getDateInstance(3, locale));
    }

    private static void addFormat(List<DateFormat> f, String key, Locale locale) {
        String pattern = UIManagerExt.getString(key, locale);
        if (pattern == null) {
            return;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat(pattern, locale);
            f.add(format);
        }
        catch (RuntimeException e) {
            LOG.finer("creating date format failed for key/pattern: " + key + "/" + pattern);
        }
    }

    public static class DatePickerFormatterUIResource
    extends DatePickerFormatter
    implements UIResource {
        public DatePickerFormatterUIResource(Locale locale) {
            super(locale);
        }

        public DatePickerFormatterUIResource() {
            this((Locale)null);
        }

        public DatePickerFormatterUIResource(DateFormat[] formats, Locale locale) {
            super(formats, locale);
        }
    }
}

