/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;
import org.jdesktop.swingx.autocomplete.ObjectToStringConverter;

public class ListAdaptor
extends AbstractAutoCompleteAdaptor
implements ListSelectionListener {
    private final JList<?> list;
    private final JTextComponent textComponent;
    private final ObjectToStringConverter stringConverter;

    public ListAdaptor(JList<?> list, JTextComponent textComponent) {
        this(list, textComponent, ObjectToStringConverter.DEFAULT_IMPLEMENTATION);
    }

    public ListAdaptor(JList<?> list, JTextComponent textComponent, ObjectToStringConverter stringConverter) {
        this.list = list;
        this.textComponent = textComponent;
        this.stringConverter = stringConverter;
        list.addListSelectionListener(this);
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.getTextComponent().setText(this.stringConverter.getPreferredStringForItem(this.list.getSelectedValue()));
        this.markEntireText();
    }

    @Override
    public Object getSelectedItem() {
        return this.list.getSelectedValue();
    }

    @Override
    public int getItemCount() {
        return this.list.getModel().getSize();
    }

    @Override
    public Object getItem(int index) {
        return this.list.getModel().getElementAt(index);
    }

    @Override
    public void setSelectedItem(Object item) {
        this.list.setSelectedValue(item, true);
    }

    @Override
    public JTextComponent getTextComponent() {
        return this.textComponent;
    }
}

