/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.autocomplete;

import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.autocomplete.AbstractAutoCompleteAdaptor;

public class ComboBoxAdaptor
extends AbstractAutoCompleteAdaptor
implements ActionListener {
    private final JComboBox<?> comboBox;

    public ComboBoxAdaptor(JComboBox<?> comboBox) {
        this.comboBox = comboBox;
        comboBox.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.markEntireText();
    }

    @Override
    public int getItemCount() {
        return this.comboBox.getItemCount();
    }

    @Override
    public Object getItem(int index) {
        return this.comboBox.getItemAt(index);
    }

    @Override
    public void setSelectedItem(Object item) {
        if (item == this.getSelectedItem()) {
            return;
        }
        Accessible a = this.comboBox.getUI().getAccessibleChild(this.comboBox, 0);
        if (this.getItemCount() > 0 && a instanceof ComboPopup) {
            int lastIndex;
            JList<Object> list = ((ComboPopup)((Object)a)).getList();
            Rectangle rect = list.getCellBounds(lastIndex = list.getModel().getSize() - 1, lastIndex);
            if (rect == null) {
                throw new IllegalStateException("attempting to access index " + lastIndex + " for " + this.comboBox);
            }
            list.scrollRectToVisible(rect);
        }
        this.comboBox.setSelectedItem(item);
    }

    @Override
    public Object getSelectedItem() {
        return this.comboBox.getModel().getSelectedItem();
    }

    @Override
    public JTextComponent getTextComponent() {
        return (JTextComponent)this.comboBox.getEditor().getEditorComponent();
    }
}

