/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.action.CompositeAction;
import org.jdesktop.swingx.action.ServerAction;
import org.jdesktop.swingx.action.TargetableAction;

public class ActionFactory {
    public static BoundAction createBoundAction(String id, String name, String mnemonic) {
        return ActionFactory.createBoundAction(id, name, mnemonic, false);
    }

    public static BoundAction createBoundAction(String id, String name, String mnemonic, boolean toggle) {
        return ActionFactory.createBoundAction(id, name, mnemonic, toggle, null);
    }

    public static BoundAction createBoundAction(String id, String name, String mnemonic, boolean toggle, String group) {
        return (BoundAction)ActionFactory.configureAction(new BoundAction(name, id), mnemonic, toggle, group);
    }

    public static CompositeAction createCompositeAction(String id, String name, String mnemonic) {
        return ActionFactory.createCompositeAction(id, name, mnemonic, false);
    }

    public static CompositeAction createCompositeAction(String id, String name, String mnemonic, boolean toggle) {
        return ActionFactory.createCompositeAction(id, name, mnemonic, toggle, null);
    }

    public static CompositeAction createCompositeAction(String id, String name, String mnemonic, boolean toggle, String group) {
        return (CompositeAction)ActionFactory.configureAction(new CompositeAction(name, id), mnemonic, toggle, group);
    }

    public static ServerAction createServerAction(String id, String name, String mnemonic) {
        ServerAction action = new ServerAction(name, id);
        if (mnemonic != null && !mnemonic.isEmpty()) {
            action.putValue("MnemonicKey", mnemonic.charAt(0));
        }
        return action;
    }

    public static TargetableAction createTargetableAction(String id, String name) {
        return ActionFactory.createTargetableAction(id, name, null);
    }

    public static TargetableAction createTargetableAction(String id, String name, String mnemonic) {
        return ActionFactory.createTargetableAction(id, name, mnemonic, false);
    }

    public static TargetableAction createTargetableAction(String id, String name, String mnemonic, boolean toggle) {
        return ActionFactory.createTargetableAction(id, name, mnemonic, toggle, null);
    }

    public static TargetableAction createTargetableAction(String id, String name, String mnemonic, boolean toggle, String group) {
        return (TargetableAction)ActionFactory.configureAction(new TargetableAction(name, id), mnemonic, toggle, group);
    }

    private static Action configureAction(AbstractActionExt action, String mnemonic, boolean toggle, String group) {
        action.setMnemonic(mnemonic);
        String description = action.getName() + " action with comand " + action.getActionCommand();
        action.setShortDescription(description);
        action.setLongDescription(description);
        if (toggle) {
            action.setStateAction();
        }
        if (group != null) {
            action.setGroup(group);
        }
        return action;
    }

    public static void decorateAction(AbstractAction action, String shortDesc, String longDesc, Icon smallIcon, Icon largeIcon, KeyStroke accel) {
        if (action instanceof AbstractActionExt) {
            AbstractActionExt a = (AbstractActionExt)action;
            a.setShortDescription(shortDesc);
            a.setLongDescription(longDesc);
            a.setSmallIcon(smallIcon);
            a.setLargeIcon(largeIcon);
            a.setAccelerator(accel);
        } else {
            action.putValue("ShortDescription", shortDesc);
            action.putValue("LongDescription", longDesc);
            action.putValue("SmallIcon", smallIcon);
            action.putValue("SwingLargeIconKey", largeIcon);
            action.putValue("AcceleratorKey", accel);
        }
    }
}

