/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.PrinterException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.DefaultCellEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTableHeader;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.action.BoundAction;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.CompoundHighlighter;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.ResetDTCRColorHighlighter;
import org.jdesktop.swingx.event.TableColumnModelExtListener;
import org.jdesktop.swingx.hyperlink.HyperlinkAction;
import org.jdesktop.swingx.plaf.LookAndFeelAddons;
import org.jdesktop.swingx.plaf.TableAddon;
import org.jdesktop.swingx.plaf.UIAction;
import org.jdesktop.swingx.plaf.UIDependent;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.renderer.AbstractRenderer;
import org.jdesktop.swingx.renderer.CheckBoxProvider;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.HyperlinkProvider;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.rollover.RolloverProducer;
import org.jdesktop.swingx.rollover.TableRolloverController;
import org.jdesktop.swingx.rollover.TableRolloverProducer;
import org.jdesktop.swingx.search.SearchFactory;
import org.jdesktop.swingx.search.Searchable;
import org.jdesktop.swingx.search.TableSearchable;
import org.jdesktop.swingx.sort.DefaultSortController;
import org.jdesktop.swingx.sort.SortController;
import org.jdesktop.swingx.sort.SortUtils;
import org.jdesktop.swingx.sort.StringValueRegistry;
import org.jdesktop.swingx.sort.TableSortController;
import org.jdesktop.swingx.table.ColumnControlButton;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.NumberEditorExt;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class JXTable
extends JTable
implements TableColumnModelExtListener {
    public static final String FOCUS_PREVIOUS_COMPONENT = "focusPreviousComponent";
    public static final String FOCUS_NEXT_COMPONENT = "focusNextComponent";
    private static final Logger LOG = Logger.getLogger(JXTable.class.getName());
    public static final String HORIZONTALSCROLL_ACTION_COMMAND = "column.horizontalScroll";
    public static final String PACKALL_ACTION_COMMAND = "column.packAll";
    public static final String PACKSELECTED_ACTION_COMMAND = "column.packSelected";
    public static final String UIPREFIX = "JXTable.";
    public static final String MATCH_HIGHLIGHTER = "match.highlighter";
    protected CompoundHighlighter compoundHighlighter;
    public static final String USE_DTCR_COLORMEMORY_HACK = "useDTCRColorMemoryHack";
    protected Highlighter resetDefaultTableCellRendererHighlighter;
    protected ComponentAdapter dataAdapter;
    private ChangeListener highlighterChangeListener;
    private ColumnFactory columnFactory;
    private int visibleRowCount = 20;
    private int visibleColumnCount = -1;
    private boolean columnControlVisible;
    private int verticalScrollPolicy;
    private JComponent columnControlButton;
    private transient RolloverProducer rolloverProducer;
    private transient TableRolloverController<JXTable> linkController;
    private int oldAutoResizeMode;
    private boolean intelliMode;
    private boolean inLayout;
    protected boolean isXTableRowHeightSet;
    protected Searchable searchable;
    private boolean editable;
    private Dimension calculatedPrefScrollableViewportSize;
    private boolean autoCreateRowSorter;
    private boolean sortable;
    private boolean sortsOnUpdates;
    private boolean ignoreAddColumn;
    private transient StringValueRegistry stringValueRegistry;
    private SortOrder[] sortOrderCycle;
    protected boolean forceRevalidate;
    protected boolean filteredRowCountChanged;
    protected transient CellEditorRemover editorRemover;

    public JXTable() {
        this.init();
    }

    public JXTable(TableModel dm) {
        super(dm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.init();
    }

    public JXTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.init();
    }

    public JXTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.init();
    }

    public JXTable(Vector<? extends Vector> rowData, Vector<?> columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    public JXTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.init();
    }

    private void init() {
        this.putClientProperty(USE_DTCR_COLORMEMORY_HACK, Boolean.TRUE);
        this.initDefaultStringValues();
        this.sortOrderCycle = DefaultSortController.getDefaultSortOrderCycle();
        this.setSortsOnUpdates(true);
        this.setSortable(true);
        this.setAutoCreateRowSorter(true);
        this.setRolloverEnabled(true);
        this.setEditable(true);
        this.setTerminateEditOnFocusLost(true);
        this.initActionsAndBindings();
        this.initFocusBindings();
        this.updateRowHeightUI(false);
        this.setPreferredScrollableViewportSize(null);
        this.initializeColumnWidths();
        this.setFillsViewportHeight(true);
        this.updateLocaleState(this.getLocale());
    }

    public void setRolloverEnabled(boolean rolloverEnabled) {
        boolean old = this.isRolloverEnabled();
        if (rolloverEnabled == old) {
            return;
        }
        if (rolloverEnabled) {
            this.rolloverProducer = this.createRolloverProducer();
            this.rolloverProducer.install(this);
            this.getLinkController().install(this);
        } else {
            this.rolloverProducer.release(this);
            this.rolloverProducer = null;
            this.getLinkController().release();
        }
        this.firePropertyChange("rolloverEnabled", old, this.isRolloverEnabled());
    }

    public boolean isRolloverEnabled() {
        return this.rolloverProducer != null;
    }

    protected TableRolloverController<JXTable> getLinkController() {
        if (this.linkController == null) {
            this.linkController = this.createLinkController();
        }
        return this.linkController;
    }

    protected TableRolloverController<JXTable> createLinkController() {
        return new TableRolloverController<JXTable>();
    }

    protected RolloverProducer createRolloverProducer() {
        return new TableRolloverProducer();
    }

    public boolean isColumnControlVisible() {
        return this.columnControlVisible;
    }

    public void setColumnControlVisible(boolean visible) {
        if (this.isColumnControlVisible() == visible) {
            return;
        }
        boolean old = this.isColumnControlVisible();
        if (old) {
            this.unconfigureColumnControl();
        }
        this.columnControlVisible = visible;
        if (this.isColumnControlVisible()) {
            this.configureColumnControl();
        }
        this.firePropertyChange("columnControlVisible", old, !old);
    }

    public JComponent getColumnControl() {
        if (this.columnControlButton == null) {
            this.columnControlButton = this.createDefaultColumnControl();
        }
        return this.columnControlButton;
    }

    public void setColumnControl(JComponent columnControl) {
        JComponent old = this.columnControlButton;
        this.columnControlButton = columnControl;
        this.configureColumnControl();
        this.firePropertyChange("columnControl", old, this.getColumnControl());
    }

    protected JComponent createDefaultColumnControl() {
        return new ColumnControlButton(this);
    }

    @Override
    public void setComponentOrientation(ComponentOrientation o) {
        this.removeColumnControlFromCorners();
        super.setComponentOrientation(o);
        this.configureColumnControl();
    }

    protected void removeColumnControlFromCorners() {
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane == null || !this.isColumnControlVisible()) {
            return;
        }
        this.removeColumnControlFromCorners(scrollPane, "UPPER_LEFT_CORNER", "UPPER_RIGHT_CORNER");
    }

    private void removeColumnControlFromCorners(JScrollPane scrollPane, String ... corners) {
        for (String corner : corners) {
            if (scrollPane.getCorner(corner) != this.getColumnControl()) continue;
            scrollPane.setCorner(corner, null);
        }
    }

    @Override
    protected void configureEnclosingScrollPane() {
        super.configureEnclosingScrollPane();
        this.configureColumnControl();
    }

    @Override
    protected void unconfigureEnclosingScrollPane() {
        this.unconfigureColumnControl();
        super.unconfigureEnclosingScrollPane();
    }

    protected void unconfigureColumnControl() {
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane == null) {
            return;
        }
        if (this.verticalScrollPolicy != 0) {
            scrollPane.setVerticalScrollBarPolicy(this.verticalScrollPolicy);
            this.verticalScrollPolicy = 0;
        }
        if (this.isColumnControlVisible()) {
            scrollPane.setCorner("UPPER_TRAILING_CORNER", null);
        }
    }

    protected void configureColumnControl() {
        if (!this.isColumnControlVisible()) {
            return;
        }
        JScrollPane scrollPane = this.getEnclosingScrollPane();
        if (scrollPane == null) {
            return;
        }
        if (this.verticalScrollPolicy == 0) {
            this.verticalScrollPolicy = scrollPane.getVerticalScrollBarPolicy();
        }
        scrollPane.setCorner("UPPER_TRAILING_CORNER", this.getColumnControl());
        scrollPane.setVerticalScrollBarPolicy(22);
    }

    protected JScrollPane getEnclosingScrollPane() {
        Container gp;
        Container p = this.getParent();
        if (p instanceof JViewport && (gp = p.getParent()) instanceof JScrollPane) {
            JScrollPane scrollPane = (JScrollPane)gp;
            JViewport viewport = scrollPane.getViewport();
            if (viewport == null || viewport.getView() != this) {
                return null;
            }
            return scrollPane;
        }
        return null;
    }

    private void initFocusBindings() {
        this.setFocusTraversalKeys(0, Collections.emptySet());
        this.setFocusTraversalKeys(1, Collections.emptySet());
        this.getInputMap(1).put(KeyStroke.getKeyStroke("ctrl TAB"), FOCUS_NEXT_COMPONENT);
        this.getInputMap(1).put(KeyStroke.getKeyStroke("shift ctrl TAB"), FOCUS_PREVIOUS_COMPONENT);
        this.getActionMap().put(FOCUS_NEXT_COMPONENT, this.createFocusTransferAction(true));
        this.getActionMap().put(FOCUS_PREVIOUS_COMPONENT, this.createFocusTransferAction(false));
    }

    private Action createFocusTransferAction(boolean forward) {
        BoundAction action = new BoundAction(null, forward ? FOCUS_NEXT_COMPONENT : FOCUS_PREVIOUS_COMPONENT);
        action.registerCallback(this, forward ? "transferFocus" : "transferFocusBackward");
        return action;
    }

    private void initActionsAndBindings() {
        ActionMap map = this.getActionMap();
        map.put("print", new Actions("print"));
        map.put("find", new Actions("find"));
        map.put("cancel", this.createCancelAction());
        map.put(PACKALL_ACTION_COMMAND, this.createPackAllAction());
        map.put(PACKSELECTED_ACTION_COMMAND, this.createPackSelectedAction());
        map.put(HORIZONTALSCROLL_ACTION_COMMAND, this.createHorizontalScrollAction());
        KeyStroke findStroke = SearchFactory.getInstance().getSearchAccelerator();
        this.getInputMap(1).put(findStroke, "find");
    }

    private Action createCancelAction() {
        return new AbstractActionExt(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!JXTable.this.isEditing()) {
                    return;
                }
                JXTable.this.getCellEditor().cancelCellEditing();
            }

            @Override
            public boolean isEnabled() {
                return JXTable.this.isEditing();
            }
        };
    }

    private Action createHorizontalScrollAction() {
        BoundAction action = new BoundAction(null, HORIZONTALSCROLL_ACTION_COMMAND);
        action.setStateAction();
        action.registerCallback(this, "setHorizontalScrollEnabled");
        action.setSelected(this.isHorizontalScrollEnabled());
        return action;
    }

    protected String getUIString(String key) {
        return this.getUIString(key, this.getLocale());
    }

    protected String getUIString(String key, Locale locale) {
        String text = UIManagerExt.getString(UIPREFIX + key, locale);
        return text != null ? text : key;
    }

    private Action createPackSelectedAction() {
        BoundAction action = new BoundAction(null, PACKSELECTED_ACTION_COMMAND);
        action.registerCallback(this, "packSelected");
        action.setEnabled(this.getSelectedColumnCount() > 0);
        return action;
    }

    private Action createPackAllAction() {
        BoundAction action = new BoundAction(null, PACKALL_ACTION_COMMAND);
        action.registerCallback(this, "packAll");
        return action;
    }

    @Override
    public void setLocale(Locale locale) {
        this.updateLocaleState(locale);
        super.setLocale(locale);
    }

    protected void updateLocaleState(Locale locale) {
        this.updateLocaleActionState(HORIZONTALSCROLL_ACTION_COMMAND, locale);
        this.updateLocaleActionState(PACKALL_ACTION_COMMAND, locale);
        this.updateLocaleActionState(PACKSELECTED_ACTION_COMMAND, locale);
    }

    protected void updateLocaleActionState(String key, Locale locale) {
        Action action = this.getActionMap().get(key);
        if (action == null) {
            return;
        }
        action.putValue("Name", this.getUIString(key, locale));
    }

    public void packAll() {
        this.packTable(-1);
    }

    public void packSelected() {
        int selected = this.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        if (selected >= 0) {
            this.packColumn(selected, -1);
        }
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent e) {
        super.columnSelectionChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        Action packSelected = this.getActionMap().get(PACKSELECTED_ACTION_COMMAND);
        if (packSelected != null) {
            packSelected.setEnabled(!((ListSelectionModel)e.getSource()).isSelectionEmpty());
        }
    }

    public void setHorizontalScrollEnabled(boolean enabled) {
        if (enabled == this.isHorizontalScrollEnabled()) {
            return;
        }
        boolean old = this.isHorizontalScrollEnabled();
        if (enabled) {
            if (this.getAutoResizeMode() != 0) {
                this.oldAutoResizeMode = this.getAutoResizeMode();
            }
            this.setAutoResizeMode(0);
            this.intelliMode = true;
            this.updateHorizontalAction();
        } else {
            this.setAutoResizeMode(this.oldAutoResizeMode);
        }
        this.firePropertyChange("horizontalScrollEnabled", old, this.isHorizontalScrollEnabled());
    }

    public boolean isHorizontalScrollEnabled() {
        return this.intelliMode && this.getAutoResizeMode() == 0;
    }

    @Override
    public void setAutoResizeMode(int mode) {
        if (mode != 0) {
            this.oldAutoResizeMode = mode;
        }
        this.intelliMode = false;
        super.setAutoResizeMode(mode);
        this.updateHorizontalAction();
    }

    protected void updateHorizontalAction() {
        Action showHorizontal = this.getActionMap().get(HORIZONTALSCROLL_ACTION_COMMAND);
        if (showHorizontal instanceof BoundAction) {
            ((BoundAction)showHorizontal).setSelected(this.isHorizontalScrollEnabled());
        }
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        boolean shouldTrack = super.getScrollableTracksViewportWidth();
        if (this.isHorizontalScrollEnabled()) {
            return this.hasExcessWidth();
        }
        return shouldTrack;
    }

    @Override
    public void doLayout() {
        int resizeMode = this.getAutoResizeMode();
        if (this.isHorizontalScrollEnabled() && this.hasRealizedParent() && this.hasExcessWidth()) {
            this.autoResizeMode = this.oldAutoResizeMode;
        }
        this.inLayout = true;
        super.doLayout();
        this.inLayout = false;
        this.autoResizeMode = resizeMode;
    }

    private boolean hasRealizedParent() {
        return this.getWidth() > 0 && this.getParent() != null && this.getParent().getWidth() > 0;
    }

    private boolean hasExcessWidth() {
        return this.getPreferredSize().width < this.getParent().getWidth();
    }

    @Override
    public void columnMarginChanged(ChangeEvent e) {
        TableColumn resizingColumn;
        if (this.isEditing()) {
            this.removeEditor();
        }
        if ((resizingColumn = this.getResizingColumn()) != null && this.autoResizeMode == 0 && !this.inLayout) {
            resizingColumn.setPreferredWidth(resizingColumn.getWidth());
        }
        this.resizeAndRepaint();
    }

    private TableColumn getResizingColumn() {
        return this.tableHeader == null ? null : this.tableHeader.getResizingColumn();
    }

    @Override
    public void setFillsViewportHeight(boolean fillsViewportHeight) {
        if (fillsViewportHeight == this.getFillsViewportHeight()) {
            return;
        }
        super.setFillsViewportHeight(fillsViewportHeight);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        if (!this.isCellEditable(row, column)) {
            return;
        }
        super.setValueAt(aValue, row, column);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        TableColumnExt tableColumn;
        if (!this.isEditable()) {
            return false;
        }
        boolean editable = super.isCellEditable(row, column);
        if (editable && (tableColumn = this.getColumnExt(column)) != null) {
            editable = tableColumn.isEditable();
        }
        return editable;
    }

    @Override
    public boolean getAutoCreateColumnsFromModel() {
        return super.getAutoCreateColumnsFromModel();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.preprocessModelChange(e);
        super.tableChanged(e);
        if (this.isStructureChanged(e) && this.getAutoCreateColumnsFromModel()) {
            this.initializeColumnWidths();
            this.resetCalculatedScrollableSize(true);
        }
        if (this.isStructureChanged(e)) {
            this.updateStringValueRegistryColumnClasses();
        }
        this.postprocessModelChange(e);
    }

    @Override
    public void sorterChanged(RowSorterEvent e) {
        super.sorterChanged(e);
        this.postprocessSorterChanged(e);
    }

    protected void preprocessModelChange(TableModelEvent e) {
        this.forceRevalidate = this.getSortsOnUpdates() && this.getRowFilter() != null && this.isUpdate(e);
    }

    protected void postprocessModelChange(TableModelEvent e) {
        if (this.forceRevalidate && this.filteredRowCountChanged) {
            this.resizeAndRepaint();
        }
        this.filteredRowCountChanged = false;
        this.forceRevalidate = false;
    }

    protected void postprocessSorterChanged(RowSorterEvent e) {
        this.filteredRowCountChanged = false;
        if (this.forceRevalidate && e.getType() == RowSorterEvent.Type.SORTED) {
            this.filteredRowCountChanged = e.getPreviousRowCount() != this.getRowCount();
        }
    }

    @Override
    public void setModel(TableModel dataModel) {
        boolean old = this.getAutoCreateRowSorter();
        try {
            this.autoCreateRowSorter = false;
            this.ignoreAddColumn = true;
            super.setModel(dataModel);
        }
        finally {
            this.autoCreateRowSorter = old;
            this.ignoreAddColumn = false;
        }
        if (this.getAutoCreateRowSorter()) {
            this.setRowSorter(this.createDefaultRowSorter());
        }
    }

    @Override
    public void setColumnModel(TableColumnModel columnModel) {
        super.setColumnModel(columnModel);
        this.configureSorterProperties();
        this.initPerColumnStringValues();
    }

    @Override
    public void setAutoCreateRowSorter(boolean autoCreateRowSorter) {
        if (this.getAutoCreateRowSorter() == autoCreateRowSorter) {
            return;
        }
        boolean oldValue = this.getAutoCreateRowSorter();
        this.autoCreateRowSorter = autoCreateRowSorter;
        if (autoCreateRowSorter) {
            this.setRowSorter(this.createDefaultRowSorter());
        }
        this.firePropertyChange("autoCreateRowSorter", oldValue, this.getAutoCreateRowSorter());
    }

    @Override
    public boolean getAutoCreateRowSorter() {
        return this.autoCreateRowSorter;
    }

    @Override
    public void setRowSorter(RowSorter<? extends TableModel> sorter) {
        super.setRowSorter(sorter);
        this.configureSorterProperties();
    }

    protected void configureSorterProperties() {
        if (this.ignoreAddColumn || !this.getControlsSorterProperties()) {
            return;
        }
        this.getSortController().setStringValueProvider(this.getStringValueRegistry());
        this.getSortController().setSortable(this.sortable);
        this.getSortController().setSortsOnUpdates(this.sortsOnUpdates);
        this.getSortController().setSortOrderCycle(this.getSortOrderCycle());
        List<TableColumn> columns = this.getColumns(true);
        for (TableColumn tableColumn : columns) {
            int modelIndex = tableColumn.getModelIndex();
            this.getSortController().setSortable(modelIndex, tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).isSortable() : true);
            this.getSortController().setComparator(modelIndex, tableColumn instanceof TableColumnExt ? ((TableColumnExt)tableColumn).getComparator() : null);
        }
    }

    protected RowSorter<? extends TableModel> createDefaultRowSorter() {
        return new TableSortController<TableModel>(this.getModel());
    }

    protected boolean isDataChanged(TableModelEvent e) {
        if (e == null) {
            return false;
        }
        return e.getType() == 0 && e.getFirstRow() == 0 && e.getLastRow() == Integer.MAX_VALUE;
    }

    protected boolean isUpdate(TableModelEvent e) {
        if (this.isStructureChanged(e)) {
            return false;
        }
        return e.getType() == 0 && e.getLastRow() < Integer.MAX_VALUE;
    }

    protected boolean isStructureChanged(TableModelEvent e) {
        return e == null || e.getFirstRow() == -1;
    }

    public void setSortable(boolean sortable) {
        boolean old = this.isSortable();
        this.sortable = sortable;
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortable(sortable);
        }
        this.firePropertyChange("sortable", old, this.isSortable());
    }

    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortsOnUpdates(boolean sortsOnUpdates) {
        boolean old = this.getSortsOnUpdates();
        this.sortsOnUpdates = sortsOnUpdates;
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortsOnUpdates(sortsOnUpdates);
        }
        this.firePropertyChange("sortsOnUpdates", old, this.getSortsOnUpdates());
    }

    public boolean getSortsOnUpdates() {
        return this.sortsOnUpdates;
    }

    public void setSortOrderCycle(SortOrder ... cycle) {
        SortOrder[] old = this.getSortOrderCycle();
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortOrderCycle(cycle);
        }
        this.sortOrderCycle = Arrays.copyOf(cycle, cycle.length);
        this.firePropertyChange("sortOrderCycle", old, this.getSortOrderCycle());
    }

    public SortOrder[] getSortOrderCycle() {
        return Arrays.copyOf(this.sortOrderCycle, this.sortOrderCycle.length);
    }

    public <R extends TableModel> void setRowFilter(RowFilter<? super R, ? super Integer> filter) {
        if (this.hasSortController()) {
            SortController<? extends TableModel> controller = this.getSortController();
            controller.setRowFilter(filter);
        }
    }

    public RowFilter<?, ?> getRowFilter() {
        return this.hasSortController() ? this.getSortController().getRowFilter() : null;
    }

    public void resetSortOrder() {
        if (!this.hasSortController()) {
            return;
        }
        this.getSortController().resetSortOrders();
        if (this.getTableHeader() != null) {
            this.getTableHeader().repaint();
        }
    }

    public void toggleSortOrder(int columnIndex) {
        if (this.hasSortController()) {
            this.getSortController().toggleSortOrder(this.convertColumnIndexToModel(columnIndex));
        }
    }

    public void setSortOrder(int columnIndex, SortOrder sortOrder) {
        if (this.hasSortController()) {
            this.getSortController().setSortOrder(this.convertColumnIndexToModel(columnIndex), sortOrder);
        }
    }

    public SortOrder getSortOrder(int columnIndex) {
        if (this.hasSortController()) {
            return this.getSortController().getSortOrder(this.convertColumnIndexToModel(columnIndex));
        }
        return SortOrder.UNSORTED;
    }

    public void toggleSortOrder(Object identifier) {
        if (!this.hasSortController()) {
            return;
        }
        TableColumn columnExt = this.getColumnByIdentifier(identifier);
        if (columnExt == null) {
            return;
        }
        this.getSortController().toggleSortOrder(columnExt.getModelIndex());
    }

    public void setSortOrder(Object identifier, SortOrder sortOrder) {
        if (!this.hasSortController()) {
            return;
        }
        TableColumn columnExt = this.getColumnByIdentifier(identifier);
        if (columnExt == null) {
            return;
        }
        this.getSortController().setSortOrder(columnExt.getModelIndex(), sortOrder);
    }

    public SortOrder getSortOrder(Object identifier) {
        if (!this.hasSortController()) {
            return SortOrder.UNSORTED;
        }
        TableColumn columnExt = this.getColumnByIdentifier(identifier);
        if (columnExt == null) {
            return SortOrder.UNSORTED;
        }
        int modelIndex = columnExt.getModelIndex();
        return this.getSortController().getSortOrder(modelIndex);
    }

    private TableColumn getColumnByIdentifier(Object identifier) {
        TableColumn columnExt;
        try {
            columnExt = this.getColumn(identifier);
        }
        catch (IllegalArgumentException e) {
            columnExt = this.getColumnExt(identifier);
        }
        return columnExt;
    }

    protected SortController<? extends TableModel> getSortController() {
        if (this.hasSortController()) {
            return (SortController)((Object)this.getRowSorter());
        }
        return null;
    }

    protected boolean hasSortController() {
        return this.getRowSorter() instanceof SortController;
    }

    protected boolean getControlsSorterProperties() {
        return this.hasSortController() && this.getAutoCreateRowSorter();
    }

    public TableColumn getSortedColumn() {
        RowSorter.SortKey sortKey;
        RowSorter<? extends TableModel> controller = this.getRowSorter();
        if (controller != null && (sortKey = SortUtils.getFirstSortingKey(controller.getSortKeys())) != null) {
            int sorterColumn = sortKey.getColumn();
            List<TableColumn> columns = this.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != sorterColumn) continue;
                return column;
            }
        }
        return null;
    }

    public int getSortedColumnIndex() {
        RowSorter.SortKey sortKey;
        RowSorter<? extends TableModel> controller = this.getRowSorter();
        if (controller != null && (sortKey = SortUtils.getFirstSortingKey(controller.getSortKeys())) != null) {
            return this.convertColumnIndexToView(sortKey.getColumn());
        }
        return -1;
    }

    @Override
    public void columnAdded(TableColumnModelEvent e) {
        super.columnAdded(e);
        TableColumn column = this.getColumn(e.getToIndex());
        this.updateStringValueForColumn(column, column.getCellRenderer());
        if (this.ignoreAddColumn) {
            return;
        }
        this.updateSortableAfterColumnChanged(column, column instanceof TableColumnExt ? ((TableColumnExt)column).isSortable() : true);
        this.updateComparatorAfterColumnChanged(column, column instanceof TableColumnExt ? ((TableColumnExt)column).getComparator() : null);
    }

    public TableColumn getColumn(int viewColumnIndex) {
        return this.getColumnModel().getColumn(viewColumnIndex);
    }

    public List<TableColumn> getColumns() {
        return Collections.list(this.getColumnModel().getColumns());
    }

    public int getColumnMargin() {
        return this.getColumnModel().getColumnMargin();
    }

    public void setColumnMargin(int value) {
        this.getColumnModel().setColumnMargin(value);
    }

    public int getColumnCount(boolean includeHidden) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnCount(includeHidden);
        }
        return this.getColumnCount();
    }

    public List<TableColumn> getColumns(boolean includeHidden) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumns(includeHidden);
        }
        return this.getColumns();
    }

    public TableColumnExt getColumnExt(Object identifier) {
        if (this.getColumnModel() instanceof TableColumnModelExt) {
            return ((TableColumnModelExt)this.getColumnModel()).getColumnExt(identifier);
        }
        try {
            TableColumn column = this.getColumn(identifier);
            if (column instanceof TableColumnExt) {
                return (TableColumnExt)column;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public TableColumnExt getColumnExt(int viewColumnIndex) {
        TableColumn column = this.getColumn(viewColumnIndex);
        if (column instanceof TableColumnExt) {
            return (TableColumnExt)column;
        }
        return null;
    }

    public void setColumnSequence(Object[] identifiers) {
        List<TableColumn> columns = this.getColumns(true);
        HashMap<Object, TableColumn> map = new HashMap<Object, TableColumn>();
        for (TableColumn column : columns) {
            map.put(column.getIdentifier(), column);
            this.getColumnModel().removeColumn(column);
        }
        for (Object identifier : identifiers) {
            TableColumn column = (TableColumn)map.get(identifier);
            if (column == null) continue;
            this.getColumnModel().addColumn(column);
            columns.remove(column);
        }
        for (TableColumn column : columns) {
            this.getColumnModel().addColumn(column);
        }
    }

    @Override
    public void columnPropertyChange(PropertyChangeEvent event) {
        if ("editable".equals(event.getPropertyName())) {
            this.updateEditingAfterColumnChanged((TableColumn)event.getSource(), (Boolean)event.getNewValue());
        } else if ("sortable".equals(event.getPropertyName())) {
            this.updateSortableAfterColumnChanged((TableColumn)event.getSource(), (Boolean)event.getNewValue());
        } else if ("comparator".equals(event.getPropertyName())) {
            this.updateComparatorAfterColumnChanged((TableColumn)event.getSource(), (Comparator)event.getNewValue());
        } else if ("cellRenderer".equals(event.getPropertyName())) {
            this.updateStringValueForColumn((TableColumn)event.getSource(), (TableCellRenderer)event.getNewValue());
        } else if (event.getPropertyName().startsWith("highlighter")) {
            if (event.getSource() instanceof TableColumnExt && this.getRowCount() > 0) {
                TableColumnExt column = (TableColumnExt)event.getSource();
                Rectangle r = this.getCellRect(0, this.convertColumnIndexToView(column.getModelIndex()), true);
                r.height = this.getHeight();
                this.repaint(r);
            } else {
                this.repaint();
            }
        }
    }

    private void updateEditingAfterColumnChanged(TableColumn column, boolean editable) {
        if (!this.isEditing()) {
            return;
        }
        int viewIndex = this.convertColumnIndexToView(column.getModelIndex());
        if (viewIndex < 0 || viewIndex != this.getEditingColumn()) {
            return;
        }
        this.getCellEditor().cancelCellEditing();
    }

    private void updateSortableAfterColumnChanged(TableColumn column, boolean sortable) {
        if (this.getControlsSorterProperties()) {
            this.getSortController().setSortable(column.getModelIndex(), sortable);
        }
    }

    private void updateComparatorAfterColumnChanged(TableColumn column, Comparator<?> comparator) {
        if (this.getControlsSorterProperties()) {
            this.getSortController().setComparator(column.getModelIndex(), comparator);
        }
    }

    @Override
    public final void createDefaultColumnsFromModel() {
        if (this.getModel() == null) {
            return;
        }
        this.removeColumns();
        this.createAndAddColumns();
    }

    private void createAndAddColumns() {
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            TableColumnExt tableColumn = this.getColumnFactory().createAndConfigureTableColumn(this.getModel(), i);
            if (tableColumn == null) continue;
            this.getColumnModel().addColumn(tableColumn);
        }
    }

    private void removeColumns() {
        List<TableColumn> columns = this.getColumns(true);
        for (TableColumn column : columns) {
            this.getColumnModel().removeColumn(column);
        }
    }

    public ColumnFactory getColumnFactory() {
        if (this.columnFactory == null) {
            return ColumnFactory.getInstance();
        }
        return this.columnFactory;
    }

    public void setColumnFactory(ColumnFactory columnFactory) {
        ColumnFactory old = this.getColumnFactory();
        this.columnFactory = columnFactory;
        this.firePropertyChange("columnFactory", old, this.getColumnFactory());
    }

    public void packTable(int margin) {
        for (int c = 0; c < this.getColumnCount(); ++c) {
            this.packColumn(c, margin, -1);
        }
    }

    public void packColumn(int column, int margin) {
        this.packColumn(column, margin, -1);
    }

    public void packColumn(int column, int margin, int max) {
        this.getColumnFactory().packColumn(this, this.getColumnExt(column), margin, max);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        if (visibleRowCount < 0) {
            throw new IllegalArgumentException("visible row count must not be negative " + visibleRowCount);
        }
        if (this.getVisibleRowCount() == visibleRowCount) {
            return;
        }
        int old = this.getVisibleRowCount();
        this.visibleRowCount = visibleRowCount;
        this.resetCalculatedScrollableSize(false);
        this.firePropertyChange("visibleRowCount", old, this.getVisibleRowCount());
    }

    public int getVisibleColumnCount() {
        return this.visibleColumnCount;
    }

    public void setVisibleColumnCount(int visibleColumnCount) {
        if (this.getVisibleColumnCount() == visibleColumnCount) {
            return;
        }
        int old = this.getVisibleColumnCount();
        this.visibleColumnCount = visibleColumnCount;
        this.resetCalculatedScrollableSize(true);
        this.firePropertyChange("visibleColumnCount", old, this.getVisibleColumnCount());
    }

    private void resetCalculatedScrollableSize(boolean isColumn) {
        if (this.calculatedPrefScrollableViewportSize != null) {
            if (isColumn) {
                this.calculatedPrefScrollableViewportSize.width = -1;
            } else {
                this.calculatedPrefScrollableViewportSize.height = -1;
            }
        }
    }

    @Override
    public void setPreferredScrollableViewportSize(Dimension size) {
        super.setPreferredScrollableViewportSize(size);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension prefSize = super.getPreferredScrollableViewportSize();
        if (prefSize != null) {
            return new Dimension(prefSize);
        }
        if (this.calculatedPrefScrollableViewportSize == null) {
            this.calculatedPrefScrollableViewportSize = new Dimension();
        }
        if (this.calculatedPrefScrollableViewportSize.width <= 0) {
            this.calculatedPrefScrollableViewportSize.width = this.getColumnFactory().getPreferredScrollableViewportWidth(this);
        }
        if (this.calculatedPrefScrollableViewportSize.height <= 0) {
            this.calculatedPrefScrollableViewportSize.height = this.getVisibleRowCount() * this.getRowHeight();
        }
        return new Dimension(this.calculatedPrefScrollableViewportSize);
    }

    protected void initializeColumnWidths() {
        for (TableColumn column : this.getColumns(true)) {
            this.initializeColumnPreferredWidth(column);
        }
    }

    protected void initializeColumnPreferredWidth(TableColumn column) {
        if (column instanceof TableColumnExt) {
            this.getColumnFactory().configureColumnWidths(this, (TableColumnExt)column);
        }
    }

    public void scrollRowToVisible(int row) {
        Rectangle cellRect = this.getCellRect(row, 0, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.x = visibleRect.x;
        cellRect.width = visibleRect.width;
        this.scrollRectToVisible(cellRect);
    }

    public void scrollColumnToVisible(int column) {
        Rectangle cellRect = this.getCellRect(0, column, false);
        Rectangle visibleRect = this.getVisibleRect();
        cellRect.y = visibleRect.y;
        cellRect.height = visibleRect.height;
        this.scrollRectToVisible(cellRect);
    }

    public void scrollCellToVisible(int row, int column) {
        Rectangle cellRect = this.getCellRect(row, column, false);
        this.scrollRectToVisible(cellRect);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    protected void doFind() {
        SearchFactory.getInstance().showFindInput(this, this.getSearchable());
    }

    public Searchable getSearchable() {
        if (this.searchable == null) {
            this.searchable = new TableSearchable(this);
        }
        return this.searchable;
    }

    public void setSearchable(Searchable searchable) {
        this.searchable = searchable;
    }

    protected ComponentAdapter getComponentAdapter() {
        if (this.dataAdapter == null) {
            this.dataAdapter = new TableAdapter(this);
        }
        return this.dataAdapter;
    }

    protected ComponentAdapter getComponentAdapter(int row, int column) {
        ComponentAdapter adapter = this.getComponentAdapter();
        adapter.row = row;
        adapter.column = column;
        return adapter;
    }

    public void setHighlighters(Highlighter ... highlighters) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().setHighlighters(highlighters);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public Highlighter[] getHighlighters() {
        return this.getCompoundHighlighter().getHighlighters();
    }

    public void addHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().addHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    public void removeHighlighter(Highlighter highlighter) {
        Highlighter[] old = this.getHighlighters();
        this.getCompoundHighlighter().removeHighlighter(highlighter);
        this.firePropertyChange("highlighters", old, this.getHighlighters());
    }

    protected CompoundHighlighter getCompoundHighlighter() {
        if (this.compoundHighlighter == null) {
            this.compoundHighlighter = new CompoundHighlighter(new Highlighter[0]);
            this.compoundHighlighter.addChangeListener(this.getHighlighterChangeListener());
        }
        return this.compoundHighlighter;
    }

    protected ChangeListener getHighlighterChangeListener() {
        if (this.highlighterChangeListener == null) {
            this.highlighterChangeListener = this.createHighlighterChangeListener();
        }
        return this.highlighterChangeListener;
    }

    protected ChangeListener createHighlighterChangeListener() {
        return e -> this.repaint();
    }

    protected StringValueRegistry getStringValueRegistry() {
        if (this.stringValueRegistry == null) {
            this.stringValueRegistry = this.createDefaultStringValueRegistry();
        }
        return this.stringValueRegistry;
    }

    protected StringValueRegistry createDefaultStringValueRegistry() {
        return new StringValueRegistry();
    }

    private void updateStringValueRegistryColumnClasses() {
        this.getStringValueRegistry().setColumnClasses(null);
        for (int i = 0; i < this.getModel().getColumnCount(); ++i) {
            this.getStringValueRegistry().setColumnClass(this.getModel().getColumnClass(i), i);
        }
    }

    private void updateStringValueForColumn(TableColumn tableColumn, TableCellRenderer renderer) {
        this.getStringValueRegistry().setStringValue(renderer instanceof StringValue ? (StringValue)((Object)renderer) : null, tableColumn.getModelIndex());
    }

    private void initDefaultStringValues() {
        for (Object clazz : this.defaultRenderersByColumnClass.keySet()) {
            Object renderer = this.defaultRenderersByColumnClass.get(clazz);
            if (!(renderer instanceof StringValue)) continue;
            this.getStringValueRegistry().setStringValue((StringValue)renderer, (Class)clazz);
        }
    }

    private void initPerColumnStringValues() {
        this.getStringValueRegistry().clearColumnStringValues();
        for (TableColumn tableColumn : this.getColumns(true)) {
            this.updateStringValueForColumn(tableColumn, tableColumn.getCellRenderer());
        }
    }

    @Override
    public void setDefaultRenderer(Class<?> columnClass, TableCellRenderer renderer) {
        super.setDefaultRenderer(columnClass, renderer);
        this.getStringValueRegistry().setStringValue(renderer instanceof StringValue ? (StringValue)((Object)renderer) : null, columnClass);
    }

    public String getStringAt(int row, int column) {
        StringValue stringValue = this.getStringValueRegistry().getStringValue(this.convertRowIndexToModel(row), this.convertColumnIndexToModel(column));
        return stringValue.getString(this.getValueAt(row, column));
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableCellRenderer renderer = super.getCellRenderer(row, column);
        if (renderer == null) {
            renderer = this.getDefaultRenderer(Object.class);
        }
        return renderer;
    }

    @Override
    public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
        TableColumnExt columnExt;
        Component stamp = super.prepareRenderer(renderer, row, column);
        this.adjustComponentOrientation(stamp);
        this.resetDefaultTableCellRendererColors(stamp, row, column);
        ComponentAdapter adapter = this.getComponentAdapter(row, column);
        if (this.compoundHighlighter != null) {
            stamp = this.compoundHighlighter.highlight(stamp, adapter);
        }
        if ((columnExt = this.getColumnExt(column)) != null) {
            for (Highlighter highlighter : columnExt.getHighlighters()) {
                stamp = highlighter.highlight(stamp, adapter);
            }
        }
        return stamp;
    }

    public Component prepareRenderer(int row, int col) {
        return this.prepareRenderer(this.getCellRenderer(row, col), row, col);
    }

    protected void resetDefaultTableCellRendererColors(Component renderer, int row, int column) {
        if (!Boolean.TRUE.equals(this.getClientProperty(USE_DTCR_COLORMEMORY_HACK))) {
            return;
        }
        ComponentAdapter adapter = this.getComponentAdapter(row, column);
        if (this.resetDefaultTableCellRendererHighlighter == null) {
            this.resetDefaultTableCellRendererHighlighter = new ResetDTCRColorHighlighter();
        }
        this.resetDefaultTableCellRendererHighlighter.highlight(renderer, adapter);
    }

    @Override
    public Component prepareEditor(TableCellEditor editor, int row, int column) {
        Component comp = super.prepareEditor(editor, row, column);
        if (comp != null) {
            this.adjustComponentOrientation(comp);
        }
        return comp;
    }

    protected void adjustComponentOrientation(Component stamp) {
        if (stamp.getComponentOrientation().equals(this.getComponentOrientation())) {
            return;
        }
        stamp.applyComponentOrientation(this.getComponentOrientation());
    }

    @Override
    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults(8, 0.75f);
        this.setDefaultRenderer(Object.class, new DefaultTableRenderer());
        this.setDefaultRenderer(Number.class, new DefaultTableRenderer((StringValue)StringValues.NUMBER_TO_STRING, 4));
        this.setDefaultRenderer(Date.class, new DefaultTableRenderer(StringValues.DATE_TO_STRING));
        DefaultTableRenderer renderer = new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.ICON), 0);
        this.setDefaultRenderer(Icon.class, renderer);
        this.setDefaultRenderer(ImageIcon.class, renderer);
        this.setDefaultRenderer(Boolean.class, new DefaultTableRenderer(new CheckBoxProvider()));
        try {
            this.setDefaultRenderer(URI.class, new DefaultTableRenderer(new HyperlinkProvider(new HyperlinkAction())));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    protected void createDefaultEditors() {
        this.defaultEditorsByColumnClass = new UIDefaults(3, 0.75f);
        this.defaultEditorsByColumnClass.put(Object.class, new GenericEditor());
        this.defaultEditorsByColumnClass.put(Number.class, new NumberEditorExt(true));
        this.defaultEditorsByColumnClass.put(Boolean.class, new BooleanEditor());
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        boolean old = this.isEditable();
        this.editable = editable;
        this.firePropertyChange("editable", old, this.isEditable());
    }

    public boolean isTerminateEditOnFocusLost() {
        return Boolean.TRUE.equals(this.getClientProperty("terminateEditOnFocusLost"));
    }

    public void setTerminateEditOnFocusLost(boolean terminate) {
        this.putClientProperty("terminateEditOnFocusLost", terminate);
    }

    public boolean isAutoStartEditOnKeyStroke() {
        return !Boolean.FALSE.equals(this.getClientProperty("JTable.autoStartsEdit"));
    }

    public void setAutoStartEditOnKeyStroke(boolean autoStart) {
        boolean old = this.isAutoStartEditOnKeyStroke();
        this.putClientProperty("JTable.autoStartsEdit", autoStart);
        this.firePropertyChange("autoStartEditOnKeyStroke", old, this.isAutoStartEditOnKeyStroke());
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean started = super.editCellAt(row, column, e);
        if (started) {
            this.hackEditorRemover();
        }
        return started;
    }

    @Override
    public void removeEditor() {
        boolean isFocusOwnerInTheTable = this.isFocusOwnerDescending();
        super.removeEditor();
        if (isFocusOwnerInTheTable) {
            this.requestFocusInWindow();
        }
    }

    private boolean isFocusOwnerDescending() {
        if (!this.isEditing()) {
            return false;
        }
        Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focusOwner == null) {
            return false;
        }
        if (SwingXUtilities.isDescendingFrom(focusOwner, this)) {
            return true;
        }
        Component permanent = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        return SwingXUtilities.isDescendingFrom(permanent, this);
    }

    private void hackEditorRemover() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        PropertyChangeListener[] listeners = manager.getPropertyChangeListeners("permanentFocusOwner");
        for (int i = listeners.length - 1; i >= 0; --i) {
            if (!listeners[i].getClass().getName().startsWith("javax.swing.JTable")) continue;
            manager.removePropertyChangeListener("permanentFocusOwner", listeners[i]);
            break;
        }
        if (this.editorRemover == null) {
            this.editorRemover = new CellEditorRemover();
        }
    }

    @Override
    public void removeNotify() {
        if (this.editorRemover != null) {
            this.editorRemover.uninstall();
            this.editorRemover = null;
        }
        super.removeNotify();
    }

    @Override
    public boolean isFocusCycleRoot() {
        if (this.isEditingFocusCycleRoot()) {
            return true;
        }
        return super.isFocusCycleRoot();
    }

    @Override
    public void transferFocus() {
        if (this.isEditingFocusCycleRoot() && !this.getCellEditor().stopCellEditing()) {
            return;
        }
        super.transferFocus();
    }

    @Override
    public void transferFocusBackward() {
        if (this.isEditingFocusCycleRoot() && !this.getCellEditor().stopCellEditing()) {
            return;
        }
        super.transferFocusBackward();
    }

    private boolean isEditingFocusCycleRoot() {
        return this.isEditing() && this.isTerminateEditOnFocusLost();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.updateColumnControlUI();
        for (Object o : this.defaultEditorsByColumnClass.values()) {
            this.updateEditorUI(o);
        }
        for (Object o : this.defaultRenderersByColumnClass.values()) {
            this.updateRendererUI(o);
        }
        for (TableColumn column : this.getColumns(true)) {
            this.updateColumnUI(column);
        }
        this.updateRowHeightUI(true);
        this.updateHighlighterUI();
    }

    protected void updateColumnControlUI() {
        if (this.columnControlButton != null && this.columnControlButton.getParent() == null) {
            SwingUtilities.updateComponentTreeUI(this.columnControlButton);
        }
    }

    private void updateEditorUI(Object maybeEditor) {
        if (!(maybeEditor instanceof TableCellEditor)) {
            return;
        }
        if (maybeEditor instanceof JComponent || maybeEditor instanceof DefaultCellEditor) {
            return;
        }
        try {
            Component comp = ((TableCellEditor)maybeEditor).getTableCellEditorComponent(this, null, false, -1, -1);
            if (comp != null) {
                SwingUtilities.updateComponentTreeUI(comp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void updateRendererUI(Object maybeRenderer) {
        if (!(maybeRenderer instanceof TableCellRenderer)) {
            return;
        }
        if (maybeRenderer instanceof JComponent) {
            return;
        }
        Component comp = null;
        if (maybeRenderer instanceof AbstractRenderer) {
            comp = (Component)((AbstractRenderer)maybeRenderer).getComponentProvider().getRendererComponent(null);
        } else {
            try {
                comp = ((TableCellRenderer)maybeRenderer).getTableCellRendererComponent(this, null, false, false, -1, -1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (comp != null) {
            SwingUtilities.updateComponentTreeUI(comp);
        }
    }

    protected void updateColumnUI(TableColumn column) {
        if (column instanceof UIDependent) {
            ((UIDependent)((Object)column)).updateUI();
        } else {
            this.updateEditorUI(column.getCellEditor());
            this.updateRendererUI(column.getCellRenderer());
            this.updateRendererUI(column.getHeaderRenderer());
        }
    }

    protected void updateHighlighterUI() {
        if (this.compoundHighlighter == null) {
            return;
        }
        this.compoundHighlighter.updateUI();
    }

    protected void updateRowHeightUI(boolean respectRowSetFlag) {
        if (respectRowSetFlag && this.isXTableRowHeightSet) {
            return;
        }
        int uiHeight = UIManager.getInt("JXTable.rowHeight");
        if (uiHeight > 0) {
            this.setRowHeight(uiHeight);
        } else {
            int fontBasedHeight = this.getFontMetrics(this.getFont()).getHeight() + 2;
            int magicMinimum = 18;
            this.setRowHeight(Math.max(fontBasedHeight, magicMinimum));
        }
        this.isXTableRowHeightSet = false;
    }

    public void setShowGrid(boolean showHorizontalLines, boolean showVerticalLines) {
        int defaultRowMargin = showHorizontalLines ? 1 : 0;
        this.setRowMargin(defaultRowMargin);
        this.setShowHorizontalLines(showHorizontalLines);
        int defaultColumnMargin = showVerticalLines ? 1 : 0;
        this.setColumnMargin(defaultColumnMargin);
        this.setShowVerticalLines(showVerticalLines);
    }

    @Override
    public void setShowGrid(boolean showGrid) {
        super.setShowGrid(showGrid);
    }

    @Override
    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (rowHeight > 0) {
            this.isXTableRowHeightSet = true;
        }
    }

    protected void adminSetRowHeight(int rowHeight) {
        boolean heightSet = this.isXTableRowHeightSet;
        this.setRowHeight(rowHeight);
        this.isXTableRowHeightSet = heightSet;
    }

    @Override
    public int rowAtPoint(Point point) {
        if (point.y < 0) {
            return -1;
        }
        return super.rowAtPoint(point);
    }

    @Override
    protected JTableHeader createDefaultTableHeader() {
        return new JXTableHeader(this.columnModel);
    }

    @Override
    protected TableColumnModel createDefaultColumnModel() {
        return new DefaultTableColumnModelExt();
    }

    @Override
    public void setSelectionBackground(Color selectionBackground) {
        Color old = this.getSelectionBackground();
        this.selectionBackground = selectionBackground;
        this.firePropertyChange("selectionBackground", old, this.getSelectionBackground());
        this.repaint();
    }

    @Override
    public void setSelectionForeground(Color selectionForeground) {
        Color old = this.getSelectionForeground();
        this.selectionForeground = selectionForeground;
        this.firePropertyChange("selectionForeground", old, this.getSelectionForeground());
        this.repaint();
    }

    @Override
    public void setGridColor(Color gridColor) {
        Color old = this.getGridColor();
        this.gridColor = gridColor;
        this.firePropertyChange("gridColor", old, this.getGridColor());
        this.repaint();
    }

    static {
        LookAndFeelAddons.getAddon();
        LookAndFeelAddons.contribute(new TableAddon());
    }

    private class Actions
    extends UIAction {
        Actions(String name) {
            super(name);
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            if ("print".equals(this.getName())) {
                try {
                    JXTable.this.print();
                }
                catch (PrinterException ex) {
                    LOG.log(Level.WARNING, "", ex);
                }
            } else if ("find".equals(this.getName())) {
                JXTable.this.doFind();
            }
        }
    }

    protected static class TableAdapter
    extends ComponentAdapter {
        private final JXTable table;

        public TableAdapter(JXTable component) {
            super(component);
            this.table = component;
        }

        public JXTable getTable() {
            return this.table;
        }

        @Override
        public String getColumnName(int columnIndex) {
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            return column == null ? "" : column.getHeaderValue().toString();
        }

        protected TableColumn getColumnByModelIndex(int modelColumn) {
            if (modelColumn < 0 || modelColumn >= this.getColumnCount()) {
                throw new IllegalArgumentException("invalid column index, must be positive and less than " + this.getColumnCount() + " was: " + modelColumn);
            }
            List<TableColumn> columns = this.table.getColumns(true);
            for (TableColumn column : columns) {
                if (column.getModelIndex() != modelColumn) continue;
                return column;
            }
            return null;
        }

        @Override
        public Object getColumnIdentifierAt(int columnIndex) {
            if (columnIndex < 0 || columnIndex >= this.getColumnCount()) {
                throw new ArrayIndexOutOfBoundsException("invalid column index: " + columnIndex);
            }
            TableColumn column = this.getColumnByModelIndex(columnIndex);
            return column != null ? column.getIdentifier() : null;
        }

        @Override
        public int getColumnIndex(Object identifier) {
            TableColumnExt column = this.table.getColumnExt(identifier);
            return column != null ? column.getModelIndex() : -1;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            return this.table.getModel().getColumnClass(column);
        }

        @Override
        public int getColumnCount() {
            return this.table.getModel().getColumnCount();
        }

        @Override
        public int getRowCount() {
            return this.table.getModel().getRowCount();
        }

        @Override
        public Object getValueAt(int row, int column) {
            return this.table.getModel().getValueAt(row, column);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return this.table.getModel().isCellEditable(row, column);
        }

        @Override
        public boolean isTestable(int column) {
            return this.getColumnByModelIndex(column) != null;
        }

        @Override
        public String getStringAt(int row, int column) {
            StringValue sv = this.table.getStringValueRegistry().getStringValue(row, column);
            return sv.getString(this.getValueAt(row, column));
        }

        @Override
        public Rectangle getCellBounds() {
            return this.table.getCellRect(this.row, this.column, false);
        }

        @Override
        public boolean isEditable() {
            return this.table.isCellEditable(this.row, this.column);
        }

        @Override
        public boolean isSelected() {
            return this.table.isCellSelected(this.row, this.column);
        }

        @Override
        public boolean hasFocus() {
            boolean rowIsLead = this.table.getSelectionModel().getLeadSelectionIndex() == this.row;
            boolean colIsLead = this.table.getColumnModel().getSelectionModel().getLeadSelectionIndex() == this.column;
            return this.table.isFocusOwner() && rowIsLead && colIsLead;
        }

        @Override
        public int convertColumnIndexToView(int columnIndex) {
            return this.table.convertColumnIndexToView(columnIndex);
        }

        @Override
        public int convertColumnIndexToModel(int columnIndex) {
            return this.table.convertColumnIndexToModel(columnIndex);
        }

        @Override
        public int convertRowIndexToView(int rowModelIndex) {
            return this.table.convertRowIndexToView(rowModelIndex);
        }

        @Override
        public int convertRowIndexToModel(int rowViewIndex) {
            return this.table.convertRowIndexToModel(rowViewIndex);
        }
    }

    public static class GenericEditor
    extends DefaultCellEditor {
        private Constructor<?> constructor;
        private Object value;

        public GenericEditor() {
            this(new JTextField());
        }

        public GenericEditor(JTextField textField) {
            super(textField);
            this.getComponent().setName("Table.editor");
        }

        @Override
        public boolean stopCellEditing() {
            String s = (String)super.getCellEditorValue();
            if (this.constructor.getDeclaringClass() == String.class) {
                this.value = s;
            } else {
                try {
                    this.value = this.constructor.newInstance(s);
                }
                catch (Exception e) {
                    ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.red));
                    return false;
                }
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.value = null;
            ((JComponent)this.getComponent()).setBorder(new LineBorder(Color.black));
            try {
                Class<Object> type = table.getColumnClass(column);
                if (type == Object.class) {
                    type = String.class;
                }
                this.constructor = type.getConstructor(String.class);
            }
            catch (Exception e) {
                return null;
            }
            return super.getTableCellEditorComponent(table, value, isSelected, row, column);
        }

        @Override
        public Object getCellEditorValue() {
            return this.value;
        }
    }

    public static class BooleanEditor
    extends DefaultCellEditor {
        public BooleanEditor() {
            super(new JCheckBox());
            JCheckBox checkBox = (JCheckBox)this.getComponent();
            checkBox.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            return super.getTableCellEditorComponent(table, value, isSelected || this.shouldSelectCell(null), row, column);
        }
    }

    private class CellEditorRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager focusManager;

        CellEditorRemover() {
            this.install();
        }

        private void install() {
            this.focusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            this.focusManager.addPropertyChangeListener("permanentFocusOwner", this);
            this.focusManager.addPropertyChangeListener("managingFocus", this);
        }

        public void uninstall() {
            this.focusManager.removePropertyChangeListener("permanentFocusOwner", this);
            this.focusManager.removePropertyChangeListener("managingFocus", this);
            this.focusManager = null;
        }

        @Override
        public void propertyChange(PropertyChangeEvent ev) {
            if (ev == null) {
                return;
            }
            if ("permanentFocusOwner".equals(ev.getPropertyName())) {
                this.permanentFocusOwnerChange();
            } else if ("managingFocus".equals(ev.getPropertyName())) {
                // empty if block
            }
        }

        private void permanentFocusOwnerChange() {
            if (!JXTable.this.isEditing() || !JXTable.this.isTerminateEditOnFocusLost()) {
                return;
            }
            Component c = this.focusManager.getPermanentFocusOwner();
            while (c != null) {
                if (c instanceof JPopupMenu) {
                    c = ((JPopupMenu)c).getInvoker();
                    continue;
                }
                if (c == JXTable.this) {
                    return;
                }
                if (!(c instanceof JPopupMenu) && c instanceof Window) {
                    if (c != SwingUtilities.getRoot(JXTable.this) || JXTable.this.getCellEditor().stopCellEditing()) break;
                    JXTable.this.getCellEditor().cancelCellEditing();
                    break;
                }
                c = c.getParent();
            }
        }
    }

    public static class NumberEditor
    extends GenericEditor {
        public NumberEditor() {
            ((JTextField)this.getComponent()).setHorizontalAlignment(4);
        }
    }
}

