/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXPanel;

final class JXImagePanel
extends JXPanel {
    private Image img = null;

    JXImagePanel() {
    }

    void setImage(Image image) {
        if (image != this.img) {
            Image oldImage = this.img;
            this.img = image;
            this.firePropertyChange("image", oldImage, this.img);
            this.invalidate();
            this.repaint();
        }
    }

    Image getImage() {
        return this.img;
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet() && this.img != null) {
            int width = this.img.getWidth(null);
            int height = this.img.getHeight(null);
            if (width == -1 || height == -1) {
                return super.getPreferredSize();
            }
            Insets insets = this.getInsets();
            return new Dimension(width += insets.left + insets.right, height += insets.top + insets.bottom);
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        if (this.img == null) {
            return;
        }
        int imgWidth = this.img.getWidth(null);
        int imgHeight = this.img.getHeight(null);
        if (imgWidth == -1 || imgHeight == -1) {
            return;
        }
        Insets insets = this.getInsets();
        int pw = this.getWidth() - insets.left - insets.right;
        int ph = this.getHeight() - insets.top - insets.bottom;
        Rectangle clipRect = g2.getClipBounds();
        int imageX = (pw - imgWidth) / 2 + insets.left;
        int imageY = (ph - imgHeight) / 2 + insets.top;
        Rectangle r = SwingUtilities.computeIntersection(imageX, imageY, imgWidth, imgHeight, clipRect);
        if (r.x == 0 && r.y == 0 && (r.width == 0 || r.height == 0)) {
            return;
        }
        int txClipX = clipRect.x - imageX;
        int txClipY = clipRect.y - imageY;
        int txClipW = clipRect.width;
        int txClipH = clipRect.height;
        g2.drawImage(this.img, clipRect.x, clipRect.y, clipRect.x + clipRect.width, clipRect.y + clipRect.height, txClipX, txClipY, txClipX + txClipW, txClipY + txClipH, null);
    }
}

