/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jdesktop.swingx.color.EyeDropperColorChooserPanel;
import org.jdesktop.swingx.plaf.UIManagerExt;
import org.jdesktop.swingx.util.GraphicsUtilities;
import org.jdesktop.swingx.util.OS;
import org.jdesktop.swingx.util.PaintUtils;

public class JXColorSelectionButton
extends JButton {
    private static final Logger LOG = Logger.getLogger(JXColorSelectionButton.class.getName());
    private BufferedImage colorwell;
    private JDialog dialog = null;
    private JColorChooser chooser = null;
    private Color initialColor = null;

    public JXColorSelectionButton() {
        this(Color.red);
    }

    public JXColorSelectionButton(Color col) {
        this.setBackground(col);
        this.addActionListener(new ActionHandler());
        this.setContentAreaFilled(false);
        this.setOpaque(false);
        try {
            this.colorwell = ImageIO.read(JXColorSelectionButton.class.getResource("color/colorwell.png"));
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Cannot load icon", ex);
        }
        this.addPropertyChangeListener("background", propertyChangeEvent -> this.getChooser().setColor(this.getBackground()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        Color fillColor;
        Color color = fillColor = this.isEnabled() ? PaintUtils.removeAlpha(this.getBackground()) : UIManagerExt.getSafeColor("Button.disabledForeground", Color.LIGHT_GRAY);
        if (OS.isMacOSX() && this.colorwell != null) {
            Insets ins = new Insets(5, 5, 5, 5);
            GraphicsUtilities.tileStretchPaint(g, this, this.colorwell, ins);
            g.setColor(fillColor);
            g.fillRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right, this.getHeight() - ins.top - ins.bottom);
            g.setColor(PaintUtils.setBrightness(fillColor, 0.85f));
            g.drawRect(ins.left, ins.top, this.getWidth() - ins.left - ins.right - 1, this.getHeight() - ins.top - ins.bottom - 1);
            g.drawRect(ins.left + 1, ins.top + 1, this.getWidth() - ins.left - ins.right - 3, this.getHeight() - ins.top - ins.bottom - 3);
        } else {
            Graphics2D g2 = (Graphics2D)g.create();
            try {
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.setColor(Color.LIGHT_GRAY);
                int diam = Math.min(this.getWidth(), this.getHeight());
                int inset = 3;
                g2.fill(new Ellipse2D.Float(3.0f, 3.0f, diam - 6, diam - 6));
                g2.setColor(fillColor);
                boolean border = true;
                g2.fill(new Ellipse2D.Float(4.0f, 4.0f, diam - 6 - 2, diam - 6 - 2));
            }
            finally {
                g2.dispose();
            }
        }
    }

    private void showDialog() {
        if (this.dialog == null) {
            this.dialog = JColorChooser.createDialog(this, "Choose a color", true, this.getChooser(), actionEvent -> {
                Color color = this.getChooser().getColor();
                if (color != null) {
                    this.setBackground(color);
                }
            }, actionEvent -> this.setBackground(this.initialColor));
            this.dialog.getContentPane().add(this.getChooser());
            this.getChooser().getSelectionModel().addChangeListener(new ColorChangeListener(this));
        }
        this.initialColor = this.getBackground();
        this.dialog.setVisible(true);
    }

    public JColorChooser getChooser() {
        if (this.chooser == null) {
            this.chooser = new JColorChooser();
            this.chooser.addChooserPanel(new EyeDropperColorChooserPanel());
        }
        return this.chooser;
    }

    public void setChooser(JColorChooser chooser) {
        JColorChooser oldChooser = this.getChooser();
        this.chooser = chooser;
        this.firePropertyChange("chooser", oldChooser, chooser);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet() || this.colorwell == null) {
            return super.getPreferredSize();
        }
        return new Dimension(this.colorwell.getWidth(), this.colorwell.getHeight());
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JXColorSelectionButton.this.showDialog();
        }
    }

    private static class ColorChangeListener
    implements ChangeListener {
        private final JXColorSelectionButton button;

        ColorChangeListener(JXColorSelectionButton button) {
            this.button = button;
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.button.setBackground(this.button.getChooser().getColor());
        }
    }
}

