/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers.vineflower;

import com.heliosdecompiler.transformerapi.TransformationException;
import com.heliosdecompiler.transformerapi.common.Loader;
import com.heliosdecompiler.transformerapi.decompilers.Decompiler;
import com.heliosdecompiler.transformerapi.decompilers.vineflower.VineflowerBytecodeProvider;
import com.heliosdecompiler.transformerapi.decompilers.vineflower.VineflowerResultSaver;
import com.heliosdecompiler.transformerapi.decompilers.vineflower.VineflowerSettings;
import java.io.IOException;
import jd.core.DecompilationResult;
import org.vineflower.java.decompiler.main.DecompilerContext;
import org.vineflower.java.decompiler.main.Fernflower;
import org.vineflower.java.decompiler.main.decompiler.PrintStreamLogger;
import org.vineflower.java.decompiler.main.extern.IBytecodeProvider;
import org.vineflower.java.decompiler.main.extern.IContextSource;
import org.vineflower.java.decompiler.main.extern.IFernflowerLogger;
import org.vineflower.java.decompiler.main.extern.IResultSaver;
import org.vineflower.java.decompiler.struct.StructContext;

public class VineflowerDecompiler
implements Decompiler<VineflowerSettings> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecompilationResult decompile(Loader loader, String internalName, VineflowerSettings settings) throws TransformationException, IOException {
        Decompiler.ClassStruct classStruct = this.readClassAndInnerClasses(loader, internalName);
        if (!classStruct.importantData().isEmpty()) {
            VineflowerBytecodeProvider provider = new VineflowerBytecodeProvider(classStruct.importantData());
            VineflowerResultSaver saver = new VineflowerResultSaver();
            Fernflower baseDecompiler = new Fernflower((IBytecodeProvider)provider, (IResultSaver)saver, settings.getSettings(), (IFernflowerLogger)new PrintStreamLogger(System.out));
            try {
                StructContext context = DecompilerContext.getStructContext();
                context.addSpace((IContextSource)classStruct, true);
                baseDecompiler.decompileContext();
            }
            catch (Exception t) {
                DecompilerContext.getLogger().writeMessage("Error while decompiling", (Throwable)t);
            }
            finally {
                baseDecompiler.clearContext();
            }
            DecompilationResult decompilationResult = new DecompilationResult();
            String key = classStruct.fullClassName();
            decompilationResult.setDecompiledOutput(saver.getResults().get(key));
            return decompilationResult;
        }
        return null;
    }

    @Override
    public VineflowerSettings defaultSettings() {
        return new VineflowerSettings();
    }
}

