/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers.procyon;

import com.heliosdecompiler.transformerapi.common.Loader;
import com.heliosdecompiler.transformerapi.decompilers.Decompiler;
import com.heliosdecompiler.transformerapi.decompilers.procyon.ProcyonFastTypeLoader;
import com.strobel.Procyon;
import com.strobel.assembler.metadata.FieldDefinition;
import com.strobel.assembler.metadata.FieldReference;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.MethodDefinition;
import com.strobel.assembler.metadata.MethodReference;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.decompiler.CommandLineOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.ITextOutput;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.BytecodeOutputOptions;
import com.strobel.decompiler.languages.Languages;
import java.io.IOException;
import java.io.StringWriter;
import java.util.HashMap;
import jd.core.DecompilationResult;
import jd.core.links.DeclarationData;
import jd.core.links.HyperlinkData;
import jd.core.links.HyperlinkReferenceData;
import jd.core.links.ReferenceData;
import jd.core.links.StringData;

public class ProcyonDecompiler
implements Decompiler<CommandLineOptions> {
    @Override
    public CommandLineOptions defaultSettings() {
        CommandLineOptions options = new CommandLineOptions();
        options.setCollapseImports(false);
        options.setFlattenSwitchBlocks(true);
        options.setRetainRedundantCasts(true);
        options.setSuppressBanner(false);
        return options;
    }

    private static BytecodeOutputOptions createBytecodeFormattingOptions(CommandLineOptions options) {
        if (options.isVerbose()) {
            return BytecodeOutputOptions.createVerbose();
        }
        BytecodeOutputOptions bytecodeOptions = BytecodeOutputOptions.createDefault();
        bytecodeOptions.showTypeAttributes = options.getShowTypeAttributes();
        bytecodeOptions.showConstantPool = options.getShowConstantPool();
        bytecodeOptions.showLineNumbers = options.getIncludeLineNumbers();
        bytecodeOptions.showLocalVariableTables = options.getShowLocalVariableDetails();
        bytecodeOptions.showMethodsStack = options.getShowLocalVariableDetails();
        return bytecodeOptions;
    }

    @Override
    public DecompilationResult decompile(Loader loader, final String internalName, CommandLineOptions options) throws IOException {
        HashMap<String, byte[]> importantClasses = new HashMap<String, byte[]>();
        String key = this.readClassAndInnerClasses(loader, internalName).fullClassName();
        importantClasses.put(key, loader.load(internalName));
        DecompilerSettings settings = new DecompilerSettings();
        settings.setFlattenSwitchBlocks(options.getFlattenSwitchBlocks());
        settings.setForceExplicitImports(!options.getCollapseImports());
        settings.setForceExplicitTypeArguments(options.getForceExplicitTypeArguments());
        settings.setRetainRedundantCasts(options.getRetainRedundantCasts());
        settings.setShowSyntheticMembers(options.getShowSyntheticMembers());
        settings.setExcludeNestedTypes(options.getExcludeNestedTypes());
        settings.setOutputDirectory(options.getOutputDirectory());
        settings.setIncludeLineNumbersInBytecode(options.getIncludeLineNumbers());
        settings.setRetainPointlessSwitches(options.getRetainPointlessSwitches());
        settings.setUnicodeOutputEnabled(options.isUnicodeOutputEnabled());
        settings.setMergeVariables(options.getMergeVariables());
        settings.setShowDebugLineNumbers(options.getShowDebugLineNumbers());
        settings.setSimplifyMemberReferences(options.getSimplifyMemberReferences());
        settings.setForceFullyQualifiedReferences(options.getForceFullyQualifiedReferences());
        settings.setDisableForEachTransforms(options.getDisableForEachTransforms());
        settings.setForcedCompilerTarget(options.getCompilerTargetOverride());
        settings.setTextBlockLineMinimum(options.getTextBlockLineMinimum());
        settings.setTypeLoader((ITypeLoader)new ProcyonFastTypeLoader(importantClasses, loader));
        if (!options.getSuppressBanner()) {
            settings.setOutputFileHeaderText("\nDecompiled by Procyon v" + Procyon.version() + "\n");
        }
        if (options.isRawBytecode()) {
            settings.setLanguage(Languages.bytecode());
            settings.setBytecodeOutputOptions(ProcyonDecompiler.createBytecodeFormattingOptions(options));
        } else if (options.isBytecodeAst()) {
            settings.setLanguage(options.isUnoptimized() ? Languages.bytecodeAstUnoptimized() : Languages.bytecodeAst());
        }
        final StringWriter stringwriter = new StringWriter();
        final DecompilationResult result = new DecompilationResult();
        final HashMap referencesCache = new HashMap();
        PlainTextOutput plainTextOutput = new PlainTextOutput(stringwriter){

            private void addDeclaration(String text, int from, String descriptor, String internalTypeName, String name) {
                String key = internalTypeName + "-" + name + "-" + descriptor;
                result.addDeclaration(key, new DeclarationData(from, text.length(), internalTypeName, name, descriptor));
            }

            public void writeDefinition(String text, Object definition, boolean isLocal) {
                super.writeDefinition(text, definition, isLocal);
                try {
                    if (text != null && definition != null) {
                        int from = stringwriter.getBuffer().length() - text.length();
                        if (definition instanceof TypeDefinition) {
                            TypeDefinition type = (TypeDefinition)definition;
                            String internalTypeName = type.getInternalName();
                            DeclarationData data = new DeclarationData(from, text.length(), internalTypeName, null, null);
                            result.addDeclaration(internalTypeName, data);
                            result.addTypeDeclaration(from, data);
                        } else if (definition instanceof MethodDefinition) {
                            MethodDefinition method = (MethodDefinition)definition;
                            String descriptor = method.getErasedSignature();
                            TypeDefinition type = method.getDeclaringType();
                            String internalTypeName = type.getInternalName();
                            String name = method.getName();
                            this.addDeclaration(text, from, descriptor, internalTypeName, name);
                        } else if (definition instanceof FieldDefinition) {
                            FieldDefinition field = (FieldDefinition)definition;
                            String descriptor = field.getErasedSignature();
                            TypeDefinition type = field.getDeclaringType();
                            String internalTypeName = type.getInternalName();
                            String name = field.getName();
                            this.addDeclaration(text, from, descriptor, internalTypeName, name);
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }

            public void writeReference(String text, Object reference, boolean isLocal) {
                super.writeReference(text, reference, isLocal);
                try {
                    if (text != null && reference != null) {
                        int from = stringwriter.getBuffer().length() - text.length();
                        if (reference instanceof TypeReference) {
                            TypeReference type = (TypeReference)reference;
                            String internalTypeName = type.getInternalName();
                            ReferenceData data = this.newReferenceData(internalTypeName, null, null, internalName);
                            result.addHyperLink(from, (HyperlinkData)new HyperlinkReferenceData(from, text.length(), data));
                        } else if (reference instanceof MethodReference) {
                            MethodReference method = (MethodReference)reference;
                            String descriptor = method.getErasedSignature();
                            TypeReference type = method.getDeclaringType();
                            String internalTypeName = type.getInternalName();
                            String name = method.getName();
                            ReferenceData data = this.newReferenceData(internalTypeName, name, descriptor, internalName);
                            result.addHyperLink(from, (HyperlinkData)new HyperlinkReferenceData(from, text.length(), data));
                        } else if (reference instanceof FieldReference) {
                            FieldReference field = (FieldReference)reference;
                            String descriptor = field.getErasedSignature();
                            TypeReference type = field.getDeclaringType();
                            String internalTypeName = type.getInternalName();
                            String name = field.getName();
                            ReferenceData data = this.newReferenceData(internalTypeName, name, descriptor, internalName);
                            result.addHyperLink(from, (HyperlinkData)new HyperlinkReferenceData(from, text.length(), data));
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
            }

            public void writeTextLiteral(Object value) {
                super.writeTextLiteral(value);
                String text = value.toString();
                int from = stringwriter.getBuffer().length() - text.length();
                result.addString(new StringData(from, text, internalName));
            }

            public ReferenceData newReferenceData(String internalName2, String name, String descriptor, String scopeInternalName) {
                String key = internalName2 + "-" + name + "-" + descriptor + "-" + scopeInternalName;
                return referencesCache.computeIfAbsent(key, k -> {
                    ReferenceData reference = new ReferenceData(internalName2, name, descriptor, scopeInternalName);
                    result.addReference(reference);
                    return reference;
                });
            }
        };
        com.strobel.decompiler.Decompiler.decompile((String)internalName, (ITextOutput)plainTextOutput, (DecompilerSettings)settings);
        result.setDecompiledOutput(stringwriter.toString());
        return result;
    }
}

