/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers.jadx;

import com.heliosdecompiler.transformerapi.TransformationException;
import com.heliosdecompiler.transformerapi.common.Loader;
import com.heliosdecompiler.transformerapi.decompilers.Decompiler;
import jadx.api.CommentsLevel;
import jadx.api.JadxArgs;
import jadx.api.JadxDecompiler;
import jadx.api.JavaClass;
import jadx.api.plugins.input.ICodeLoader;
import jadx.plugins.input.java.JavaClassReader;
import jadx.plugins.input.java.JavaLoadResult;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import jd.core.DecompilationResult;

public class JADXDecompiler
implements Decompiler<JadxArgs> {
    @Override
    public DecompilationResult decompile(Loader loader, String internalName, JadxArgs args) throws TransformationException, IOException {
        Map<String, byte[]> importantData = this.readClassAndInnerClasses(loader, internalName).importantData();
        if (!importantData.isEmpty()) {
            int i = 0;
            ArrayList<JavaClassReader> readers = new ArrayList<JavaClassReader>();
            for (Map.Entry<String, byte[]> ent : importantData.entrySet()) {
                readers.add(new JavaClassReader(i++, ent.getKey(), ent.getValue()));
            }
            try (JadxDecompiler jadx = new JadxDecompiler(args);
                 JavaLoadResult javaLoadResult = new JavaLoadResult(readers, null);){
                jadx.addCustomCodeLoader((ICodeLoader)javaLoadResult);
                jadx.load();
                Iterator iterator = jadx.getClasses().iterator();
                while (true) {
                    if (iterator.hasNext()) {
                        JavaClass cls = (JavaClass)iterator.next();
                        if (!cls.getClassNode().getClsData().getInputFileName().equals(internalName)) continue;
                        DecompilationResult decompilationResult = new DecompilationResult();
                        decompilationResult.setDecompiledOutput(cls.getCode());
                        DecompilationResult decompilationResult2 = decompilationResult;
                        return decompilationResult2;
                        continue;
                    }
                    break;
                }
            }
        }
        return null;
    }

    @Override
    public JadxArgs defaultSettings() {
        JadxArgs jadxArgs = new JadxArgs();
        jadxArgs.setCommentsLevel(CommentsLevel.WARN);
        return jadxArgs;
    }
}

