/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers.fernflower;

import com.heliosdecompiler.transformerapi.TransformationException;
import com.heliosdecompiler.transformerapi.common.Loader;
import com.heliosdecompiler.transformerapi.decompilers.Decompiler;
import com.heliosdecompiler.transformerapi.decompilers.fernflower.FernflowerBytecodeProvider;
import com.heliosdecompiler.transformerapi.decompilers.fernflower.FernflowerResultSaver;
import com.heliosdecompiler.transformerapi.decompilers.fernflower.FernflowerSettings;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import jd.core.DecompilationResult;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.Fernflower;
import org.jetbrains.java.decompiler.main.decompiler.PrintStreamLogger;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;
import org.jetbrains.java.decompiler.main.extern.IFernflowerLogger;
import org.jetbrains.java.decompiler.main.extern.IResultSaver;
import org.jetbrains.java.decompiler.struct.StructContext;

public class FernflowerDecompiler
implements Decompiler<FernflowerSettings> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecompilationResult decompile(Loader loader, String internalName, FernflowerSettings settings) throws TransformationException, IOException {
        Decompiler.ClassStruct classStruct = this.readClassAndInnerClasses(loader, internalName);
        if (!classStruct.importantData().isEmpty()) {
            FernflowerBytecodeProvider provider = new FernflowerBytecodeProvider(classStruct.importantData());
            FernflowerResultSaver saver = new FernflowerResultSaver();
            Fernflower baseDecompiler = new Fernflower((IBytecodeProvider)provider, (IResultSaver)saver, settings.getSettings(), (IFernflowerLogger)new PrintStreamLogger(System.out));
            try {
                StructContext context = DecompilerContext.getStructContext();
                for (Map.Entry<String, byte[]> ent : classStruct.importantData().entrySet()) {
                    context.addSpace(new File(ent.getKey() + ".class"), true);
                }
                baseDecompiler.decompileContext();
            }
            catch (Exception t) {
                DecompilerContext.getLogger().writeMessage("Error while decompiling", (Throwable)t);
            }
            finally {
                baseDecompiler.clearContext();
            }
            DecompilationResult decompilationResult = new DecompilationResult();
            String key = classStruct.fullClassName();
            decompilationResult.setDecompiledOutput(saver.getResults().get(key));
            return decompilationResult;
        }
        return null;
    }

    @Override
    public FernflowerSettings defaultSettings() {
        return new FernflowerSettings();
    }
}

