/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers.fernflower;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.java.decompiler.main.extern.IBytecodeProvider;

public class FernflowerBytecodeProvider
implements IBytecodeProvider {
    private final Map<String, byte[]> byteData = new HashMap<String, byte[]>();

    public FernflowerBytecodeProvider(Map<String, byte[]> data) {
        this.byteData.putAll(data);
    }

    public byte[] getBytecode(String externalPath, String internalPath) throws IOException {
        Path relativePath = new File(".").getAbsoluteFile().toPath().relativize(Paths.get(externalPath, new String[0]));
        String internalName = relativePath.toString().replace(File.separatorChar, '/').replaceAll("\\.class$", "");
        if (!this.byteData.containsKey(internalName)) {
            throw new IllegalStateException("Expected data to be present for " + externalPath);
        }
        byte[] data = this.byteData.get(internalName);
        return Arrays.copyOf(data, data.length);
    }
}

