/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers.cfr;

import com.heliosdecompiler.transformerapi.TransformationException;
import com.heliosdecompiler.transformerapi.common.Loader;
import com.heliosdecompiler.transformerapi.decompilers.Decompiler;
import com.heliosdecompiler.transformerapi.decompilers.cfr.CFRDataSource;
import com.heliosdecompiler.transformerapi.decompilers.cfr.CFROutputStreamFactory;
import com.heliosdecompiler.transformerapi.decompilers.cfr.CFRSettings;
import java.io.IOException;
import java.util.Arrays;
import jd.core.DecompilationResult;
import org.benf.cfr.reader.api.CfrDriver;
import org.benf.cfr.reader.util.getopt.OptionsImpl;

public class CFRDecompiler
implements Decompiler<CFRSettings> {
    @Override
    public DecompilationResult decompile(Loader loader, String internalName, CFRSettings settings) throws TransformationException, IOException {
        CFROutputStreamFactory sink = new CFROutputStreamFactory();
        String entryPath = internalName + ".class";
        OptionsImpl options = new OptionsImpl(settings.getSettings());
        CfrDriver driver = new CfrDriver.Builder().withBuiltOptions(options).withClassFileSource(new CFRDataSource(loader, loader.load(internalName), entryPath, options)).withOutputSink(sink).build();
        driver.analyse(Arrays.asList(entryPath));
        DecompilationResult decompilationResult = new DecompilationResult();
        decompilationResult.setDecompiledOutput(sink.getGeneratedSource());
        return decompilationResult;
    }

    @Override
    public CFRSettings defaultSettings() {
        return new CFRSettings();
    }
}

