/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.decompilers;

import com.heliosdecompiler.transformerapi.TransformationException;
import com.heliosdecompiler.transformerapi.common.Loader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jd.core.DecompilationResult;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InnerClassNode;
import org.vineflower.java.decompiler.main.extern.IContextSource;
import org.vineflower.java.decompiler.main.extern.IResultSaver;

public interface Decompiler<S> {
    public DecompilationResult decompile(Loader var1, String var2, S var3) throws TransformationException, IOException;

    public S defaultSettings();

    default public DecompilationResult decompile(Loader loader, String internalName) throws TransformationException, IOException {
        return this.decompile(loader, internalName, this.defaultSettings());
    }

    default public ClassStruct readClassAndInnerClasses(Loader loader, String internalName) throws IOException {
        return this.readClassAndInnerClasses(new HashMap<String, byte[]>(), loader, internalName);
    }

    default public ClassStruct readClassAndInnerClasses(Map<String, byte[]> importantData, Loader loader, String internalName) throws IOException {
        String fullClassName = internalName.replace('/', '.');
        if (!importantData.containsKey(internalName) && loader.canLoad(internalName)) {
            byte[] data = loader.load(internalName);
            importantData.put(internalName, data);
            ClassReader reader = new ClassReader(data);
            ClassNode classNode = new ClassNode();
            reader.accept((ClassVisitor)classNode, 7);
            fullClassName = classNode.name;
            if (classNode.innerClasses != null) {
                for (InnerClassNode icn : classNode.innerClasses) {
                    if (!icn.name.startsWith(internalName + "$")) continue;
                    importantData.putAll(this.readClassAndInnerClasses(importantData, (Loader)loader, (String)icn.name).importantData);
                }
            }
        }
        return new ClassStruct(fullClassName, importantData);
    }

    public record ClassStruct(String fullClassName, Map<String, byte[]> importantData) implements IContextSource
    {
        public String getName() {
            return this.fullClassName;
        }

        public IContextSource.Entries getEntries() {
            ArrayList<IContextSource.Entry> classes = new ArrayList<IContextSource.Entry>();
            for (String key : this.importantData.keySet()) {
                classes.add(IContextSource.Entry.parse((String)key));
            }
            return new IContextSource.Entries(classes, Collections.emptyList(), Collections.emptyList());
        }

        public InputStream getInputStream(String resource) throws IOException {
            return new ByteArrayInputStream(this.importantData.get(resource.replaceFirst("\\.class$", "")));
        }

        public IContextSource.IOutputSink createOutputSink(final IResultSaver saver) {
            return new IContextSource.IOutputSink(){

                public void close() throws IOException {
                }

                public void begin() {
                }

                public void acceptOther(String path) {
                }

                public void acceptDirectory(String directory) {
                }

                public void acceptClass(String qualifiedName, String fileName, String content, int[] mapping) {
                    saver.saveClassFile("", qualifiedName, fileName, content, mapping);
                }
            };
        }
    }
}

