/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;

public interface SettingsApplicable {
    default public void applySettings(Map<String, String> settings) throws IllegalAccessException, InvocationTargetException {
        for (Method method : this.getClass().getMethods()) {
            if (!method.getName().startsWith("set")) continue;
            String settingKey = method.getName().substring(3);
            if (Arrays.equals(method.getParameterTypes(), Constants.BOOLEAN_PARAM)) {
                method.invoke((Object)this, "true".equals(settings.get(settingKey)));
                continue;
            }
            if (!Arrays.equals(method.getParameterTypes(), Constants.INT_PARAM)) continue;
            method.invoke((Object)this, Integer.parseInt(settings.getOrDefault(settingKey, "0")));
        }
    }

    public static final class Constants {
        private static final Class<?>[] BOOLEAN_PARAM = new Class[]{Boolean.TYPE};
        private static final Class<?>[] INT_PARAM = new Class[]{Integer.TYPE};

        private Constants() {
        }
    }
}

