/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.common;

import com.heliosdecompiler.transformerapi.common.ClasspathUtil;
import com.heliosdecompiler.transformerapi.common.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.function.FailableFunction;

public class Loader {
    private static final Map<String, ZipFile> openedZipFiles = new ConcurrentHashMap<String, ZipFile>();
    private final Predicate<String> canLoadFunction;
    private final FailableFunction<String, byte[], IOException> loadFunction;
    private String[] classpathEntries;

    public Loader(Predicate<String> canLoadFunction, FailableFunction<String, byte[], IOException> loadFunction, URI jarURI) {
        this.canLoadFunction = canLoadFunction;
        this.loadFunction = loadFunction;
        if (jarURI != null) {
            List<String> jdkClasspath = ClasspathUtil.getJDKClasspath();
            this.classpathEntries = ClasspathUtil.createClasspathEntries(jarURI, jdkClasspath);
        }
    }

    public Loader(Predicate<String> predicate, FailableFunction<String, byte[], IOException> throwingFunction) {
        this(predicate, throwingFunction, null);
    }

    public boolean canLoad(String internalName) {
        if (this.canLoadFunction.test(internalName)) {
            return true;
        }
        if (this.classpathEntries != null) {
            for (String classpathEntry : this.classpathEntries) {
                String extension = FilenameUtils.getExtension((String)classpathEntry);
                if (!"jar".equals(extension) && !"jmod".equals(extension)) continue;
                try {
                    ZipFile zipFile = Maps.computeIfAbsent(openedZipFiles, classpathEntry, Loader::openZipFile);
                    ZipEntry zipEntry = Loader.getZipEntry(internalName, classpathEntry, zipFile);
                    if (zipEntry == null) continue;
                    return true;
                }
                catch (IOException e) {
                    System.err.println(e);
                    return false;
                }
            }
        }
        return false;
    }

    public byte[] load(String internalName) throws IOException {
        byte[] classContents = (byte[])this.loadFunction.apply((Object)internalName);
        if (classContents != null) {
            return classContents;
        }
        if (this.classpathEntries != null) {
            for (String classpathEntry : this.classpathEntries) {
                byte[] byArray;
                block11: {
                    String extension = FilenameUtils.getExtension((String)classpathEntry);
                    if (!"jar".equals(extension) && !"jmod".equals(extension)) continue;
                    ZipFile zipFile = Maps.computeIfAbsent(openedZipFiles, classpathEntry, Loader::openZipFile);
                    ZipEntry zipEntry = Loader.getZipEntry(internalName, classpathEntry, zipFile);
                    if (zipEntry == null) continue;
                    InputStream in = zipFile.getInputStream(zipEntry);
                    try {
                        byArray = IOUtils.toByteArray((InputStream)in);
                        if (in == null) break block11;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (in != null) {
                                try {
                                    in.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException e) {
                            System.err.println(e);
                        }
                    }
                    in.close();
                }
                return byArray;
            }
        }
        return null;
    }

    private static ZipFile openZipFile(String classpathEntry) throws IOException {
        return new ZipFile(new File(classpathEntry));
    }

    private static ZipEntry getZipEntry(String internalName, String classpathEntry, ZipFile zipFile) {
        StringBuilder entryName = new StringBuilder();
        if (classpathEntry.endsWith(".jmod")) {
            entryName.append("classes/");
        }
        entryName.append(internalName);
        if (!internalName.endsWith(".class")) {
            entryName.append(".class");
        }
        return zipFile.getEntry(entryName.toString());
    }
}

