/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi.common;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

public final class ClasspathUtil {
    private ClasspathUtil() {
    }

    public static List<String> getJDKClasspath() {
        ArrayList<String> cpEntries = new ArrayList<String>();
        String javaHome = System.getenv("JAVA_HOME");
        if (javaHome != null && !javaHome.isBlank()) {
            File rt;
            File jmods = new File(javaHome, "jmods");
            if (jmods.exists() && jmods.isDirectory()) {
                File[] files;
                for (File file : files = jmods.listFiles()) {
                    cpEntries.add(file.getAbsolutePath());
                }
            }
            if ((rt = new File(javaHome, "jre/lib/rt.jar")).exists() && rt.isFile()) {
                cpEntries.add(rt.getAbsolutePath());
            }
        }
        return cpEntries;
    }

    public static String[] createClasspathEntries(URI jarURI, List<String> jdkClasspath) {
        File[] files;
        ArrayList<String> cpEntries = new ArrayList<String>(jdkClasspath);
        File parentFile = new File(jarURI).getParentFile();
        if (parentFile.isDirectory() && (files = parentFile.listFiles((dir, name) -> new File(dir, name).isFile() && name.matches(".*(?<!-sources)\\.jar$"))) != null) {
            for (File file : files) {
                cpEntries.add(file.getAbsolutePath());
            }
        }
        return (String[])cpEntries.toArray(String[]::new);
    }
}

