/*
 * Decompiled with CFR 0.152.
 */
package com.heliosdecompiler.transformerapi;

import com.heliosdecompiler.transformerapi.StandardTransformers;
import com.heliosdecompiler.transformerapi.common.Loader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import jd.core.DecompilationResult;
import org.apache.commons.lang3.function.FailableFunction;

public class Sample {
    public byte[] load(String internalName) throws IOException {
        InputStream is = this.getClass().getResourceAsStream("/" + internalName + ".class");
        if (is == null) {
            return null;
        }
        try (InputStream in = is;){
            byte[] byArray;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                byte[] buffer = new byte[1024];
                int read = in.read(buffer);
                while (read > 0) {
                    out.write(buffer, 0, read);
                    read = in.read(buffer);
                }
                byArray = out.toByteArray();
            }
            return byArray;
        }
    }

    public boolean canLoad(String internalName) {
        return this.getClass().getResource("/" + internalName + ".class") != null;
    }

    public static void main(String[] args) {
        Sample sample = new Sample();
        Loader loader = new Loader(sample::canLoad, (FailableFunction<String, byte[], IOException>)((FailableFunction)sample::load));
        HashMap<String, String> preferences = new HashMap<String, String>();
        try {
            String ff = "Vineflower";
            DecompilationResult result = StandardTransformers.decompile(loader, "java/lang/String", preferences, ff);
            System.out.println(result.getDecompiledOutput());
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

