/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.jd.core.v1.api.loader.Loader;

public class ZipLoader
implements Loader {
    protected static final Pattern CLASS_SUFFIX_PATTERN = Pattern.compile("\\.class$");
    private HashMap<String, byte[]> map = new HashMap();

    public ZipLoader(InputStream in) throws IOException {
        byte[] buffer = new byte[2048];
        try (ZipInputStream zis = new ZipInputStream(in);){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (!ze.isDirectory()) {
                    ByteArrayOutputStream out = new ByteArrayOutputStream();
                    int read = zis.read(buffer);
                    while (read > 0) {
                        out.write(buffer, 0, read);
                        read = zis.read(buffer);
                    }
                    this.map.put(this.makeEntryName(ze.getName()), out.toByteArray());
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
        }
    }

    protected String makeEntryName(String entryName) {
        return CLASS_SUFFIX_PATTERN.matcher(entryName).replaceFirst("");
    }

    @Override
    public byte[] load(String internalName) throws IOException {
        return this.map.get(this.makeEntryName(internalName));
    }

    @Override
    public boolean canLoad(String internalName) {
        return this.map.containsKey(this.makeEntryName(internalName));
    }

    public Map<String, byte[]> getMap() {
        return this.map;
    }
}

