/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.util;

public class DefaultStack<E> {
    private E[] elements;
    private int head;

    public DefaultStack() {
        this.elements = new Object[16];
        this.head = 0;
    }

    public DefaultStack(DefaultStack<E> other) {
        this.elements = (Object[])other.elements.clone();
        this.head = other.head;
    }

    public int size() {
        return this.head;
    }

    public boolean isEmpty() {
        return this.head <= 0;
    }

    public void copy(DefaultStack other) {
        if (this.elements.length < other.head) {
            this.elements = new Object[other.head];
        }
        System.arraycopy(other.elements, 0, this.elements, 0, other.head);
        this.head = other.head;
    }

    public void push(E expression) {
        if (this.head == this.elements.length) {
            Object[] tmp = new Object[this.elements.length * 2];
            System.arraycopy(this.elements, 0, tmp, 0, this.elements.length);
            this.elements = tmp;
        }
        this.elements[this.head++] = expression;
    }

    public E pop() {
        E e = this.elements[--this.head];
        this.elements[this.head] = null;
        return e;
    }

    public E peek() {
        return this.elements[this.head - 1];
    }

    public void replace(E old, E nevv) {
        int i = this.head - 1;
        while (i >= 0 && this.elements[i] == old) {
            this.elements[i--] = nevv;
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Stack{head=");
        sb.append(this.head);
        sb.append(", elements=[");
        if (this.head > 0) {
            sb.append(this.elements[0]);
            for (int i = 1; i < this.head; ++i) {
                sb.append(", ");
                sb.append(this.elements[i]);
            }
        }
        sb.append("]}");
        return sb.toString();
    }
}

