/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.deserializer.classfile;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import jd.core.process.analyzer.instruction.bytecode.util.ByteCodeUtil;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.Code;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.InnerClass;
import org.apache.bcel.classfile.InnerClasses;
import org.apache.bcel.classfile.Method;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.util.DefaultList;

public final class ClassFileDeserializer {
    public ClassFile loadClassFile(Loader loader, String internalTypeName) throws IOException {
        ClassFile classFile = this.innerLoadClassFile(loader, internalTypeName);
        if (classFile == null) {
            throw new IllegalArgumentException("Class '" + internalTypeName + "' could not be loaded");
        }
        for (Method method : classFile.getMethods()) {
            Code methodCode = method.getCode();
            if (methodCode == null) continue;
            ByteCodeUtil.cleanUpByteCode(methodCode.getCode());
        }
        return classFile;
    }

    private ClassFile innerLoadClassFile(Loader loader, String internalTypeName) throws IOException {
        if (!loader.canLoad(internalTypeName)) {
            return null;
        }
        byte[] data = loader.load(internalTypeName);
        if (data == null) {
            return null;
        }
        try (DataInputStream reader = new DataInputStream(new ByteArrayInputStream(data));){
            ClassParser classParser = new ClassParser((InputStream)reader, internalTypeName);
            ClassFile classFile = new ClassFile(classParser.parse());
            InnerClasses innerClasses = (InnerClasses)classFile.getAttribute((byte)6);
            if (innerClasses != null) {
                DefaultList<ClassFile> innerClassFiles = new DefaultList<ClassFile>();
                String innerTypePrefix = internalTypeName + "$";
                for (InnerClass ic : innerClasses.getInnerClasses()) {
                    String outerTypeName;
                    ConstantPool cp = classFile.getConstantPool();
                    String innerTypeName = cp.getConstantString(ic.getInnerClassIndex(), (byte)7);
                    String string = outerTypeName = ic.getOuterClassIndex() == 0 ? null : cp.getConstantString(ic.getOuterClassIndex(), (byte)7);
                    if (internalTypeName.equals(innerTypeName) || !internalTypeName.equals(outerTypeName) && !innerTypeName.startsWith(innerTypePrefix)) continue;
                    ClassFile innerClassFile = this.innerLoadClassFile(loader, innerTypeName);
                    int flags = ic.getInnerAccessFlags();
                    int length = innerTypeName.startsWith(innerTypePrefix) ? internalTypeName.length() + 1 : innerTypeName.indexOf(36) + 1;
                    if (Character.isDigit(innerTypeName.charAt(length))) {
                        flags |= 0x1000;
                    }
                    if (innerClassFile == null) {
                        innerClassFile = new ClassFile(null);
                    }
                    innerClassFile.setOuterClassFile(classFile);
                    innerClassFile.setAccessFlags(flags);
                    innerClassFiles.add(innerClassFile);
                }
                if (!innerClassFiles.isEmpty()) {
                    classFile.setInnerClassFiles(innerClassFiles);
                }
            }
            ClassFile classFile2 = classFile;
            return classFile2;
        }
    }
}

