/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.AbstractNopTypeVisitor;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.Types;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypeArgumentsToTypeArgumentsVisitor;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeArgumentToTypeVisitor;

public class BindTypesToTypesVisitor
extends AbstractNopTypeVisitor {
    private final TypeArgumentToTypeVisitor typeArgumentToTypeVisitor = new TypeArgumentToTypeVisitor();
    private final BindTypeArgumentsToTypeArgumentsVisitor bindTypeArgumentsToTypeArgumentsVisitor = new BindTypeArgumentsToTypeArgumentsVisitor();
    private Map<String, TypeArgument> bindings;
    private BaseType result;

    public void setBindings(Map<String, TypeArgument> bindings) {
        this.bindings = bindings;
        this.bindTypeArgumentsToTypeArgumentsVisitor.setBindings(this.bindings);
    }

    public void init() {
        this.result = null;
    }

    public BaseType getType() {
        return this.result;
    }

    @Override
    public void visit(PrimitiveType type) {
        this.result = type;
    }

    @Override
    public void visit(ObjectType type) {
        BaseTypeArgument typeArguments = type.getTypeArguments();
        if (typeArguments == null) {
            this.result = type;
        } else {
            this.bindTypeArgumentsToTypeArgumentsVisitor.init();
            typeArguments.accept(this.bindTypeArgumentsToTypeArgumentsVisitor);
            BaseTypeArgument ta = this.bindTypeArgumentsToTypeArgumentsVisitor.getTypeArgument();
            this.result = typeArguments == ta ? type : type.createType(ta);
        }
    }

    @Override
    public void visit(InnerObjectType type) {
        ObjectType outerType = type.getOuterType();
        if (outerType != null) {
            outerType.accept(this);
        }
        BaseTypeArgument typeArguments = type.getTypeArguments();
        if (type.getOuterType() == this.result) {
            if (typeArguments == null) {
                this.result = type;
            } else {
                this.bindTypeArgumentsToTypeArgumentsVisitor.init();
                typeArguments.accept(this.bindTypeArgumentsToTypeArgumentsVisitor);
                BaseTypeArgument ta = this.bindTypeArgumentsToTypeArgumentsVisitor.getTypeArgument();
                this.result = typeArguments == ta ? type : type.createType(ta);
            }
        } else {
            ObjectType outerObjectType = (ObjectType)this.result;
            if (typeArguments != null) {
                this.bindTypeArgumentsToTypeArgumentsVisitor.init();
                typeArguments.accept(this.bindTypeArgumentsToTypeArgumentsVisitor);
                typeArguments = this.bindTypeArgumentsToTypeArgumentsVisitor.getTypeArgument();
                if (WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT == typeArguments) {
                    typeArguments = null;
                }
            }
            this.result = new InnerObjectType(type.getInternalName(), type.getQualifiedName(), type.getName(), typeArguments, type.getDimension(), outerObjectType);
        }
    }

    @Override
    public void visit(GenericType type) {
        TypeArgument ta = this.bindings.get(type.getName());
        if (ta == null || ta == WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT) {
            this.result = ObjectType.TYPE_OBJECT.createType(type.getDimension());
        } else {
            this.typeArgumentToTypeVisitor.init();
            ta.accept(this.typeArgumentToTypeVisitor);
            Type t = this.typeArgumentToTypeVisitor.getType();
            this.result = t.createType(t.getDimension() + type.getDimension());
        }
    }

    @Override
    public void visit(Types types) {
        int i;
        int size = types.size();
        for (i = 0; i < size; ++i) {
            Type t = (Type)types.get(i);
            t.accept(this);
            if (this.result != t) break;
        }
        if (i == size) {
            this.result = types;
        } else {
            Types newTypes = new Types(size);
            newTypes.addAll(types.subList(0, i));
            newTypes.add((Type)this.result);
            ++i;
            while (i < size) {
                Type t = (Type)types.get(i);
                t.accept(this);
                newTypes.add((Type)this.result);
                ++i;
            }
            this.result = newTypes;
        }
    }
}

