/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.visitor;

import java.util.Map;
import org.jd.core.v1.model.javasyntax.type.AbstractTypeArgumentVisitor;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.DiamondTypeArgument;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.TypeArgumentToTypeVisitor;

public class BindTypeArgumentsToTypeArgumentsVisitor
extends AbstractTypeArgumentVisitor {
    private final TypeArgumentToTypeVisitor typeArgumentToTypeVisitor = new TypeArgumentToTypeVisitor();
    private Map<String, TypeArgument> bindings;
    private BaseTypeArgument result;

    void setBindings(Map<String, TypeArgument> bindings) {
        this.bindings = bindings;
    }

    public void init() {
        this.result = null;
    }

    public BaseTypeArgument getTypeArgument() {
        if (this.result == null || ObjectType.TYPE_OBJECT.equals(this.result)) {
            return null;
        }
        return this.result;
    }

    @Override
    public void visit(TypeArguments arguments) {
        int i;
        int size = arguments.size();
        for (i = 0; i < size; ++i) {
            TypeArgument ta = (TypeArgument)arguments.get(i);
            ta.accept(this);
            if (this.result != ta) break;
        }
        if (this.result != null) {
            if (i == size) {
                this.result = arguments;
            } else {
                TypeArguments newTypes = new TypeArguments(size);
                newTypes.addAll(arguments.subList(0, i));
                newTypes.add((TypeArgument)this.result);
                ++i;
                while (i < size) {
                    TypeArgument ta = (TypeArgument)arguments.get(i);
                    ta.accept(this);
                    if (this.result == null) {
                        return;
                    }
                    newTypes.add((TypeArgument)this.result);
                    ++i;
                }
                this.result = newTypes;
            }
        }
    }

    @Override
    public void visit(DiamondTypeArgument argument) {
        this.result = argument;
    }

    @Override
    public void visit(WildcardExtendsTypeArgument argument) {
        argument.type().accept(this);
        if (this.result == WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT) {
            this.result = WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT;
        } else if (this.result == argument.type()) {
            this.result = argument;
        } else if (ObjectType.TYPE_OBJECT.equals(this.result)) {
            this.result = WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT;
        } else if (this.result != null) {
            this.typeArgumentToTypeVisitor.init();
            this.result.accept(this.typeArgumentToTypeVisitor);
            Type bt = this.typeArgumentToTypeVisitor.getType();
            this.result = ObjectType.TYPE_OBJECT.equals(bt) ? WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT : new WildcardExtendsTypeArgument(bt);
        }
    }

    @Override
    public void visit(PrimitiveType type) {
        this.result = type;
    }

    @Override
    public void visit(ObjectType type) {
        BaseTypeArgument typeArguments = type.getTypeArguments();
        if (typeArguments == null) {
            this.result = type;
        } else {
            typeArguments.accept(this);
            if (typeArguments == this.result) {
                this.result = type;
            } else if (this.result != null) {
                this.result = type.createType(this.result);
            }
        }
    }

    @Override
    public void visit(InnerObjectType type) {
        this.safeAccept(type.getOuterType());
        BaseTypeArgument typeArguments = type.getTypeArguments();
        if (type.getOuterType() == this.result) {
            if (typeArguments == null) {
                this.result = type;
            } else {
                typeArguments.accept(this);
                if (typeArguments == this.result) {
                    this.result = type;
                } else if (this.result != null) {
                    this.result = type.createType(this.result);
                }
            }
        } else {
            ObjectType outerObjectType = (ObjectType)this.result;
            if (typeArguments != null) {
                typeArguments.accept(this);
                typeArguments = this.result;
            }
            this.result = new InnerObjectType(type.getInternalName(), type.getQualifiedName(), type.getName(), typeArguments, type.getDimension(), outerObjectType);
        }
    }

    @Override
    public void visit(WildcardSuperTypeArgument argument) {
        argument.type().accept(this);
        if (this.result == WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT) {
            this.result = WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT;
        } else if (this.result == argument.type()) {
            this.result = argument;
        } else if (this.result != null) {
            this.typeArgumentToTypeVisitor.init();
            this.result.accept(this.typeArgumentToTypeVisitor);
            this.result = new WildcardSuperTypeArgument(this.typeArgumentToTypeVisitor.getType());
        }
    }

    @Override
    public void visit(GenericType type) {
        TypeArgument ta = this.bindings.get(type.getName());
        if (ta == null) {
            this.result = null;
        } else if (ta instanceof Type) {
            Type t = (Type)ta;
            this.result = t.createType(Math.max(t.getDimension(), type.getDimension()));
        } else {
            this.result = ta;
        }
    }

    @Override
    public void visit(WildcardTypeArgument argument) {
        this.result = argument;
    }
}

