/*
 * Decompiled with CFR 0.152.
 */
package org.jd.core.v1.service.converter.classfiletojavasyntax.util;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.bcel.classfile.ClassFormatException;
import org.apache.bcel.classfile.ExceptionTable;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.FieldOrMethod;
import org.apache.bcel.classfile.Signature;
import org.apache.commons.lang3.Validate;
import org.jd.core.v1.api.loader.Loader;
import org.jd.core.v1.loader.ClassPathLoader;
import org.jd.core.v1.model.classfile.ClassFile;
import org.jd.core.v1.model.javasyntax.expression.BaseExpression;
import org.jd.core.v1.model.javasyntax.expression.Expression;
import org.jd.core.v1.model.javasyntax.expression.LambdaIdentifiersExpression;
import org.jd.core.v1.model.javasyntax.type.BaseType;
import org.jd.core.v1.model.javasyntax.type.BaseTypeArgument;
import org.jd.core.v1.model.javasyntax.type.BaseTypeParameter;
import org.jd.core.v1.model.javasyntax.type.GenericType;
import org.jd.core.v1.model.javasyntax.type.InnerObjectType;
import org.jd.core.v1.model.javasyntax.type.ObjectType;
import org.jd.core.v1.model.javasyntax.type.PrimitiveType;
import org.jd.core.v1.model.javasyntax.type.Type;
import org.jd.core.v1.model.javasyntax.type.TypeArgument;
import org.jd.core.v1.model.javasyntax.type.TypeArguments;
import org.jd.core.v1.model.javasyntax.type.TypeParameter;
import org.jd.core.v1.model.javasyntax.type.TypeParameterWithTypeBounds;
import org.jd.core.v1.model.javasyntax.type.TypeParameters;
import org.jd.core.v1.model.javasyntax.type.UnmodifiableTypes;
import org.jd.core.v1.model.javasyntax.type.WildcardExtendsTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardSuperTypeArgument;
import org.jd.core.v1.model.javasyntax.type.WildcardTypeArgument;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.ExceptionUtil;
import org.jd.core.v1.service.converter.classfiletojavasyntax.util.SignatureFormatException;
import org.jd.core.v1.service.converter.classfiletojavasyntax.visitor.BindTypesToTypesVisitor;

public class TypeMaker {
    private static final Map<String, ObjectType> INTERNALNAME_TO_OBJECTPRIMITIVETYPE = new HashMap<String, ObjectType>();
    private static final Map<String, Boolean> loaded;
    private static final Map<String, Type> signatureToType;
    private static final Map<String, Type> internalTypeNameFieldNameToType;
    private static final Map<String, ObjectType> descriptorToObjectType;
    private static final Map<String, ObjectType> internalTypeNameToObjectType;
    private static final Map<String, TypeTypes> internalTypeNameToTypeTypes;
    private static final Map<String, Set<BaseType>> internalTypeNameMethodNameParameterCountToDeclaredParameterTypes;
    private static final Map<String, Set<BaseType>> internalTypeNameMethodNameParameterCountToParameterTypes;
    private static final Map<String, MethodTypes> internalTypeNameMethodNameDescriptorToMethodTypes;
    private final Map<String, MethodTypes> signatureToMethodTypes = new HashMap<String, MethodTypes>(1024);
    private final Map<Long, Boolean> assignableRawTypes = new HashMap<Long, Boolean>(1024);
    private final Map<Long, ObjectType> superParameterizedObjectTypes = new HashMap<Long, ObjectType>(1024);
    private static final Map<String, String[]> hierarchy;
    private static final ClassPathLoader classPathLoader;
    private final Loader loader;

    public TypeMaker() {
        this(classPathLoader);
    }

    public TypeMaker(Loader loader) {
        this.loader = loader;
        signatureToType.put("B", PrimitiveType.TYPE_BYTE);
        signatureToType.put("C", PrimitiveType.TYPE_CHAR);
        signatureToType.put("D", PrimitiveType.TYPE_DOUBLE);
        signatureToType.put("F", PrimitiveType.TYPE_FLOAT);
        signatureToType.put("I", PrimitiveType.TYPE_INT);
        signatureToType.put("J", PrimitiveType.TYPE_LONG);
        signatureToType.put("S", PrimitiveType.TYPE_SHORT);
        signatureToType.put("V", PrimitiveType.TYPE_VOID);
        signatureToType.put("Z", PrimitiveType.TYPE_BOOLEAN);
        signatureToType.put("Ljava/lang/Class;", ObjectType.TYPE_CLASS);
        signatureToType.put("Ljava/lang/Exception;", ObjectType.TYPE_EXCEPTION);
        signatureToType.put("Ljava/lang/Object;", ObjectType.TYPE_OBJECT);
        signatureToType.put("Ljava/lang/Throwable;", ObjectType.TYPE_THROWABLE);
        signatureToType.put("Ljava/lang/String;", ObjectType.TYPE_STRING);
        signatureToType.put("Ljava/lang/System;", ObjectType.TYPE_SYSTEM);
        descriptorToObjectType.put("Ljava/lang/Class;", ObjectType.TYPE_CLASS);
        descriptorToObjectType.put("Ljava/lang/Exception;", ObjectType.TYPE_EXCEPTION);
        descriptorToObjectType.put("Ljava/lang/Object;", ObjectType.TYPE_OBJECT);
        descriptorToObjectType.put("Ljava/lang/Throwable;", ObjectType.TYPE_THROWABLE);
        descriptorToObjectType.put("Ljava/lang/String;", ObjectType.TYPE_STRING);
        descriptorToObjectType.put("Ljava/lang/System;", ObjectType.TYPE_SYSTEM);
        this.loadType("java/lang/Boolean");
        this.loadType("java/lang/Byte");
        this.loadType("java/lang/Character");
        this.loadType("java/lang/Class");
        this.loadType("java/lang/Double");
        this.loadType("java/lang/Enum");
        this.loadType("java/lang/Exception");
        this.loadType("java/lang/Float");
        this.loadType("java/lang/Integer");
        this.loadType("java/lang/Iterable");
        this.loadType("java/lang/Long");
        this.loadType("java/lang/Math");
        this.loadType("java/lang/Number");
        this.loadType("java/lang/Object");
        this.loadType("java/lang/RuntimeException");
        this.loadType("java/lang/Short");
        this.loadType("java/lang/String");
        this.loadType("java/lang/StringBuffer");
        this.loadType("java/lang/StringBuilder");
        this.loadType("java/lang/System");
        this.loadType("java/lang/Thread");
        this.loadType("java/lang/Throwable");
        this.loadType("java/util/Date");
    }

    public TypeTypes parseClassFileSignature(ClassFile classFile) {
        TypeTypes typeTypes = new TypeTypes();
        String internalTypeName = classFile.getInternalTypeName();
        typeTypes.setThisType(this.makeFromInternalTypeName(internalTypeName));
        Signature attributeSignature = (Signature)classFile.getAttribute((byte)10);
        if (attributeSignature == null) {
            String superTypeName = classFile.getSuperTypeName();
            String[] interfaceTypeNames = classFile.getInterfaceTypeNames();
            if (superTypeName != null && !"java/lang/Object".equals(superTypeName)) {
                typeTypes.setSuperType(this.makeFromInternalTypeName(superTypeName));
            }
            if (interfaceTypeNames != null) {
                int length = interfaceTypeNames.length;
                if (length == 1) {
                    typeTypes.setInterfaces(this.makeFromInternalTypeName(interfaceTypeNames[0]));
                } else {
                    UnmodifiableTypes list = new UnmodifiableTypes(length);
                    for (String interfaceTypeName : interfaceTypeNames) {
                        list.add(this.makeFromInternalTypeName(interfaceTypeName));
                    }
                    typeTypes.setInterfaces(list);
                }
            }
        } else {
            SignatureReader signatureReader = new SignatureReader(attributeSignature.getSignature());
            typeTypes.setTypeParameters(this.parseTypeParameters(signatureReader));
            typeTypes.setSuperType(this.parseClassTypeSignature(signatureReader, 0));
            ObjectType firstInterface = this.parseClassTypeSignature(signatureReader, 0);
            if (firstInterface != null) {
                ObjectType nextInterface = this.parseClassTypeSignature(signatureReader, 0);
                if (nextInterface == null) {
                    typeTypes.setInterfaces(firstInterface);
                } else {
                    UnmodifiableTypes list = new UnmodifiableTypes(classFile.getInterfaceTypeNames().length);
                    list.add(firstInterface);
                    do {
                        list.add(nextInterface);
                    } while ((nextInterface = this.parseClassTypeSignature(signatureReader, 0)) != null);
                    typeTypes.setInterfaces(list);
                }
            }
        }
        internalTypeNameToTypeTypes.put(internalTypeName, typeTypes);
        return typeTypes;
    }

    public MethodTypes parseMethodSignature(ClassFile classFile, org.apache.bcel.classfile.Method method) {
        String key = classFile.getInternalTypeName() + ":" + method.getName() + method.getSignature();
        return this.parseMethodSignature(classFile.getInternalTypeName(), method, key);
    }

    private MethodTypes parseMethodSignature(String internalTypeName, org.apache.bcel.classfile.Method method, String key) {
        Signature attributeSignature = TypeMaker.getSignature((FieldOrMethod)method);
        String[] exceptionTypeNames = TypeMaker.getExceptionTypeNames(method);
        MethodTypes methodTypes = attributeSignature == null ? this.parseMethodSignature(internalTypeName, method.getName(), method.getSignature(), exceptionTypeNames) : this.parseMethodSignature(internalTypeName, method.getName(), method.getSignature(), attributeSignature.getSignature(), exceptionTypeNames);
        internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
        return methodTypes;
    }

    private static String[] getExceptionTypeNames(org.apache.bcel.classfile.Method method) {
        ExceptionTable attributeExceptions;
        if (method != null && (attributeExceptions = method.getExceptionTable()) != null) {
            int[] exceptionIndexTable = attributeExceptions.getExceptionIndexTable();
            String[] exceptionNames = new String[exceptionIndexTable.length];
            for (int i = 0; i < exceptionNames.length; ++i) {
                exceptionNames[i] = attributeExceptions.getConstantPool().getConstantString(exceptionIndexTable[i], (byte)7);
            }
            return exceptionNames;
        }
        return null;
    }

    public Type parseFieldSignature(ClassFile classFile, Field field) {
        String key = classFile.getInternalTypeName() + ":" + field.getName();
        Signature attributeSignature = TypeMaker.getSignature((FieldOrMethod)field);
        String signature = attributeSignature == null ? field.getSignature() : attributeSignature.getSignature();
        Type type = this.makeFromSignature(signature);
        TypeMaker.putInternalTypeNameFieldNameToType(key, type);
        return type;
    }

    private static Signature getSignature(FieldOrMethod fm) {
        return Stream.of(fm.getAttributes()).filter(Signature.class::isInstance).findAny().orElse(null);
    }

    public Type makeFromSignature(String signature) {
        return signatureToType.computeIfAbsent(signature, this::parseReferenceTypeSignature);
    }

    public static int countDimension(String descriptor) {
        int count = 0;
        int len = descriptor.length();
        for (int i = 0; i < len && descriptor.charAt(i) == '['; ++i) {
            ++count;
        }
        return count;
    }

    private MethodTypes parseMethodSignature(String internalTypeName, String methodName, String descriptor, String signature, String[] exceptionTypeNames) {
        if (signature == null) {
            return this.parseMethodSignature(internalTypeName, methodName, descriptor, exceptionTypeNames);
        }
        MethodTypes mtDescriptor = this.parseMethodSignature(internalTypeName, methodName, descriptor, exceptionTypeNames);
        MethodTypes mtSignature = this.parseMethodSignature(internalTypeName, methodName, signature, exceptionTypeNames);
        if (mtDescriptor.getParameterTypes() != null) {
            if (mtSignature.getParameterTypes() == null) {
                MethodTypes mt = new MethodTypes();
                mt.setTypeParameters(mtSignature.getTypeParameters());
                mt.setParameterTypes(mtDescriptor.getParameterTypes());
                mt.setReturnedType(mtSignature.getReturnedType());
                mt.setExceptionTypes(mtSignature.getExceptionTypes());
                return mt;
            }
            if (mtDescriptor.getParameterTypes().size() != mtSignature.getParameterTypes().size()) {
                UnmodifiableTypes parameterTypes = new UnmodifiableTypes((Collection<Type>)mtDescriptor.getParameterTypes().getList().subList(0, mtDescriptor.getParameterTypes().size() - mtSignature.getParameterTypes().size()));
                parameterTypes.addAll(mtSignature.getParameterTypes().getList());
                MethodTypes mt = new MethodTypes();
                mt.setTypeParameters(mtSignature.getTypeParameters());
                mt.setParameterTypes(parameterTypes);
                mt.setReturnedType(mtSignature.getReturnedType());
                mt.setExceptionTypes(mtSignature.getExceptionTypes());
                return mt;
            }
        }
        return mtSignature;
    }

    private MethodTypes parseMethodSignature(String internalTypeName, String methodName, String signature, String[] exceptionTypeNames) {
        MethodTypes methodTypes;
        boolean containsThrowsSignature;
        Object cacheKey = internalTypeName + "." + methodName + signature;
        boolean bl = containsThrowsSignature = signature.indexOf(94) != -1;
        if (!containsThrowsSignature && exceptionTypeNames != null) {
            StringBuilder sb = new StringBuilder((String)cacheKey);
            for (String exceptionTypeName : exceptionTypeNames) {
                sb.append("^L").append(exceptionTypeName).append(';');
            }
            cacheKey = sb.toString();
        }
        if ((methodTypes = this.signatureToMethodTypes.get(cacheKey)) == null) {
            SignatureReader reader = new SignatureReader(signature);
            methodTypes = new MethodTypes();
            methodTypes.setTypeParameters(this.parseTypeParameters(reader));
            TypeMaker.ensureReadCharacter(reader, '(');
            Type firstParameterType = this.parseReferenceTypeSignature(reader);
            if (firstParameterType == null) {
                methodTypes.setParameterTypes(null);
            } else {
                Type nextParameterType = this.parseReferenceTypeSignature(reader);
                UnmodifiableTypes types = new UnmodifiableTypes();
                types.add(firstParameterType);
                while (nextParameterType != null) {
                    types.add(nextParameterType);
                    nextParameterType = this.parseReferenceTypeSignature(reader);
                }
                methodTypes.setParameterTypes(types);
            }
            TypeMaker.ensureReadCharacter(reader, ')');
            methodTypes.setReturnedType(this.parseReferenceTypeSignature(reader));
            Type firstException = this.parseExceptionSignature(reader);
            if (firstException == null) {
                if (exceptionTypeNames != null) {
                    if (exceptionTypeNames.length == 1) {
                        methodTypes.setExceptionTypes(this.makeFromInternalTypeName(exceptionTypeNames[0]));
                    } else {
                        UnmodifiableTypes list = new UnmodifiableTypes(exceptionTypeNames.length);
                        for (String exceptionTypeName : exceptionTypeNames) {
                            list.add(this.makeFromInternalTypeName(exceptionTypeName));
                        }
                        methodTypes.setExceptionTypes(list);
                    }
                }
            } else {
                Type nextException = this.parseExceptionSignature(reader);
                if (nextException == null) {
                    methodTypes.setExceptionTypes(firstException);
                } else {
                    UnmodifiableTypes list = new UnmodifiableTypes();
                    list.add(firstException);
                    do {
                        list.add(nextException);
                    } while ((nextException = this.parseExceptionSignature(reader)) != null);
                    methodTypes.setExceptionTypes(list);
                }
            }
            this.signatureToMethodTypes.put((String)cacheKey, methodTypes);
        }
        return methodTypes;
    }

    private BaseTypeParameter parseTypeParameters(SignatureReader reader) {
        if (reader.nextEqualsTo('<')) {
            BaseTypeParameter typeParameters;
            ++reader.index;
            TypeParameter firstTypeParameter = this.parseTypeParameter(reader);
            TypeMaker.requireNonNull(reader, firstTypeParameter);
            TypeParameter nextTypeParameter = this.parseTypeParameter(reader);
            if (nextTypeParameter == null) {
                typeParameters = firstTypeParameter;
            } else {
                TypeParameters list = new TypeParameters();
                list.add(firstTypeParameter);
                do {
                    list.add(nextTypeParameter);
                } while ((nextTypeParameter = this.parseTypeParameter(reader)) != null);
                typeParameters = list;
            }
            TypeMaker.ensureReadCharacter(reader, '>');
            return typeParameters;
        }
        return null;
    }

    TypeParameter parseTypeParameter(SignatureReader reader) {
        int fistIndex = reader.index;
        if (reader.search(':')) {
            String identifier = reader.substring(fistIndex);
            Type firstBound = null;
            ArrayList types = null;
            while (reader.nextEqualsTo(':')) {
                ++reader.index;
                Type bound = this.parseReferenceTypeSignature(reader);
                if (bound == null || "Ljava/lang/Object;".equals(bound.getDescriptor())) continue;
                if (firstBound == null) {
                    firstBound = bound;
                    continue;
                }
                if (types == null) {
                    types = new UnmodifiableTypes();
                    types.add(firstBound);
                }
                types.add(bound);
            }
            if (firstBound == null) {
                return new TypeParameter(identifier);
            }
            if (types == null) {
                return new TypeParameterWithTypeBounds(identifier, firstBound);
            }
            return new TypeParameterWithTypeBounds(identifier, (BaseType)((Object)types));
        }
        return null;
    }

    private Type parseExceptionSignature(SignatureReader reader) {
        if (reader.nextEqualsTo('^')) {
            ++reader.index;
            return this.parseReferenceTypeSignature(reader);
        }
        return null;
    }

    ObjectType parseClassTypeSignature(SignatureReader reader, int dimension) {
        if (reader.nextEqualsTo('L')) {
            ++reader.index;
            int index = reader.index++;
            char endMarker = TypeMaker.ensureNonZeroEndMarker(reader);
            String internalTypeName = reader.substring(index);
            ObjectType ot = this.makeFromInternalTypeName(internalTypeName);
            if (endMarker == '<') {
                ot = ot.createType(this.parseTypeArguments(reader));
                TypeMaker.ensureReadCharacter(reader, '>');
            }
            while (reader.nextEqualsTo('.')) {
                String qualifiedName;
                index = ++reader.index;
                endMarker = TypeMaker.ensureNonZeroEndMarker(reader);
                String name = reader.substring(index);
                internalTypeName = String.join((CharSequence)"$", internalTypeName, name);
                if (Character.isDigit(name.charAt(0))) {
                    name = TypeMaker.extractLocalClassName(name);
                    qualifiedName = null;
                } else {
                    qualifiedName = ot.getQualifiedName() + "." + name;
                }
                if (endMarker == '<') {
                    ++reader.index;
                    BaseTypeArgument typeArguments = this.parseTypeArguments(reader);
                    TypeMaker.ensureReadCharacter(reader, '>');
                    ot = new InnerObjectType(internalTypeName, qualifiedName, name, typeArguments, ot);
                    continue;
                }
                ot = new InnerObjectType(internalTypeName, qualifiedName, name, ot);
            }
            ++reader.index;
            return dimension == 0 ? ot : (ObjectType)ot.createType(dimension);
        }
        return null;
    }

    private static char ensureNonZeroEndMarker(SignatureReader reader) {
        char endMarker = reader.searchEndMarker();
        if (endMarker == '\u0000') {
            throw new SignatureFormatException(reader.signature);
        }
        return endMarker;
    }

    private static void ensureReadCharacter(SignatureReader reader, char closingCharacter) {
        if (reader.read() != closingCharacter) {
            throw new SignatureFormatException(reader.signature);
        }
    }

    private BaseTypeArgument parseTypeArguments(SignatureReader reader) {
        TypeArgument firstTypeArgument = this.parseTypeArgument(reader);
        TypeMaker.requireNonNull(reader, firstTypeArgument);
        TypeArgument nextTypeArgument = this.parseTypeArgument(reader);
        if (nextTypeArgument == null) {
            return firstTypeArgument;
        }
        TypeArguments typeArguments = new TypeArguments();
        typeArguments.add(firstTypeArgument);
        do {
            typeArguments.add(nextTypeArgument);
        } while ((nextTypeArgument = this.parseTypeArgument(reader)) != null);
        return typeArguments;
    }

    private static void requireNonNull(SignatureReader reader, Object o) {
        if (o == null) {
            throw new SignatureFormatException(reader.signature);
        }
    }

    private Type parseReferenceTypeSignature(String signature) {
        return this.parseReferenceTypeSignature(new SignatureReader(signature));
    }

    Type parseReferenceTypeSignature(SignatureReader reader) {
        if (reader.available()) {
            int dimension = 0;
            char c = reader.read();
            while (c == '[') {
                ++dimension;
                c = reader.read();
            }
            switch (c) {
                case 'B': {
                    return dimension == 0 ? PrimitiveType.TYPE_BYTE : PrimitiveType.TYPE_BYTE.createType(dimension);
                }
                case 'C': {
                    return dimension == 0 ? PrimitiveType.TYPE_CHAR : PrimitiveType.TYPE_CHAR.createType(dimension);
                }
                case 'D': {
                    return dimension == 0 ? PrimitiveType.TYPE_DOUBLE : PrimitiveType.TYPE_DOUBLE.createType(dimension);
                }
                case 'F': {
                    return dimension == 0 ? PrimitiveType.TYPE_FLOAT : PrimitiveType.TYPE_FLOAT.createType(dimension);
                }
                case 'I': {
                    return dimension == 0 ? PrimitiveType.TYPE_INT : PrimitiveType.TYPE_INT.createType(dimension);
                }
                case 'J': {
                    return dimension == 0 ? PrimitiveType.TYPE_LONG : PrimitiveType.TYPE_LONG.createType(dimension);
                }
                case 'L': {
                    --reader.index;
                    return this.parseClassTypeSignature(reader, dimension);
                }
                case 'S': {
                    return dimension == 0 ? PrimitiveType.TYPE_SHORT : PrimitiveType.TYPE_SHORT.createType(dimension);
                }
                case 'T': {
                    int index = reader.index++;
                    if (!reader.search(';')) {
                        return null;
                    }
                    String identifier = reader.substring(index);
                    return new GenericType(identifier, dimension);
                }
                case 'V': {
                    Validate.isTrue((dimension == 0 ? 1 : 0) != 0);
                    return PrimitiveType.TYPE_VOID;
                }
                case 'Z': {
                    return dimension == 0 ? PrimitiveType.TYPE_BOOLEAN : PrimitiveType.TYPE_BOOLEAN.createType(dimension);
                }
            }
            --reader.index;
            return null;
        }
        return null;
    }

    private TypeArgument parseTypeArgument(SignatureReader reader) {
        switch (reader.read()) {
            case '+': {
                return new WildcardExtendsTypeArgument(this.parseReferenceTypeSignature(reader));
            }
            case '-': {
                return new WildcardSuperTypeArgument(this.parseReferenceTypeSignature(reader));
            }
            case '*': {
                return WildcardTypeArgument.WILDCARD_TYPE_ARGUMENT;
            }
        }
        --reader.index;
        return this.parseReferenceTypeSignature(reader);
    }

    static boolean isAReferenceTypeSignature(SignatureReader reader) {
        if (reader.available()) {
            char c = reader.read();
            while (c == '[') {
                c = reader.read();
            }
            switch (c) {
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    return true;
                }
                case 'L': {
                    --reader.index;
                    return TypeMaker.isAClassTypeSignature(reader);
                }
                case 'T': {
                    reader.searchEndMarker();
                    return true;
                }
            }
            --reader.index;
            return false;
        }
        return false;
    }

    static boolean isAClassTypeSignature(SignatureReader reader) {
        if (reader.nextEqualsTo('L')) {
            ++reader.index;
            char endMarker = TypeMaker.ensureNonZeroEndMarker(reader);
            if (endMarker == '<') {
                ++reader.index;
                TypeMaker.isATypeArguments(reader);
                TypeMaker.ensureReadCharacter(reader, '>');
            }
            while (reader.nextEqualsTo('.')) {
                ++reader.index;
                endMarker = TypeMaker.ensureNonZeroEndMarker(reader);
                if (endMarker != '<') continue;
                ++reader.index;
                TypeMaker.isATypeArguments(reader);
                TypeMaker.ensureReadCharacter(reader, '>');
            }
            ++reader.index;
            return true;
        }
        return false;
    }

    private static boolean isATypeArguments(SignatureReader reader) {
        if (!TypeMaker.isATypeArgument(reader)) {
            throw new SignatureFormatException(reader.signature);
        }
        while (TypeMaker.isATypeArgument(reader)) {
        }
        return true;
    }

    private static boolean isATypeArgument(SignatureReader reader) {
        switch (reader.read()) {
            case '+': 
            case '-': {
                return TypeMaker.isAReferenceTypeSignature(reader);
            }
            case '*': {
                return true;
            }
        }
        --reader.index;
        return TypeMaker.isAReferenceTypeSignature(reader);
    }

    private static String extractLocalClassName(String name) {
        if (Character.isDigit(name.charAt(0))) {
            int i;
            int len = name.length();
            for (i = 0; i < len && Character.isDigit(name.charAt(i)); ++i) {
            }
            return i == len ? null : name.substring(i);
        }
        return name;
    }

    public ObjectType makeFromDescriptorOrInternalTypeName(String descriptorOrInternalTypeName) {
        return descriptorOrInternalTypeName.charAt(0) == '[' ? this.makeFromDescriptor(descriptorOrInternalTypeName) : this.makeFromInternalTypeName(descriptorOrInternalTypeName);
    }

    public Type makeFromSignatureOrInternalTypeName(String signatureOrInternalTypeName) {
        if (signatureOrInternalTypeName == null) {
            throw new IllegalArgumentException("ObjectTypeMaker.makeFromSignatureOrInternalTypeName(signatureOrInternalTypeName) : invalid signatureOrInternalTypeName");
        }
        if (signatureOrInternalTypeName.charAt(0) == '[' || signatureOrInternalTypeName.endsWith(";")) {
            return this.makeFromSignature(signatureOrInternalTypeName);
        }
        return this.makeFromInternalTypeName(signatureOrInternalTypeName);
    }

    public ObjectType makeFromDescriptor(String descriptor) {
        ObjectType ot = descriptorToObjectType.get(descriptor);
        if (ot == null) {
            if (descriptor.charAt(0) == '[') {
                int dimension = 1;
                while (descriptor.charAt(dimension) == '[') {
                    ++dimension;
                }
                ot = (ObjectType)this.makeFromDescriptorWithoutBracket(descriptor.substring(dimension)).createType(dimension);
            } else {
                ot = this.makeFromDescriptorWithoutBracket(descriptor);
            }
            descriptorToObjectType.put(descriptor, ot);
        }
        return ot;
    }

    private ObjectType makeFromDescriptorWithoutBracket(String descriptor) {
        ObjectType ot = INTERNALNAME_TO_OBJECTPRIMITIVETYPE.get(descriptor);
        if (ot == null) {
            ot = this.makeFromInternalTypeName(descriptor.substring(1, descriptor.length() - 1));
        }
        return ot;
    }

    public ObjectType makeFromInternalTypeName(String internalTypeName) {
        if (internalTypeName == null || internalTypeName.endsWith(";")) {
            throw new IllegalArgumentException("ObjectTypeMaker.makeFromInternalTypeName(internalTypeName) : invalid internalTypeName");
        }
        ObjectType ot = this.loadType(internalTypeName);
        if (ot == null) {
            ot = TypeMaker.create(internalTypeName);
        }
        return ot;
    }

    public static ObjectType create(String internalTypeName) {
        ObjectType ot;
        int lastDollar;
        if (internalTypeName == null) {
            return null;
        }
        int lastSlash = internalTypeName.lastIndexOf(47);
        if (lastSlash < (lastDollar = internalTypeName.lastIndexOf(36))) {
            String outerTypeName = internalTypeName.substring(0, lastDollar);
            ObjectType outerSot = TypeMaker.create(outerTypeName);
            String innerName = internalTypeName.substring(outerTypeName.length() + 1);
            if (innerName.isEmpty()) {
                String qualifiedName = internalTypeName.replace('/', '.');
                String name = qualifiedName.substring(lastSlash + 1);
                ot = new ObjectType(internalTypeName, qualifiedName, name);
            } else if (Character.isDigit(innerName.charAt(0))) {
                ot = new InnerObjectType(internalTypeName, null, TypeMaker.extractLocalClassName(innerName), outerSot);
            } else {
                String qualifiedName = outerSot.getQualifiedName() + "." + innerName;
                ot = new InnerObjectType(internalTypeName, qualifiedName, innerName, outerSot);
            }
        } else {
            String qualifiedName = internalTypeName.replace('/', '.');
            String name = qualifiedName.substring(lastSlash + 1);
            ot = new ObjectType(internalTypeName, qualifiedName, name);
        }
        internalTypeNameToObjectType.put(internalTypeName, ot);
        return ot;
    }

    public ObjectType searchSuperParameterizedType(ObjectType superObjectType, ObjectType objectType) {
        if (superObjectType == ObjectType.TYPE_UNDEFINED_OBJECT || superObjectType.equals(ObjectType.TYPE_OBJECT) || superObjectType.equals(objectType)) {
            return objectType;
        }
        if (superObjectType.getDimension() > 0 || objectType.getDimension() > 0) {
            return null;
        }
        String superInternalTypeName = superObjectType.getInternalName();
        long superHashCode = (long)superInternalTypeName.hashCode() * 31L;
        return this.searchSuperParameterizedType(superHashCode, superInternalTypeName, objectType);
    }

    public boolean isAssignable(Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, ObjectType left, Type leftUnbound, ObjectType right) {
        String leftInternalTypeName;
        long leftHashCode;
        ObjectType ot;
        if (left == ObjectType.TYPE_UNDEFINED_OBJECT || right == ObjectType.TYPE_UNDEFINED_OBJECT || left.equals(ObjectType.TYPE_OBJECT) || left.equals(right)) {
            return true;
        }
        int leftDim = left.getDimension();
        int rightDim = right.getDimension();
        if (leftDim <= 0 && rightDim <= 0 && (ot = this.searchSuperParameterizedType(leftHashCode = (long)(leftInternalTypeName = left.getInternalName()).hashCode() * 31L, leftInternalTypeName, right)) != null && leftInternalTypeName.equals(ot.getInternalName())) {
            ObjectType lt;
            return left.getTypeArguments() == null || ot.getTypeArguments() == null || left.getTypeArguments().isTypeArgumentAssignableFrom(this, typeBindings, typeBounds, ot.getTypeArguments()) || leftUnbound instanceof ObjectType && this.isAssignable(typeBindings, typeBounds, lt = (ObjectType)leftUnbound, right);
        }
        if (leftDim == rightDim && leftDim > 0 && rightDim > 0) {
            Type leftType = left.createType(leftDim - 1);
            Type rightType = right.createType(rightDim - 1);
            if (leftType instanceof ObjectType) {
                ObjectType lt = (ObjectType)leftType;
                if (rightType instanceof ObjectType) {
                    ObjectType rt = (ObjectType)rightType;
                    return this.isAssignable(typeBindings, typeBounds, lt, rt);
                }
            }
        }
        return false;
    }

    public boolean isAssignable(Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, ObjectType left, ObjectType right) {
        return this.isAssignable(typeBindings, typeBounds, left, null, right);
    }

    public boolean isAssignable(Map<String, BaseType> typeBounds, ObjectType left, ObjectType right) {
        return this.isAssignable(Collections.emptyMap(), typeBounds, left, right);
    }

    public boolean isAssignable(ObjectType left, ObjectType right) {
        return this.isAssignable(Collections.emptyMap(), left, right);
    }

    public ObjectType searchSuperParameterizedType(long leftHashCode, String leftInternalTypeName, ObjectType right) {
        if (right.equals(ObjectType.TYPE_OBJECT)) {
            return null;
        }
        Long key = leftHashCode + (long)right.hashCode();
        if (this.superParameterizedObjectTypes.containsKey(key)) {
            return this.superParameterizedObjectTypes.get(key);
        }
        String rightInternalTypeName = right.getInternalName();
        if (leftInternalTypeName.equals(rightInternalTypeName)) {
            this.superParameterizedObjectTypes.put(key, right);
            return right;
        }
        TypeTypes rightTypeTypes = this.makeTypeTypes(rightInternalTypeName);
        if (rightTypeTypes != null) {
            ObjectType ot;
            Map<String, TypeArgument> bindings;
            BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
            if (rightTypeTypes.getTypeParameters() == null || right.getTypeArguments() == null) {
                bindings = Collections.emptyMap();
            } else {
                bindings = new HashMap<String, TypeArgument>();
                if (rightTypeTypes.getTypeParameters().isList() && right.getTypeArguments().isTypeArgumentList()) {
                    Iterator iteratorTypeParameter = rightTypeTypes.getTypeParameters().iterator();
                    Iterator iteratorTypeArgument = right.getTypeArguments().getTypeArgumentList().iterator();
                    while (iteratorTypeParameter.hasNext()) {
                        bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                    }
                } else {
                    bindings.put(((TypeParameter)rightTypeTypes.getTypeParameters().getFirst()).getIdentifier(), right.getTypeArguments().getTypeArgumentFirst());
                }
            }
            bindTypesToTypesVisitor.setBindings(bindings);
            if (rightTypeTypes.getSuperType() != null) {
                bindTypesToTypesVisitor.init();
                rightTypeTypes.getSuperType().accept(bindTypesToTypesVisitor);
                ot = (ObjectType)bindTypesToTypesVisitor.getType();
                ot = this.searchSuperParameterizedType(leftHashCode, leftInternalTypeName, ot);
                if (ot != null) {
                    this.superParameterizedObjectTypes.put(key, ot);
                    return ot;
                }
            }
            if (rightTypeTypes.getInterfaces() != null) {
                for (Type interfaze : rightTypeTypes.getInterfaces()) {
                    bindTypesToTypesVisitor.init();
                    interfaze.accept(bindTypesToTypesVisitor);
                    ot = (ObjectType)bindTypesToTypesVisitor.getType();
                    if ((ot = this.searchSuperParameterizedType(leftHashCode, leftInternalTypeName, ot)) == null) continue;
                    this.superParameterizedObjectTypes.put(key, ot);
                    return ot;
                }
            }
        }
        this.superParameterizedObjectTypes.put(key, null);
        return null;
    }

    public boolean isRawTypeAssignable(ObjectType left, ObjectType right) {
        String rightInternalName;
        if (left == ObjectType.TYPE_UNDEFINED_OBJECT || left.equals(ObjectType.TYPE_OBJECT) || left.equals(right)) {
            return true;
        }
        if (left.getDimension() > 0 || right.getDimension() > 0) {
            return false;
        }
        String leftInternalName = left.getInternalName();
        return leftInternalName.equals(rightInternalName = right.getInternalName()) || this.isRawTypeAssignable((long)leftInternalName.hashCode() * 31L, leftInternalName, rightInternalName);
    }

    private boolean isRawTypeAssignable(long leftHashCode, String leftInternalName, String rightInternalName) {
        if ("java/lang/Object".equals(rightInternalName)) {
            return false;
        }
        Long key = leftHashCode + (long)rightInternalName.hashCode();
        if (this.assignableRawTypes.containsKey(key)) {
            return this.assignableRawTypes.get(key);
        }
        String[] superClassAndInterfaceNames = hierarchy.get(rightInternalName);
        if (superClassAndInterfaceNames == null) {
            this.loadType(rightInternalName);
            superClassAndInterfaceNames = hierarchy.get(rightInternalName);
        }
        if (superClassAndInterfaceNames != null) {
            for (String name : superClassAndInterfaceNames) {
                if (!leftInternalName.equals(name)) continue;
                this.assignableRawTypes.put(key, Boolean.TRUE);
                return true;
            }
            for (String name : superClassAndInterfaceNames) {
                if (!this.isRawTypeAssignable(leftHashCode, leftInternalName, name)) continue;
                this.assignableRawTypes.put(key, Boolean.TRUE);
                return true;
            }
        }
        this.assignableRawTypes.put(key, Boolean.FALSE);
        return false;
    }

    public TypeTypes makeTypeTypes(String internalTypeName) {
        TypeTypes typeTypes;
        block6: {
            if (internalTypeNameToTypeTypes.containsKey(internalTypeName)) {
                return internalTypeNameToTypeTypes.get(internalTypeName);
            }
            typeTypes = null;
            try {
                if (this.loader.canLoad(internalTypeName)) {
                    typeTypes = this.makeTypeTypes(internalTypeName, this.loader.load(internalTypeName));
                } else if (classPathLoader.canLoad(internalTypeName)) {
                    typeTypes = this.makeTypeTypes(internalTypeName, classPathLoader.load(internalTypeName));
                }
                internalTypeNameToTypeTypes.put(internalTypeName, typeTypes);
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block6;
                throw new AssertionError();
            }
        }
        return typeTypes;
    }

    private TypeTypes makeTypeTypes(String internalTypeName, byte[] data) throws IOException {
        if (data == null) {
            return null;
        }
        try (DataInputStream reader = new DataInputStream(new ByteArrayInputStream(data));){
            Object[] constants = TypeMaker.loadClassFile(internalTypeName, reader);
            TypeMaker.skipMembers(reader);
            TypeMaker.skipMembers(reader);
            String signature = null;
            int count = reader.readUnsignedShort();
            for (int j = 0; j < count; ++j) {
                int attributeNameIndex = reader.readUnsignedShort();
                int attributeLength = reader.readInt();
                if ("Signature".equals(constants[attributeNameIndex])) {
                    signature = (String)constants[reader.readUnsignedShort()];
                    break;
                }
                reader.skipBytes(attributeLength);
            }
            String[] superClassAndInterfaceNames = hierarchy.get(internalTypeName);
            TypeTypes typeTypes = new TypeTypes();
            typeTypes.setThisType(this.makeFromInternalTypeName(internalTypeName));
            if (signature == null) {
                String superTypeName = superClassAndInterfaceNames[0];
                typeTypes.setSuperType(superTypeName == null ? null : this.makeFromInternalTypeName(superTypeName));
                switch (superClassAndInterfaceNames.length) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        typeTypes.setInterfaces(this.makeFromInternalTypeName(superClassAndInterfaceNames[1]));
                        break;
                    }
                    default: {
                        int length = superClassAndInterfaceNames.length;
                        UnmodifiableTypes list = new UnmodifiableTypes(length - 1);
                        for (int i = 1; i < length; ++i) {
                            list.add(this.makeFromInternalTypeName(superClassAndInterfaceNames[i]));
                        }
                        typeTypes.setInterfaces(list);
                        break;
                    }
                }
            } else {
                SignatureReader signatureReader = new SignatureReader(signature);
                typeTypes.setTypeParameters(this.parseTypeParameters(signatureReader));
                typeTypes.setSuperType(this.parseClassTypeSignature(signatureReader, 0));
                ObjectType firstInterface = this.parseClassTypeSignature(signatureReader, 0);
                if (firstInterface != null) {
                    ObjectType nextInterface = this.parseClassTypeSignature(signatureReader, 0);
                    if (nextInterface == null) {
                        typeTypes.setInterfaces(firstInterface);
                    } else {
                        int length = superClassAndInterfaceNames.length;
                        UnmodifiableTypes list = new UnmodifiableTypes(length - 1);
                        list.add(firstInterface);
                        do {
                            list.add(nextInterface);
                        } while ((nextInterface = this.parseClassTypeSignature(signatureReader, 0)) != null);
                        typeTypes.setInterfaces(list);
                    }
                }
            }
            TypeTypes typeTypes2 = typeTypes;
            return typeTypes2;
        }
    }

    public void setFieldType(String internalTypeName, String fieldName, Type type) {
        String key = internalTypeName + ":" + fieldName;
        TypeMaker.putInternalTypeNameFieldNameToType(key, type);
    }

    public Type makeFieldType(String internalTypeName, String fieldName, String descriptor) {
        Type type = this.loadFieldType(internalTypeName, fieldName, descriptor);
        if (type == null) {
            String key = internalTypeName + ":" + fieldName;
            type = this.makeFromSignature(descriptor);
            TypeMaker.putInternalTypeNameFieldNameToType(key, type);
        }
        return type;
    }

    private Type loadFieldType(String internalTypeName, String fieldName, String descriptor) {
        String key = internalTypeName + ":" + fieldName;
        Type type = internalTypeNameFieldNameToType.get(key);
        if (type == null && loaded.computeIfAbsent(internalTypeName, this::loadFieldsAndMethods).booleanValue()) {
            TypeTypes typeTypes;
            type = internalTypeNameFieldNameToType.get(key);
            if (type == null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null) {
                if (typeTypes.getSuperType() != null) {
                    type = this.loadFieldType(typeTypes.getSuperType(), fieldName, descriptor);
                }
                if (type == null && typeTypes.getInterfaces() != null) {
                    if (typeTypes.getInterfaces().isList()) {
                        Type interfaze;
                        Iterator iterator = typeTypes.getInterfaces().iterator();
                        while (iterator.hasNext() && (type = this.loadFieldType((ObjectType)(interfaze = (Type)iterator.next()), fieldName, descriptor)) == null) {
                        }
                    } else {
                        type = this.loadFieldType((ObjectType)typeTypes.getInterfaces().getFirst(), fieldName, descriptor);
                    }
                }
            }
            if (type != null) {
                TypeMaker.putInternalTypeNameFieldNameToType(key, type);
            }
        }
        return type;
    }

    private Type loadFieldType(ObjectType objectType, String fieldName, String descriptor) {
        TypeTypes typeTypes;
        String internalTypeName = objectType.getInternalName();
        BaseTypeArgument typeArguments = objectType.getTypeArguments();
        Type type = this.loadFieldType(internalTypeName, fieldName, descriptor);
        if (type != null && typeArguments != null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null && typeTypes.getTypeParameters() != null) {
            BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
            HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
            if (typeTypes.getTypeParameters().isList() && typeArguments.isTypeArgumentList()) {
                Iterator iteratorTypeParameter = typeTypes.getTypeParameters().iterator();
                Iterator iteratorTypeArgument = typeArguments.getTypeArgumentList().iterator();
                while (iteratorTypeParameter.hasNext()) {
                    bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                }
            } else {
                bindings.put(((TypeParameter)typeTypes.getTypeParameters().getFirst()).getIdentifier(), typeArguments.getTypeArgumentFirst());
            }
            bindTypesToTypesVisitor.setBindings(bindings);
            bindTypesToTypesVisitor.init();
            type.accept(bindTypesToTypesVisitor);
            type = (Type)bindTypesToTypesVisitor.getType();
        }
        return type;
    }

    public void setMethodReturnedType(String internalTypeName, String methodName, String descriptor, Type type) {
        this.makeMethodTypes(internalTypeName, methodName, descriptor).setReturnedType(type);
    }

    public MethodTypes makeMethodTypes(String internalTypeName, String methodName, String descriptor) {
        MethodTypes methodTypes = this.loadMethodTypes(internalTypeName, methodName, descriptor);
        if (methodTypes == null) {
            String key = internalTypeName + ":" + methodName + descriptor;
            methodTypes = this.parseMethodSignature(internalTypeName, methodName, descriptor, null);
            internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
        }
        return methodTypes;
    }

    private MethodTypes loadMethodTypes(String internalTypeName, String methodName, String descriptor) {
        String key = internalTypeName + ":" + methodName + descriptor;
        MethodTypes methodTypes = internalTypeNameMethodNameDescriptorToMethodTypes.get(key);
        if (methodTypes == null && loaded.computeIfAbsent(internalTypeName, this::loadFieldsAndMethods).booleanValue()) {
            TypeTypes typeTypes;
            methodTypes = internalTypeNameMethodNameDescriptorToMethodTypes.get(key);
            if (methodTypes == null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null) {
                if (typeTypes.getSuperType() != null) {
                    methodTypes = this.loadMethodTypes(typeTypes.getSuperType(), methodName, descriptor);
                }
                if (methodTypes == null && typeTypes.getInterfaces() != null) {
                    if (typeTypes.getInterfaces().isList()) {
                        Type interfaze;
                        Iterator iterator = typeTypes.getInterfaces().iterator();
                        while (iterator.hasNext() && (methodTypes = this.loadMethodTypes((ObjectType)(interfaze = (Type)iterator.next()), methodName, descriptor)) == null) {
                        }
                    } else {
                        methodTypes = this.loadMethodTypes((ObjectType)typeTypes.getInterfaces().getFirst(), methodName, descriptor);
                    }
                }
            }
            if (methodTypes != null) {
                internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
            }
        }
        return methodTypes;
    }

    private MethodTypes loadMethodTypes(ObjectType objectType, String methodName, String descriptor) {
        TypeTypes typeTypes;
        String internalTypeName = objectType.getInternalName();
        BaseTypeArgument typeArguments = objectType.getTypeArguments();
        MethodTypes methodTypes = this.loadMethodTypes(internalTypeName, methodName, descriptor);
        if (methodTypes != null && typeArguments != null && (typeTypes = this.makeTypeTypes(internalTypeName)) != null && typeTypes.getTypeParameters() != null) {
            BindTypesToTypesVisitor bindTypesToTypesVisitor = new BindTypesToTypesVisitor();
            HashMap<String, TypeArgument> bindings = new HashMap<String, TypeArgument>();
            MethodTypes newMethodTypes = new MethodTypes();
            if (typeTypes.getTypeParameters().isList() && typeArguments.isTypeArgumentList()) {
                Iterator iteratorTypeParameter = typeTypes.getTypeParameters().iterator();
                Iterator iteratorTypeArgument = typeArguments.getTypeArgumentList().iterator();
                while (iteratorTypeParameter.hasNext()) {
                    bindings.put(((TypeParameter)iteratorTypeParameter.next()).getIdentifier(), (TypeArgument)iteratorTypeArgument.next());
                }
            } else {
                bindings.put(((TypeParameter)typeTypes.getTypeParameters().getFirst()).getIdentifier(), typeArguments.getTypeArgumentFirst());
            }
            bindTypesToTypesVisitor.setBindings(bindings);
            if (methodTypes.getParameterTypes() == null) {
                newMethodTypes.setParameterTypes(null);
            } else {
                bindTypesToTypesVisitor.init();
                methodTypes.getParameterTypes().accept(bindTypesToTypesVisitor);
                BaseType baseType = bindTypesToTypesVisitor.getType();
                if (baseType.isList() && baseType.isTypes()) {
                    baseType = new UnmodifiableTypes((Collection<Type>)baseType.getList());
                }
                newMethodTypes.setParameterTypes(baseType);
            }
            bindTypesToTypesVisitor.init();
            methodTypes.getReturnedType().accept(bindTypesToTypesVisitor);
            newMethodTypes.setReturnedType((Type)bindTypesToTypesVisitor.getType());
            newMethodTypes.setTypeParameters(null);
            newMethodTypes.setExceptionTypes(methodTypes.getExceptionTypes());
            methodTypes = newMethodTypes;
        }
        return methodTypes;
    }

    private ObjectType loadType(String internalTypeName) {
        ObjectType ot;
        block6: {
            ot = internalTypeNameToObjectType.get(internalTypeName);
            if (ot == null) {
                try {
                    if (this.loader.canLoad(internalTypeName)) {
                        ot = this.loadType(internalTypeName, this.loader.load(internalTypeName));
                    } else if (classPathLoader.canLoad(internalTypeName)) {
                        ot = this.loadType(internalTypeName, classPathLoader.load(internalTypeName));
                    }
                    internalTypeNameToObjectType.put(internalTypeName, Optional.ofNullable(ot).orElse(ObjectType.TYPE_UNDEFINED_OBJECT));
                }
                catch (Exception e) {
                    if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block6;
                    throw new AssertionError();
                }
            }
        }
        return ot;
    }

    private ObjectType loadType(String internalTypeName, byte[] data) throws IOException {
        try (DataInputStream reader = new DataInputStream(new ByteArrayInputStream(data));){
            Object[] constants = TypeMaker.loadClassFile(internalTypeName, reader);
            TypeMaker.skipMembers(reader);
            TypeMaker.skipMembers(reader);
            String outerTypeName = null;
            ObjectType outerObjectType = null;
            int count = reader.readUnsignedShort();
            HashSet<String> innerTypeNames = new HashSet<String>();
            block7: for (int i = 0; i < count; ++i) {
                int attributeNameIndex = reader.readUnsignedShort();
                int attributeLength = reader.readInt();
                if ("InnerClasses".equals(constants[attributeNameIndex])) {
                    int innerClassesCount = reader.readUnsignedShort();
                    for (int j = 0; j < innerClassesCount; ++j) {
                        int innerTypeIndex = reader.readUnsignedShort();
                        int outerTypeIndex = reader.readUnsignedShort();
                        reader.skipBytes(4);
                        Integer cc = (Integer)constants[innerTypeIndex];
                        String innerTypeName = (String)constants[cc];
                        innerTypeNames.add(innerTypeName);
                        if (!innerTypeName.equals(internalTypeName)) continue;
                        if (outerTypeIndex == 0) {
                            int lastDollar = internalTypeName.lastIndexOf(36);
                            if (lastDollar == -1) break block7;
                            outerTypeName = internalTypeName.substring(0, lastDollar);
                            outerObjectType = this.loadType(outerTypeName);
                            break block7;
                        }
                        cc = (Integer)constants[outerTypeIndex];
                        outerTypeName = (String)constants[cc];
                        outerObjectType = this.loadType(outerTypeName);
                        break block7;
                    }
                    break;
                }
                reader.skipBytes(attributeLength);
            }
            if (outerObjectType == null) {
                int lastSlash = internalTypeName.lastIndexOf(47);
                String qualifiedName = internalTypeName.replace('/', '.');
                String name = qualifiedName.substring(lastSlash + 1);
                ObjectType objectType = new ObjectType(internalTypeName, qualifiedName, name, innerTypeNames);
                return objectType;
            }
            int index = outerTypeName != null && internalTypeName.length() > outerTypeName.length() + 1 ? outerTypeName.length() : internalTypeName.lastIndexOf(36);
            String innerName = internalTypeName.substring(index + 1);
            if (Character.isDigit(innerName.charAt(0))) {
                InnerObjectType name = new InnerObjectType(internalTypeName, null, TypeMaker.extractLocalClassName(innerName), innerTypeNames, outerObjectType);
                return name;
            }
            String qualifiedName = outerObjectType.getQualifiedName() + "." + innerName;
            InnerObjectType innerObjectType = new InnerObjectType(internalTypeName, qualifiedName, innerName, innerTypeNames, outerObjectType);
            return innerObjectType;
        }
    }

    public boolean loadFieldsAndMethods(String internalTypeName) {
        block4: {
            try {
                if (this.loader.canLoad(internalTypeName)) {
                    this.loadFieldsAndMethods(internalTypeName, this.loader.load(internalTypeName));
                    return true;
                }
                if (classPathLoader.canLoad(internalTypeName)) {
                    this.loadFieldsAndMethods(internalTypeName, classPathLoader.load(internalTypeName));
                    return true;
                }
            }
            catch (Exception e) {
                if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block4;
                throw new AssertionError();
            }
        }
        return false;
    }

    private void loadFieldsAndMethods(String internalTypeName, byte[] data) throws IOException {
        if (data != null) {
            try (DataInputStream reader = new DataInputStream(new ByteArrayInputStream(data));){
                String signature;
                int descriptorIndex;
                int nameIndex;
                Object[] constants = TypeMaker.loadClassFile(internalTypeName, reader);
                int count = reader.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    reader.skipBytes(2);
                    nameIndex = reader.readUnsignedShort();
                    descriptorIndex = reader.readUnsignedShort();
                    signature = null;
                    int attributeCount = reader.readUnsignedShort();
                    for (int j = 0; j < attributeCount; ++j) {
                        int attributeNameIndex = reader.readUnsignedShort();
                        int attributeLength = reader.readInt();
                        if ("Signature".equals(constants[attributeNameIndex])) {
                            signature = (String)constants[reader.readUnsignedShort()];
                            continue;
                        }
                        reader.skipBytes(attributeLength);
                    }
                    String name = (String)constants[nameIndex];
                    String descriptor = (String)constants[descriptorIndex];
                    String key = internalTypeName + ":" + name;
                    if (signature == null) {
                        TypeMaker.putInternalTypeNameFieldNameToType(key, this.makeFromSignature(descriptor));
                        continue;
                    }
                    TypeMaker.putInternalTypeNameFieldNameToType(key, this.makeFromSignature(signature));
                }
                count = reader.readUnsignedShort();
                for (int i = 0; i < count; ++i) {
                    String name;
                    int accessFlags = reader.readUnsignedShort();
                    nameIndex = reader.readUnsignedShort();
                    descriptorIndex = reader.readUnsignedShort();
                    signature = null;
                    String[] exceptionTypeNames = null;
                    int attributeCount = reader.readUnsignedShort();
                    block16: for (int j = 0; j < attributeCount; ++j) {
                        int attributeNameIndex = reader.readUnsignedShort();
                        int attributeLength = reader.readInt();
                        switch (name = (String)constants[attributeNameIndex]) {
                            case "Signature": {
                                signature = (String)constants[reader.readUnsignedShort()];
                                continue block16;
                            }
                            case "Exceptions": {
                                int exceptionCount = reader.readUnsignedShort();
                                if (exceptionCount <= 0) continue block16;
                                exceptionTypeNames = new String[exceptionCount];
                                for (int k2 = 0; k2 < exceptionCount; ++k2) {
                                    int exceptionClassIndex = reader.readUnsignedShort();
                                    Integer cc = (Integer)constants[exceptionClassIndex];
                                    exceptionTypeNames[k2] = (String)constants[cc];
                                }
                                continue block16;
                            }
                            default: {
                                reader.skipBytes(attributeLength);
                            }
                        }
                    }
                    name = (String)constants[nameIndex];
                    String descriptor = (String)constants[descriptorIndex];
                    String key = internalTypeName + ":" + name + descriptor;
                    MethodTypes methodTypes = signature == null ? this.parseMethodSignature(internalTypeName, name, descriptor, exceptionTypeNames) : this.parseMethodSignature(internalTypeName, name, descriptor, signature, exceptionTypeNames);
                    methodTypes.setAccessFlags(accessFlags);
                    internalTypeNameMethodNameDescriptorToMethodTypes.put(key, methodTypes);
                    int parameterCount = methodTypes.getParameterTypes() == null ? 0 : methodTypes.getParameterTypes().size();
                    key = internalTypeName + ":" + name + ":" + parameterCount;
                    if (parameterCount > 0) {
                        internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.computeIfAbsent(key, k -> new HashSet()).add(methodTypes.getParameterTypes());
                        continue;
                    }
                    internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.computeIfAbsent(key, k -> Collections.emptySet());
                }
            }
        }
    }

    private static void putInternalTypeNameFieldNameToType(String key, Type value) {
        internalTypeNameFieldNameToType.put(key, value);
    }

    private static Object[] loadClassFile(String internalTypeName, DataInput reader) throws IOException {
        String superClassName;
        int magic = reader.readInt();
        if (magic != -889275714) {
            throw new ClassFormatException("Invalid CLASS file");
        }
        reader.skipBytes(4);
        Object[] constants = TypeMaker.loadConstants(reader);
        reader.skipBytes(4);
        int superClassIndex = reader.readUnsignedShort();
        if (superClassIndex == 0) {
            superClassName = null;
        } else {
            Integer cc = (Integer)constants[superClassIndex];
            superClassName = (String)constants[cc];
        }
        int count = reader.readUnsignedShort();
        String[] superClassAndInterfaceNames = new String[count + 1];
        superClassAndInterfaceNames[0] = superClassName;
        for (int i = 1; i <= count; ++i) {
            int interfaceIndex = reader.readUnsignedShort();
            Integer cc = (Integer)constants[interfaceIndex];
            superClassAndInterfaceNames[i] = (String)constants[cc];
        }
        hierarchy.put(internalTypeName, superClassAndInterfaceNames);
        return constants;
    }

    private static void skipMembers(DataInput reader) throws IOException {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            reader.skipBytes(6);
            TypeMaker.skipAttributes(reader);
        }
    }

    private static Object[] loadConstants(DataInput reader) throws IOException {
        int count = reader.readUnsignedShort();
        if (count == 0) {
            throw new ClassFormatException("Zero-length constant pool");
        }
        Object[] constants = new Object[count];
        block8: for (int i = 1; i < count; ++i) {
            byte tag = reader.readByte();
            switch (tag) {
                case 1: {
                    constants[i] = reader.readUTF();
                    continue block8;
                }
                case 7: {
                    constants[i] = reader.readUnsignedShort();
                    continue block8;
                }
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    reader.skipBytes(2);
                    continue block8;
                }
                case 15: {
                    reader.skipBytes(3);
                    continue block8;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 17: 
                case 18: {
                    reader.skipBytes(4);
                    continue block8;
                }
                case 5: 
                case 6: {
                    reader.skipBytes(8);
                    ++i;
                    continue block8;
                }
                default: {
                    throw new ClassFormatException("Invalid constant pool entry");
                }
            }
        }
        return constants;
    }

    private static void skipAttributes(DataInput reader) throws IOException {
        int count = reader.readUnsignedShort();
        for (int i = 0; i < count; ++i) {
            reader.skipBytes(2);
            int attributeLength = reader.readInt();
            reader.skipBytes(attributeLength);
        }
    }

    public int matchCount(String internalTypeName, String name, int parameterCount, boolean constructor) {
        String suffixKey = ":" + name + ":" + parameterCount;
        return this.getSetOfParameterTypes(internalTypeName, suffixKey, constructor).size();
    }

    public int matchCount(Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, String internalTypeName, String name, BaseExpression parameters, boolean constructor) {
        int parameterCount = parameters.size();
        String suffixKey = ":" + name + ":" + parameterCount;
        Set<BaseType> setOfParameterTypes = this.getSetOfParameterTypes(internalTypeName, suffixKey, constructor);
        if (parameterCount == 0 || setOfParameterTypes.size() <= 1 || parameters instanceof LambdaIdentifiersExpression) {
            return setOfParameterTypes.size();
        }
        int counter = 0;
        for (BaseType parameterTypes : setOfParameterTypes) {
            if (!this.match(typeBindings, typeBounds, parameterTypes, parameters)) continue;
            ++counter;
        }
        return counter;
    }

    private Set<BaseType> getSetOfParameterTypes(String internalTypeName, String suffixKey, boolean constructor) {
        String key = internalTypeName + suffixKey;
        Set<BaseType> setOfParameterTypes = internalTypeNameMethodNameParameterCountToParameterTypes.get(key);
        if (setOfParameterTypes == null) {
            Set<BaseType> declaredParameterTypes;
            TypeTypes typeTypes;
            setOfParameterTypes = new HashSet<BaseType>();
            if (!constructor && (typeTypes = this.makeTypeTypes(internalTypeName)) != null) {
                if (typeTypes.getSuperType() != null) {
                    setOfParameterTypes.addAll(this.getSetOfParameterTypes(typeTypes.getSuperType().getInternalName(), suffixKey, constructor));
                }
                if (typeTypes.getInterfaces() != null) {
                    for (Type interfaceType : typeTypes.getInterfaces()) {
                        setOfParameterTypes.addAll(this.getSetOfParameterTypes(interfaceType.getInternalName(), suffixKey, constructor));
                    }
                }
            }
            if ((declaredParameterTypes = internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.get(key)) == null && loaded.computeIfAbsent(internalTypeName, this::loadFieldsAndMethods).booleanValue()) {
                declaredParameterTypes = internalTypeNameMethodNameParameterCountToDeclaredParameterTypes.get(key);
            }
            if (declaredParameterTypes != null) {
                setOfParameterTypes.addAll(declaredParameterTypes);
            }
            internalTypeNameMethodNameParameterCountToParameterTypes.put(key, setOfParameterTypes);
        }
        return setOfParameterTypes;
    }

    private boolean match(Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, BaseType parameterTypes, BaseExpression parameters) {
        if (parameterTypes.size() != parameters.size()) {
            return false;
        }
        switch (parameterTypes.size()) {
            case 0: {
                return true;
            }
            case 1: {
                return this.match(typeBindings, typeBounds, (Type)parameterTypes.getFirst(), ((Expression)parameters.getFirst()).getType());
            }
        }
        Iterator iteratorType = parameterTypes.getList().iterator();
        Iterator iteratorExpression = parameters.getList().iterator();
        while (iteratorType.hasNext()) {
            if (this.match(typeBindings, typeBounds, (Type)iteratorType.next(), ((Expression)iteratorExpression.next()).getType())) continue;
            return false;
        }
        return true;
    }

    private boolean match(Map<String, TypeArgument> typeBindings, Map<String, BaseType> typeBounds, Type leftType, Type rightType) {
        if (leftType.equals(rightType)) {
            return true;
        }
        if (leftType.isPrimitiveType() && rightType.isPrimitiveType()) {
            int flags = ((PrimitiveType)leftType).getFlags() | ((PrimitiveType)rightType).getFlags();
            return flags != 0;
        }
        if (leftType.isObjectType() && rightType.isObjectType()) {
            ObjectType ot1 = (ObjectType)leftType;
            ObjectType ot2 = (ObjectType)rightType;
            return this.isAssignable(typeBindings, typeBounds, ot1, ot2);
        }
        return false;
    }

    static {
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_BOOLEAN.getInternalName(), ObjectType.TYPE_PRIMITIVE_BOOLEAN);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_BYTE.getInternalName(), ObjectType.TYPE_PRIMITIVE_BYTE);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_CHAR.getInternalName(), ObjectType.TYPE_PRIMITIVE_CHAR);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_DOUBLE.getInternalName(), ObjectType.TYPE_PRIMITIVE_DOUBLE);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_FLOAT.getInternalName(), ObjectType.TYPE_PRIMITIVE_FLOAT);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_INT.getInternalName(), ObjectType.TYPE_PRIMITIVE_INT);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_LONG.getInternalName(), ObjectType.TYPE_PRIMITIVE_LONG);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_SHORT.getInternalName(), ObjectType.TYPE_PRIMITIVE_SHORT);
        INTERNALNAME_TO_OBJECTPRIMITIVETYPE.put(ObjectType.TYPE_PRIMITIVE_VOID.getInternalName(), ObjectType.TYPE_PRIMITIVE_VOID);
        loaded = new HashMap<String, Boolean>();
        signatureToType = new HashMap<String, Type>(1024);
        internalTypeNameFieldNameToType = new HashMap<String, Type>(1024);
        descriptorToObjectType = new HashMap<String, ObjectType>(1024);
        internalTypeNameToObjectType = new HashMap<String, ObjectType>(1024);
        internalTypeNameToTypeTypes = new HashMap<String, TypeTypes>(1024);
        internalTypeNameMethodNameParameterCountToDeclaredParameterTypes = new HashMap<String, Set<BaseType>>(1024);
        internalTypeNameMethodNameParameterCountToParameterTypes = new HashMap<String, Set<BaseType>>(1024);
        internalTypeNameMethodNameDescriptorToMethodTypes = new HashMap<String, MethodTypes>(1024);
        hierarchy = new HashMap<String, String[]>(1024);
        classPathLoader = new ClassPathLoader();
    }

    public static class TypeTypes {
        private ObjectType thisType;
        private BaseTypeParameter typeParameters;
        private ObjectType superType;
        private BaseType interfaces;

        public BaseTypeParameter getTypeParameters() {
            return this.typeParameters;
        }

        private void setTypeParameters(BaseTypeParameter typeParameters) {
            this.typeParameters = typeParameters;
        }

        public ObjectType getThisType() {
            return this.thisType;
        }

        private void setThisType(ObjectType thisType) {
            this.thisType = thisType;
        }

        public BaseType getInterfaces() {
            return this.interfaces;
        }

        private void setInterfaces(BaseType interfaces) {
            this.interfaces = interfaces;
        }

        public ObjectType getSuperType() {
            return this.superType;
        }

        private void setSuperType(ObjectType superType) {
            this.superType = superType;
        }
    }

    static class SignatureReader {
        private final String signature;
        private final char[] array;
        private final int length;
        int index;

        public SignatureReader(String signature) {
            this(signature, 0);
        }

        public SignatureReader(String signature, int index) {
            this.signature = signature;
            this.array = signature.toCharArray();
            this.length = this.array.length;
            this.index = index;
        }

        public char read() {
            return this.array[this.index++];
        }

        public boolean nextEqualsTo(char c) {
            return this.index < this.length && this.array[this.index] == c;
        }

        public boolean search(char c) {
            for (int i = this.index; i < this.array.length; ++i) {
                if (this.array[i] != c) continue;
                this.index = i;
                return true;
            }
            return false;
        }

        public char searchEndMarker() {
            while (this.index < this.array.length) {
                char c = this.array[this.index];
                if (c == ';' || c == '<' || c == '.') {
                    return c;
                }
                ++this.index;
            }
            return '\u0000';
        }

        public boolean available() {
            return this.index < this.length;
        }

        public String substring(int beginIndex) {
            return new String(this.array, beginIndex, this.index - beginIndex);
        }

        public String toString() {
            return "SignatureReader{index=" + this.index + ", nextChars=" + new String(this.array, this.index, this.length - this.index) + "}";
        }
    }

    public static class MethodTypes {
        private BaseTypeParameter typeParameters;
        private BaseType parameterTypes;
        private Type returnedType;
        private BaseType exceptionTypes;
        private int accessFlags;

        public boolean isVarArgs() {
            return (this.accessFlags & 0x80) != 0;
        }

        public int getAccessFlags() {
            return this.accessFlags;
        }

        public void setAccessFlags(int accessFlags) {
            this.accessFlags = accessFlags;
        }

        public BaseType getParameterTypes() {
            return this.parameterTypes;
        }

        void setParameterTypes(BaseType parameterTypes) {
            this.parameterTypes = parameterTypes;
        }

        public Type getReturnedType() {
            return this.returnedType;
        }

        void setReturnedType(Type returnedType) {
            this.returnedType = returnedType;
        }

        public BaseType getExceptionTypes() {
            return this.exceptionTypes;
        }

        void setExceptionTypes(BaseType exceptionTypes) {
            this.exceptionTypes = exceptionTypes;
        }

        public BaseTypeParameter getTypeParameters() {
            return this.typeParameters;
        }

        private void setTypeParameters(BaseTypeParameter typeParameters) {
            this.typeParameters = typeParameters;
        }

        public void handlePolymorphicSignature(String typeName, String name) {
            block5: {
                if ("java/lang/invoke/MethodHandle".equals(typeName) || "java/lang/invoke/VarHandle".equals(typeName)) {
                    try {
                        String fullyQualifiedName = typeName.replace('/', '.');
                        Class<?> clazz = Class.forName(fullyQualifiedName);
                        for (Method method : clazz.getMethods()) {
                            if (!method.getName().equals(name)) continue;
                            for (Annotation annotation : method.getAnnotations()) {
                                if (!annotation.annotationType().getSimpleName().contains("PolymorphicSignature")) continue;
                                this.setReturnedType(new GenericType("XXX"));
                            }
                        }
                    }
                    catch (ClassNotFoundException | SecurityException e) {
                        if ($assertionsDisabled || ExceptionUtil.printStackTrace(e)) break block5;
                        throw new AssertionError();
                    }
                }
            }
        }
    }
}

